/**
 *
 */
package com.ptteng.sca.micro.mall.client;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.micro.mall.model.Deposit;
import com.ptteng.micro.mall.service.DepositService;

import java.util.List;
import java.util.Map;

public class DepositSCAClient implements DepositService {

    private DepositService depositService;

    public DepositService getDepositService() {
        return depositService;
    }


    public void setDepositService(DepositService depositService) {
        this.depositService = depositService;
    }


    @Override
    public Long insert(Deposit deposit) throws ServiceException, ServiceDaoException {

        return depositService.insert(deposit);


    }


    @Override
    public List<Deposit> insertList(List<Deposit> depositList) throws ServiceException, ServiceDaoException {

        return depositService.insertList(depositList);


    }


    @Override
    public boolean delete(Long id) throws ServiceException, ServiceDaoException {

        return depositService.delete(id);


    }


    @Override
    public boolean update(Deposit deposit) throws ServiceException, ServiceDaoException {

        return depositService.update(deposit);


    }


    @Override
    public boolean updateList(List<Deposit> depositList) throws ServiceException, ServiceDaoException {

        return depositService.updateList(depositList);


    }


    @Override
    public Deposit getObjectById(Long id) throws ServiceException, ServiceDaoException {

        return depositService.getObjectById(id);


    }


    @Override
    public List<Deposit> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {

        return depositService.getObjectsByIds(ids);


    }


    /**
     *
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public List<Long> getDepositIdsByMerchantId(Long merchantId, Integer start, Integer limit) throws ServiceException, ServiceDaoException {

        return depositService.getDepositIdsByMerchantId(merchantId, start, limit);


    }


    /**
     *
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public Integer countDepositIdsByMerchantId(Long merchantId) throws ServiceException, ServiceDaoException {

        return depositService.countDepositIdsByMerchantId(merchantId);


    }


    @Override
    public List<Long> getDepositIds(Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {
        // TODO Auto-generated method stub
        return depositService.getDepositIds(start, limit);
    }

    @Override
    public Integer countDepositIds() throws ServiceException, ServiceDaoException {
        // TODO Auto-generated method stub
        return depositService.countDepositIds();
    }

    @Override
    public List<Long> getDepositIdsByWorkerIdAndStatus(Long workerId, Integer status, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        return depositService.getDepositIdsByWorkerIdAndStatus(workerId,status,start, limit);
    }


    @Override
    public List<Long> getIdsByDynamicCondition(Class clz, Map<String, Object> conditions, Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {
        // TODO Auto-generated method stub
        return depositService.getIdsByDynamicCondition(clz, conditions, start, limit);
    }


    @Override
    public boolean fakeDelete(Class clz, Long id) throws ServiceException, ServiceDaoException {
        // TODO Auto-generated method stub
        return depositService.fakeDelete(clz, id);
    }


    @Override
    public void deleteList(Class clz, List<Long> ids) throws ServiceException, ServiceDaoException {
        depositService.deleteList(clz, ids);

    }

    @Override
    public Object getObjectByDynamicCondition(Class clz,
                                              Map<String, Object> conditions, Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {

        return this.depositService.getObjectByDynamicCondition(clz, conditions, start, limit);
    }

    @Override
    public Object getMapListByDynamicCondition(Class clz,
                                               Map<String, Object> conditions, Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {

        return this.depositService.getMapListByDynamicCondition(clz, conditions, start, limit);
    }


}

