/**
 * 
 */
package com.ptteng.sca.micro.mall.client;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.micro.mall.model.Customer;
import com.ptteng.micro.mall.service.CustomerService;

import java.util.List;
import java.util.Map;

public class CustomerSCAClient implements CustomerService {

    private CustomerService customerService;

	public CustomerService getCustomerService() {
		return customerService;
	}
	
	
	public void setCustomerService(CustomerService customerService) {
		this.customerService =customerService;
	}
	
	
			   
		@Override
		public Long insert(Customer customer)throws ServiceException, ServiceDaoException{
		
		return customerService.insert(customer);
		          
		
		}	
		  
    	   
		@Override
		public List<Customer> insertList(List<Customer> customerList)throws ServiceException, ServiceDaoException{
		
		return customerService.insertList(customerList);
		          
		
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
		return customerService.delete(id);
		          
		
		}	
		  
    	   
		@Override
		public boolean update(Customer customer)throws ServiceException, ServiceDaoException{
		
		return customerService.update(customer);
		          
		
		}	
		  
    	   
		@Override
		public boolean updateList(List<Customer> customerList)throws ServiceException, ServiceDaoException{
		
		return customerService.updateList(customerList);
		          
		
		}	
		  
    	   
		@Override
		public Customer getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
		return customerService.getObjectById(id);
		          
		
		}	
		  
    	   
		@Override
		public List<Customer> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
		return customerService.getObjectsByIds(ids);
		          
		
		}	
		  
    	
	
	
	
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getCustomerIdsByMerchantIdAndType(Long merchantId,Integer type,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		return customerService.getCustomerIdsByMerchantIdAndType(merchantId,type,start,limit);
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getCustomerIdsByMerchantId(Long merchantId,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		return customerService.getCustomerIdsByMerchantId(merchantId,start,limit);
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getCustomerIdsByMerchantIdAndStatus(Long merchantId,Integer status,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		return customerService.getCustomerIdsByMerchantIdAndStatus(merchantId,status,start,limit);
	
	
	}
	
		
	
	
    			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countCustomerIdsByMerchantIdAndType(Long merchantId,Integer type)throws ServiceException, ServiceDaoException{
		
		return customerService.countCustomerIdsByMerchantIdAndType(merchantId,type);
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countCustomerIdsByMerchantId(Long merchantId)throws ServiceException, ServiceDaoException{
		
		return customerService.countCustomerIdsByMerchantId(merchantId);
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countCustomerIdsByMerchantIdAndStatus(Long merchantId,Integer status)throws ServiceException, ServiceDaoException{
		
		return customerService.countCustomerIdsByMerchantIdAndStatus(merchantId,status);
	
	
	}
	
		
	
		@Override
	public List<Long> getCustomerIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return customerService.getCustomerIds(start, limit);
	}

	@Override
	public Integer countCustomerIds() throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return customerService.countCustomerIds();
	}
	
	
	@Override
	public List<Long> getIdsByDynamicCondition(Class clz, Map<String, Object> conditions, Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return customerService.getIdsByDynamicCondition(clz, conditions, start, limit);
	}


	@Override
	public boolean fakeDelete(Class clz, Long id) throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return customerService.fakeDelete(clz, id);
	}
	
	
	
	@Override
	public void deleteList(Class clz, List<Long> ids) throws ServiceException, ServiceDaoException {
		   customerService.deleteList(clz, ids);
		
	}
	
	@Override
	public Object getObjectByDynamicCondition(Class clz,
			Map<String, Object> conditions, Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
	
		return this.customerService.getObjectByDynamicCondition(clz, conditions, start, limit);
	}
	@Override
	public Object getMapListByDynamicCondition(Class clz,
			Map<String, Object> conditions, Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {

		return this.customerService.getMapListByDynamicCondition(clz, conditions, start, limit);
	}


 
}

