/**
 * 
 */
package com.ptteng.sca.micro.mall.client;

import java.util.List;
import java.util.Map;

import com.ptteng.micro.mall.model.Address;
import com.ptteng.micro.mall.service.AddressService;
import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;

public class AddressSCAClient implements AddressService {

    private AddressService addressService;

	public AddressService getAddressService() {
		return addressService;
	}
	
	
	public void setAddressService(AddressService addressService) {
		this.addressService =addressService;
	}
	
	
			   
		@Override
		public Long insert(Address address)throws ServiceException, ServiceDaoException{
		
		return addressService.insert(address);
		          
		
		}	
		  
    	   
		@Override
		public List<Address> insertList(List<Address> addressList)throws ServiceException, ServiceDaoException{
		
		return addressService.insertList(addressList);
		          
		
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
		return addressService.delete(id);
		          
		
		}	
		  
    	   
		@Override
		public boolean update(Address address)throws ServiceException, ServiceDaoException{
		
		return addressService.update(address);
		          
		
		}	
		  
    	   
		@Override
		public boolean updateList(List<Address> addressList)throws ServiceException, ServiceDaoException{
		
		return addressService.updateList(addressList);
		          
		
		}	
		  
    	   
		@Override
		public Address getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
		return addressService.getObjectById(id);
		          
		
		}	
		  
    	   
		@Override
		public List<Address> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
		return addressService.getObjectsByIds(ids);
		          
		
		}	
		  
    	
	
	
	
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getAddressIdsByUserIdAndMerchantId(Long userId,Long merchantId,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		return addressService.getAddressIdsByUserIdAndMerchantId(userId,merchantId,start,limit);
	
	
	}
	
		
	
	
    			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countAddressIdsByUserIdAndMerchantId(Long userId,Long merchantId)throws ServiceException, ServiceDaoException{
		
		return addressService.countAddressIdsByUserIdAndMerchantId(userId,merchantId);
	
	
	}
	
		
	
		@Override
	public List<Long> getAddressIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return addressService.getAddressIds(start, limit);
	}

	@Override
	public Integer countAddressIds() throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return addressService.countAddressIds();
	}
	
	
	@Override
	public List<Long> getIdsByDynamicCondition(Class clz, Map<String, Object> conditions, Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return addressService.getIdsByDynamicCondition(clz, conditions, start, limit);
	}


	@Override
	public boolean fakeDelete(Class clz, Long id) throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return addressService.fakeDelete(clz, id);
	}
	
	
	
	@Override
	public void deleteList(Class clz, List<Long> ids) throws ServiceException, ServiceDaoException {
		   addressService.deleteList(clz, ids);
		
	}
	
	@Override
	public Object getObjectByDynamicCondition(Class clz,
			Map<String, Object> conditions, Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
	
		return this.addressService.getObjectByDynamicCondition(clz, conditions, start, limit);
	}

	@Override
	public Object getMapListByDynamicCondition(Class clz,
											   Map<String, Object> conditions, Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {

		return this.addressService.getMapListByDynamicCondition(clz, conditions, start, limit);
	}


}

