package com.ptteng.micro.mall.service;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.dao.BaseDaoService;
import com.ptteng.micro.mall.model.Worker;
import org.osoa.sca.annotations.Remotable;

import java.util.List;

@Remotable
public interface WorkerService extends BaseDaoService {


    public Long insert(Worker worker) throws ServiceException, ServiceDaoException;


    public List<Worker> insertList(List<Worker> workerList) throws ServiceException, ServiceDaoException;


    public boolean delete(Long id) throws ServiceException, ServiceDaoException;


    public boolean update(Worker worker) throws ServiceException, ServiceDaoException;


    public boolean updateList(List<Worker> workerList) throws ServiceException, ServiceDaoException;


    public Worker getObjectById(Long id) throws ServiceException, ServiceDaoException;


    public List<Worker> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Integer countWorkerIdsByMerchantId(Long merchantId) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getWorkerIdsByMerchantId(Long merchantId, Integer start, Integer limit) throws ServiceException, ServiceDaoException;

    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Long getWorkerIdByMobile(String mobile) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getWorkerIds(Integer start, Integer limit)
            throws ServiceException, ServiceDaoException;

    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Integer countWorkerIds() throws ServiceException, ServiceDaoException;


}

