package com.ptteng.micro.mall.service;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.dao.BaseDaoService;
import com.ptteng.micro.mall.model.StockOut;
import org.osoa.sca.annotations.Remotable;

import java.util.List;

@Remotable
public interface StockOutService extends BaseDaoService {

	



   		   
		
		public Long insert(StockOut stockOut)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<StockOut> insertList(List<StockOut> stockOutList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean delete(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean update(StockOut stockOut)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean updateList(List<StockOut> stockOutList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public StockOut getObjectById(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<StockOut> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException;
		  
    	
	


			
			
	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer  countStockOutIdsBySkuId(Long skuId)throws ServiceException, ServiceDaoException;
			
			
	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer  countStockOutIdsBySpuId(Long spuId)throws ServiceException, ServiceDaoException;
					
			
	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getStockOutIdsBySkuId(Long skuId, Integer start, Integer limit)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getStockOutIdsBySpuId(Long spuId, Integer start, Integer limit)throws ServiceException, ServiceDaoException;
		
	
	
	
	/**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long> getStockOutIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException;

	/**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer countStockOutIds() throws ServiceException, ServiceDaoException;
	

}

