package com.ptteng.micro.mall.service;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.dao.BaseDaoService;
import com.ptteng.micro.mall.model.Deposit;
import org.osoa.sca.annotations.Remotable;

import java.util.List;

@Remotable
public interface DepositService extends BaseDaoService {


    public Long insert(Deposit deposit) throws ServiceException, ServiceDaoException;


    public List<Deposit> insertList(List<Deposit> depositList) throws ServiceException, ServiceDaoException;


    public boolean delete(Long id) throws ServiceException, ServiceDaoException;


    public boolean update(Deposit deposit) throws ServiceException, ServiceDaoException;


    public boolean updateList(List<Deposit> depositList) throws ServiceException, ServiceDaoException;


    public Deposit getObjectById(Long id) throws ServiceException, ServiceDaoException;


    public List<Deposit> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Integer countDepositIdsByMerchantId(Long merchantId) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getDepositIdsByMerchantId(Long merchantId, Integer start, Integer limit) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getDepositIds(Integer start, Integer limit)
            throws ServiceException, ServiceDaoException;

    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Integer countDepositIds() throws ServiceException, ServiceDaoException;

    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getDepositIdsByWorkerIdAndStatus(Long workerId, Integer status, Integer start, Integer limit) throws ServiceException, ServiceDaoException;



}

