package com.ptteng.micro.mall.service;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.dao.BaseDaoService;
import com.ptteng.micro.mall.model.Customer;
import org.osoa.sca.annotations.Remotable;

import java.util.List;

@Remotable
public interface CustomerService extends BaseDaoService {

	



   		   
		
		public Long insert(Customer customer)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<Customer> insertList(List<Customer> customerList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean delete(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean update(Customer customer)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean updateList(List<Customer> customerList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public Customer getObjectById(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<Customer> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException;
		  
    	
	


			
			
	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer  countCustomerIdsByMerchantIdAndType(Long merchantId, Integer type)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer  countCustomerIdsByMerchantId(Long merchantId)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer  countCustomerIdsByMerchantIdAndStatus(Long merchantId, Integer status)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getCustomerIdsByMerchantIdAndType(Long merchantId, Integer type, Integer start, Integer limit)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getCustomerIdsByMerchantId(Long merchantId, Integer start, Integer limit)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getCustomerIdsByMerchantIdAndStatus(Long merchantId, Integer status, Integer start, Integer limit)throws ServiceException, ServiceDaoException;
		
	
	
	
	/**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long> getCustomerIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException;

	/**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer countCustomerIds() throws ServiceException, ServiceDaoException;
	

}

