package com.ptteng.micro.mall.model;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import javax.persistence.*;
import java.io.Serializable;


@Entity
@Table(name = "worker")
public class Worker implements Serializable {

    /**
     *
     */
    private static final long serialVersionUID = 3473115166805018624L;


    /**
     * 已缴纳
     */
    public static final Integer TYPE_PAID = 10;

    /**
     * 申请退还
     */
    public static final Integer TYPE_APPLY_FOR_REFUND = 15;

    /**
     * 已退还
     */
    public static final Integer TYPE_REFUNDED = 25;

    /**
     * 未缴纳
     */
    public static final Integer TYPE_NOT_PAY = 20;
    /**
     * 已通过实名认证
     */
    public static final Integer TYPE_VERIFIED = 10;

    /**
     * 未通过实名认证
     */
    public static final Integer TYPE_NOT_YET_VERIFIED = 20;

    /*
     开始接单
    * */
    public static final Integer TYPE_READY_FOR_ORDER = 10;

    /*
     停止接单
    * */
    public static final Integer TYPE_NOT_READY_FOR_ORDER = 20;
    public static final Integer STATUS_FOLLOWED = 10;
    public static final Integer STATUS_NOT_FOLLOWED = 20;


    /**
     * 主键ID
     */
    private Long id;


    /**
     * 商户Id
     */
    private Long merchantId;
    /**
     * 微官网Id
     */
    private Long userId;


    /**
     * 手机号
     */
    private String mobile;


    /**
     * 闪工姓名
     */
    private String name;

    /*昵称
     * */
    private String nickName;


    /**
     * 区域
     */
    private String locationInfo;

    /*
     * 维度
     * */
    private Double latitude;

    /*
     * 经度
     * */
    private Double longitude;

    /**
     * 身份证号
     */
    private String idNumber;


    /**
     * 身份证照片
     */
    private String idCardInfo;


    /**
     * 保证金缴纳状态
     */
    private Integer depositStatus;


    /**
     * 实名认证状态
     */
    private Integer verifiedStatus;

    /**
     * 是否关注了微信服务号
     */
    private Integer followStatus;

    /**
     * 开工状态
     */
    private Integer workStatus;


    /**
     * 平均评价
     */
    private Double averageEvaluation;


    /**
     * 平均工时
     */
    private Long averageDuration;

    private Long startTime;
    /**
     * 完成单数
     */
    private Integer completionNumber;


    /**
     * 创建时间
     */
    private Long createAt;


    /**
     * 更新时间
     */
    private Long updateAt;


    /**
     * 创建人
     */
    private Long createBy;


    /**
     * 更新人
     */
    private Long updateBy;


    @Id
    @Column(name = "id")
    public Long getId() {
        return id;
    }


    public void setId(Long id) {
        this.id = id;
    }

    @Column(name = "merchant_id")
    public Long getMerchantId() {
        return merchantId;
    }

    @Column(name = "user_id")
    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public void setMerchantId(Long merchantId) {
        this.merchantId = merchantId;
    }

    @Column(name = "mobile")
    public String getMobile() {
        return mobile;
    }


    public void setMobile(String mobile) {
        this.mobile = mobile;
    }

    @Column(name = "name")
    public String getName() {
        return name;
    }


    public void setName(String name) {
        this.name = name;
    }

    @Column(name = "nick_name")
    public String getNickName() {
        return nickName;
    }

    public void setNickName(String nickName) {
        this.nickName = nickName;
    }

    @Column(name = "location_info")
    public String getLocationInfo() {
        return locationInfo;
    }

    @Column(name = "latitude")
    public Double getLatitude() {
        return latitude;
    }

    public void setLatitude(Double latitude) {
        this.latitude = latitude;
    }

    @Column(name = "longitude")
    public Double getLongitude() {
        return longitude;
    }

    public void setLongitude(Double longitude) {
        this.longitude = longitude;
    }

    public void setLocationInfo(String locationInfo) {
        this.locationInfo = locationInfo;
    }

    @Column(name = "id_number")
    public String getIdNumber() {
        return idNumber;
    }


    public void setIdNumber(String idNumber) {
        this.idNumber = idNumber;
    }

    @Column(name = "id_card_info")
    public String getIdCardInfo() {
        return idCardInfo;
    }


    public void setIdCardInfo(String idCardInfo) {
        this.idCardInfo = idCardInfo;
    }

    @Column(name = "deposit_status")
    public Integer getDepositStatus() {
        return depositStatus;
    }


    public void setDepositStatus(Integer depositStatus) {
        this.depositStatus = depositStatus;
    }

    @Column(name = "follow_status")
    public Integer getFollowStatus() {
        return followStatus;
    }

    public void setFollowStatus(Integer followStatus) {
        this.followStatus = followStatus;
    }

    @Column(name = "verified_status")
    public Integer getVerifiedStatus() {
        return verifiedStatus;
    }


    public void setVerifiedStatus(Integer verifiedStatus) {
        this.verifiedStatus = verifiedStatus;
    }

    @Column(name = "work_status")
    public Integer getWorkStatus() {
        return workStatus;
    }


    public void setWorkStatus(Integer workStatus) {
        this.workStatus = workStatus;
    }

    @Column(name = "average_evaluation")
    public Double getAverageEvaluation() {
        return averageEvaluation;
    }


    public void setAverageEvaluation(Double averageEvaluation) {
        this.averageEvaluation = averageEvaluation;
    }

    @Column(name = "average_duration")
    public Long getAverageDuration() {
        return averageDuration;
    }


    public void setAverageDuration(Long averageDuration) {
        this.averageDuration = averageDuration;
    }

    @Column(name = "completion_number")
    public Integer getCompletionNumber() {
        return completionNumber;
    }


    public void setCompletionNumber(Integer completionNumber) {
        this.completionNumber = completionNumber;
    }

    @Column(name = "create_at")
    public Long getCreateAt() {
        return createAt;
    }


    public void setCreateAt(Long createAt) {
        this.createAt = createAt;
    }

    @Column(name = "update_at")
    public Long getUpdateAt() {
        return updateAt;
    }


    public void setUpdateAt(Long updateAt) {
        this.updateAt = updateAt;
    }

    @Column(name = "create_by")
    public Long getCreateBy() {
        return createBy;
    }


    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    @Column(name = "update_by")
    public Long getUpdateBy() {
        return updateBy;
    }


    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    @Column(name = "start_time")
    public Long getStartTime() {
        return startTime;
    }

    public void setStartTime(Long startTime) {
        this.startTime = startTime;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString(this,
                ToStringStyle.MULTI_LINE_STYLE);
    }

}

