package com.ptteng.micro.mall.model;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import javax.persistence.*;
import java.io.Serializable;
import java.math.BigDecimal;


@Entity
@Table(name = "stock_out")
public class StockOut implements Serializable{

	/**
	 *
	 */
	private static final long serialVersionUID = 6973629514135924736L;

    public static final Integer CLIENT_WX = 2;
    public static final Integer CLIENT_ADMIN = 1;
	/**
	 *  自动
	 *
	 */
	public static final Integer ACTION_TYPE_SYS = 1;

	/**
	 *  手动
	 *
	 */
	public static final Integer ACTION_TYPE_MANUAL = 2;


   /**
   *  自增长ID
   *
   */
    private  Long id;


   /**
   *  品类id
   *
   */
    private  Long classifyId;


   /**
   *  商品品类
   *
   */
    private  String classifyDesc;


   /**
   *  商品id
   *
   */
    private  Long spuId;


   /**
   *  商品明
   *
   */
    private  String spuTitle;


   /**
   *  出库量
   *
   */
    private  Integer amount;


   /**
   *  仓储库存
   *
   */
    private  Integer warehouseStock;


   /**
   *  备注
   *
   */
    private  String description;


   /**
   *  skuid
   *
   */
    private  Long skuId;


   /**
   *  sku名
   *
   */
    private  String skuTitle;


   /**
   *  出库日期
   *
   */
    private  Long outboundDate;

	private BigDecimal outboundPrice;
   /**
   *  操作类型
   *
   */
    private  Integer actionType;


   /**
   *  出库单号
   *
   */
    private  String outboundNo;


   /**
   *  商户id
   *
   */
    private  Long merchantId;


   /**
   *  创建时间
   *
   */
    private  Long createAt;


   /**
   *  更新时间
   *
   */
    private  Long updateAt;


   /**
   *  创建人
   *
   */
    private  Long createBy;


   /**
   *  更新人
   *
   */
    private  Long updateBy;


    private Integer client;

    private Long customerId;

    private String customerName;

    private Integer numerator;

    private Integer denominator;

    private Integer packageNum;
    private BigDecimal totalPrice;

    @Id
     	   @GeneratedValue(strategy = GenerationType.AUTO)
              	@Column(name = "id")
	public Long getId() {
		return id;
	}


	public void setId(Long id) {
		this.id = id;
	}
		 	@Column(name = "classify_id")
	public Long getClassifyId() {
		return classifyId;
	}


	public void setClassifyId(Long classifyId) {
		this.classifyId = classifyId;
	}
		 	@Column(name = "classify_desc")
	public String getClassifyDesc() {
		return classifyDesc;
	}


	public void setClassifyDesc(String classifyDesc) {
		this.classifyDesc = classifyDesc;
	}
		 	@Column(name = "spu_id")
	public Long getSpuId() {
		return spuId;
	}


	public void setSpuId(Long spuId) {
		this.spuId = spuId;
	}
		 	@Column(name = "spu_title")
	public String getSpuTitle() {
		return spuTitle;
	}


	public void setSpuTitle(String spuTitle) {
		this.spuTitle = spuTitle;
	}
		 	@Column(name = "amount")
	public Integer getAmount() {
		return amount;
	}


	public void setAmount(Integer amount) {
		this.amount = amount;
	}
		 	@Column(name = "warehouse_stock")
	public Integer getWarehouseStock() {
		return warehouseStock;
	}


	public void setWarehouseStock(Integer warehouseStock) {
		this.warehouseStock = warehouseStock;
	}
		 	@Column(name = "description")
	public String getDescription() {
		return description;
	}


	public void setDescription(String description) {
		this.description = description;
	}
		 	@Column(name = "sku_id")
	public Long getSkuId() {
		return skuId;
	}


	public void setSkuId(Long skuId) {
		this.skuId = skuId;
	}
		 	@Column(name = "sku_title")
	public String getSkuTitle() {
		return skuTitle;
	}


	public void setSkuTitle(String skuTitle) {
		this.skuTitle = skuTitle;
	}
		 	@Column(name = "outbound_date")
	public Long getOutboundDate() {
		return outboundDate;
	}


	public void setOutboundDate(Long outboundDate) {
		this.outboundDate = outboundDate;
	}
		 	@Column(name = "action_type")
	public Integer getActionType() {
		return actionType;
	}


	public void setActionType(Integer actionType) {
		this.actionType = actionType;
	}
		 	@Column(name = "outbound_no")
	public String getOutboundNo() {
		return outboundNo;
	}


	public void setOutboundNo(String outboundNo) {
		this.outboundNo = outboundNo;
	}
		 	@Column(name = "merchant_id")
	public Long getMerchantId() {
		return merchantId;
	}


	public void setMerchantId(Long merchantId) {
		this.merchantId = merchantId;
	}
		 	@Column(name = "create_at")
	public Long getCreateAt() {
		return createAt;
	}


	public void setCreateAt(Long createAt) {
		this.createAt = createAt;
	}
		 	@Column(name = "update_at")
	public Long getUpdateAt() {
		return updateAt;
	}


	public void setUpdateAt(Long updateAt) {
		this.updateAt = updateAt;
	}
		 	@Column(name = "create_by")
	public Long getCreateBy() {
		return createBy;
	}


	public void setCreateBy(Long createBy) {
		this.createBy = createBy;
	}
		 	@Column(name = "update_by")
	public Long getUpdateBy() {
		return updateBy;
	}


	public void setUpdateBy(Long updateBy) {
		this.updateBy = updateBy;
	}
    @Column(name = "client")
    public Integer getClient() {
        return client;
    }

    public void setClient(Integer client) {
        this.client = client;
    }
    @Column(name = "customer_id")
    public Long getCustomerId() {
        return customerId;
    }

    public void setCustomerId(Long customerId) {
        this.customerId = customerId;
    }
    @Column(name = "customer_name")
    public String getCustomerName() {
        return customerName;
    }

    public void setCustomerName(String customerName) {
        this.customerName = customerName;
    }

	@Column(name = "outbound_price")
	public BigDecimal getOutboundPrice() {
		return outboundPrice;
	}

	public void setOutboundPrice(BigDecimal outboundPrice) {
		this.outboundPrice = outboundPrice;
	}
    @Column(name = "numerator")
    public Integer getNumerator() {
        return numerator;
    }

    public void setNumerator(Integer numerator) {
        this.numerator = numerator;
    }
    @Column(name = "denominator")
    public Integer getDenominator() {
        return denominator;
    }

    public void setDenominator(Integer denominator) {
        this.denominator = denominator;
    }
    @Column(name = "package_num")
    public Integer getPackageNum() {
        return packageNum;
    }

    public void setPackageNum(Integer packageNum) {
        this.packageNum = packageNum;
    }
    @Column(name = "total_price")
    public BigDecimal getTotalPrice() {
        return totalPrice;
    }

    public void setTotalPrice(BigDecimal totalPrice) {
        this.totalPrice = totalPrice;
    }

    @Override
    public String toString() {
		return ToStringBuilder.reflectionToString(this,
				ToStringStyle.MULTI_LINE_STYLE);
	}

}

