package com.ptteng.micro.mall.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;

import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;


@Entity
@Table(name = "requirement")
public class Requirement implements Serializable{

	/**
	 * 
	 */
	private static final long serialVersionUID = 8430486371081314304L;	
	
		
	/**
	 *  搬运装卸
	 * 
	 */
	public static final String TYPE_TRANSPORT = "1";
    	
	/**
	 *  安装
	 * 
	 */
	public static final String TYPE_INSTALL = "2";
    	
	/**
	 *  兼职
	 * 
	 */
	public static final String TYPE_PART_TIME = "3";
    	
	/**
	 *  闪工帮帮
	 * 
	 */
	public static final String TYPE_SG = "4";

	public static final List<String> require_type = Arrays.asList(TYPE_TRANSPORT, TYPE_INSTALL, TYPE_PART_TIME,TYPE_SG);
    	
   
   /**
   *  自增长ID
   *
   */
    private  Long id;
	
  
   /**
   *  联系电话
   *
   */
    private  String mobile;
	
  
   /**
   *  城市
   *
   */
    private  String city;
	
  
   /**
   *  源地址信息
   *
   */
    private  String FromAddr;
	
  
   /**
   *  目标地址信息
   *
   */
    private  String ToAddr;
	
  
   /**
   *  描述
   *
   */
    private  String description;
	
  
   /**
   *  需求类型
   *
   */
    private  String type;
	
  
   /**
   *  顾客姓名
   *
   */
    private  String customerName;
	
  
   /**
   *  性别
   *
   */
    private  Integer customerGender;
	
  
   /**
   *  商户id
   *
   */
    private  Long merchantId;
	
  
   /**
   *  开始时间
   *
   */
    private  Long startTime;
	
  
   /**
   *  数量
   *
   */
    private  Integer cnt;
	
  
   /**
   *  时长
   *
   */
    private  Integer duration;
	
  
   /**
   *  用户id
   *
   */
    private  Long userId;
	
  
   /**
   *  创建时间
   *
   */
    private  Long createAt;
	
  
   /**
   *  更新时间
   *
   */
    private  Long updateAt;
	
  
   /**
   *  创建人
   *
   */
    private  Long createBy;
	
  
   /**
   *  更新人
   *
   */
    private  Long updateBy;
	
  
	
		 	
         	 	   @Id
     	   @GeneratedValue(strategy = GenerationType.AUTO)
              	@Column(name = "id")
	public Long getId() {
		return id;
	}
	
	
	public void setId(Long id) {
		this.id = id;
	}
		 	@Column(name = "mobile")
	public String getMobile() {
		return mobile;
	}
	
	
	public void setMobile(String mobile) {
		this.mobile = mobile;
	}
		 	@Column(name = "city")
	public String getCity() {
		return city;
	}
	
	
	public void setCity(String city) {
		this.city = city;
	}
		 	@Column(name = "from_addr")
	public String getFromAddr() {
		return FromAddr;
	}
	
	
	public void setFromAddr(String FromAddr) {
		this.FromAddr = FromAddr;
	}
		 	@Column(name = "to_addr")
	public String getToAddr() {
		return ToAddr;
	}
	
	
	public void setToAddr(String ToAddr) {
		this.ToAddr = ToAddr;
	}
		 	@Column(name = "description")
	public String getDescription() {
		return description;
	}
	
	
	public void setDescription(String description) {
		this.description = description;
	}
		 	@Column(name = "type")
	public String getType() {
		return type;
	}
	
	
	public void setType(String type) {
		this.type = type;
	}
		 	@Column(name = "customer_name")
	public String getCustomerName() {
		return customerName;
	}
	
	
	public void setCustomerName(String customerName) {
		this.customerName = customerName;
	}
		 	@Column(name = "customer_gender")
	public Integer getCustomerGender() {
		return customerGender;
	}
	
	
	public void setCustomerGender(Integer customerGender) {
		this.customerGender = customerGender;
	}
		 	@Column(name = "merchant_id")
	public Long getMerchantId() {
		return merchantId;
	}
	
	
	public void setMerchantId(Long merchantId) {
		this.merchantId = merchantId;
	}
		 	@Column(name = "start_time")
	public Long getStartTime() {
		return startTime;
	}
	
	
	public void setStartTime(Long startTime) {
		this.startTime = startTime;
	}
		 	@Column(name = "cnt")
	public Integer getCnt() {
		return cnt;
	}
	
	
	public void setCnt(Integer cnt) {
		this.cnt = cnt;
	}
		 	@Column(name = "duration")
	public Integer getDuration() {
		return duration;
	}
	
	
	public void setDuration(Integer duration) {
		this.duration = duration;
	}
		 	@Column(name = "user_id")
	public Long getUserId() {
		return userId;
	}
	
	
	public void setUserId(Long userId) {
		this.userId = userId;
	}
		 	@Column(name = "create_at")
	public Long getCreateAt() {
		return createAt;
	}
	
	
	public void setCreateAt(Long createAt) {
		this.createAt = createAt;
	}
		 	@Column(name = "update_at")
	public Long getUpdateAt() {
		return updateAt;
	}
	
	
	public void setUpdateAt(Long updateAt) {
		this.updateAt = updateAt;
	}
		 	@Column(name = "create_by")
	public Long getCreateBy() {
		return createBy;
	}
	
	
	public void setCreateBy(Long createBy) {
		this.createBy = createBy;
	}
		 	@Column(name = "update_by")
	public Long getUpdateBy() {
		return updateBy;
	}
	
	
	public void setUpdateBy(Long updateBy) {
		this.updateBy = updateBy;
	}
		
	public String toString() {
		return ToStringBuilder.reflectionToString(this,
				ToStringStyle.MULTI_LINE_STYLE);
	}

}

