package com.ptteng.micro.mall.model;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import javax.persistence.*;
import java.io.Serializable;
import java.math.BigDecimal;


@Entity
@Table(name = "deposit")
public class Deposit implements Serializable {

    /**
     *
     */
    private static final long serialVersionUID = 1877931783499482112L;


    /**
     * 已缴纳
     */
    public static final Integer TYPE_PAID = 10;

    /**
     * 申请退还
     */
    public static final Integer TYPE_APPLY_FOR_REFUND = 15;

    /**
     * 已退还
     */
    public static final Integer TYPE_REFUNDED = 25;

    /**
     * 未缴纳
     */
    public static final Integer TYPE_NOT_YET_PAY = 20;

    public static final Integer TYPE_REFUSE_REFUND = 20;
    public static final Integer TYPE_AGREE_REFUND = 10;


    /**
     * 自增长ID
     */
    private Long id;


    /**
     * 商户Id
     */
    private Long merchantId;


    /**
     * 闪工Id
     */
    private Long workerId;


    /**
     * 缴纳时间
     */
    private Long depositTime;


    /**
     * 申请时间
     */
    private Long applyTime;


    /**
     * 状态
     */
    private Integer status;

    /**
     * 拒绝理由
     */
    private String reason;

    /**
     * 是否批准
     */
    private Integer ifAgree;


    /**
     * 平均评价
     */
    private BigDecimal amount;


    /**
     * 创建时间
     */
    private Long createAt;


    /**
     * 更新时间
     */
    private Long updateAt;


    /**
     * 创建人
     */
    private Long createBy;


    /**
     * 更新人
     */
    private Long updateBy;


    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    @Column(name = "id")
    public Long getId() {
        return id;
    }


    public void setId(Long id) {
        this.id = id;
    }

    @Column(name = "merchant_id")
    public Long getMerchantId() {
        return merchantId;
    }


    public void setMerchantId(Long merchantId) {
        this.merchantId = merchantId;
    }

    @Column(name = "worker_id")
    public Long getWorkerId() {
        return workerId;
    }


    public void setWorkerId(Long workerId) {
        this.workerId = workerId;
    }

    @Column(name = "deposit_time")
    public Long getDepositTime() {
        return depositTime;
    }


    public void setDepositTime(Long depositTime) {
        this.depositTime = depositTime;
    }

    @Column(name = "apply_time")
    public Long getApplyTime() {
        return applyTime;
    }


    public void setApplyTime(Long applyTime) {
        this.applyTime = applyTime;
    }

    @Column(name = "status")
    public Integer getStatus() {
        return status;
    }


    public void setStatus(Integer status) {
        this.status = status;
    }

    @Column(name = "reason")
    public String getReason() {
        return reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    @Column(name = "if_agree")
    public Integer getIfAgree() {
        return ifAgree;
    }


    public void setIfAgree(Integer ifAgree) {
        this.ifAgree = ifAgree;
    }

    @Column(name = "amount")
    public BigDecimal getAmount() {
        return amount;
    }


    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    @Column(name = "create_at")
    public Long getCreateAt() {
        return createAt;
    }


    public void setCreateAt(Long createAt) {
        this.createAt = createAt;
    }

    @Column(name = "update_at")
    public Long getUpdateAt() {
        return updateAt;
    }


    public void setUpdateAt(Long updateAt) {
        this.updateAt = updateAt;
    }

    @Column(name = "create_by")
    public Long getCreateBy() {
        return createBy;
    }


    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    @Column(name = "update_by")
    public Long getUpdateBy() {
        return updateBy;
    }


    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString(this,
                ToStringStyle.MULTI_LINE_STYLE);
    }

}

