/**
 * 
 */
package com.ptteng.sca.micro.mall.client;

import java.util.List;
import java.util.Map;

import com.ptteng.micro.mall.model.Sku;
import com.ptteng.micro.mall.service.SkuService;
import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;

public class SkuSCAClient implements SkuService {

    private SkuService skuService;

	public SkuService getSkuService() {
		return skuService;
	}
	
	
	public void setSkuService(SkuService skuService) {
		this.skuService =skuService;
	}
	
	
			   
		@Override
		public Long insert(Sku sku)throws ServiceException, ServiceDaoException{
		
		return skuService.insert(sku);
		          
		
		}	
		  
    	   
		@Override
		public List<Sku> insertList(List<Sku> skuList)throws ServiceException, ServiceDaoException{
		
		return skuService.insertList(skuList);
		          
		
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
		return skuService.delete(id);
		          
		
		}	
		  
    	   
		@Override
		public boolean update(Sku sku)throws ServiceException, ServiceDaoException{
		
		return skuService.update(sku);
		          
		
		}	
		  
    	   
		@Override
		public boolean updateList(List<Sku> skuList)throws ServiceException, ServiceDaoException{
		
		return skuService.updateList(skuList);
		          
		
		}	
		  
    	   
		@Override
		public Sku getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
		return skuService.getObjectById(id);
		          
		
		}	
		  
    	   
		@Override
		public List<Sku> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
		return skuService.getObjectsByIds(ids);
		          
		
		}	
		  
    	
	
	
	
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getSkuIdsByMerchantId(Long merchantId,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		return skuService.getSkuIdsByMerchantId(merchantId,start,limit);
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getSkuIdsBySpuIdAndStatus(Long spuId,Integer status,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		return skuService.getSkuIdsBySpuIdAndStatus(spuId,status,start,limit);
	
	
	}
	
		
	
	
    			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countSkuIdsByMerchantId(Long merchantId)throws ServiceException, ServiceDaoException{
		
		return skuService.countSkuIdsByMerchantId(merchantId);
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countSkuIdsBySpuIdAndStatus(Long spuId,Integer status)throws ServiceException, ServiceDaoException{
		
		return skuService.countSkuIdsBySpuIdAndStatus(spuId,status);
	
	
	}
	
		
	
		@Override
	public List<Long> getSkuIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return skuService.getSkuIds(start, limit);
	}

	@Override
	public Integer countSkuIds() throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return skuService.countSkuIds();
	}
	
	
	@Override
	public List<Long> getIdsByDynamicCondition(Class clz, Map<String, Object> conditions, Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return skuService.getIdsByDynamicCondition(clz, conditions, start, limit);
	}


	@Override
	public boolean fakeDelete(Class clz, Long id) throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return skuService.fakeDelete(clz, id);
	}
	
	
	
	@Override
	public void deleteList(Class clz, List<Long> ids) throws ServiceException, ServiceDaoException {
		   skuService.deleteList(clz, ids);
		
	}
	
	@Override
	public Object getObjectByDynamicCondition(Class clz,
			Map<String, Object> conditions, Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
	
		return this.skuService.getObjectByDynamicCondition(clz, conditions, start, limit);
	}


 
}

