package com.ptteng.micro.mall.service;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.dao.BaseDaoService;
import com.ptteng.micro.mall.model.Address;
import org.osoa.sca.annotations.Remotable;

import java.util.List;

@Remotable
public interface AddressService extends BaseDaoService {

	



   		   
		
		public Long insert(Address address)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<Address> insertList(List<Address> addressList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean delete(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean update(Address address)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean updateList(List<Address> addressList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public Address getObjectById(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<Address> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException;
		  
    	
	


			
			
	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer  countAddressIdsByUserIdAndMerchantId(Long userId, Long merchantId)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getAddressIdsByUserIdAndMerchantId(Long userId, Long merchantId, Integer start, Integer limit)throws ServiceException, ServiceDaoException;
		
	
	
	
	/**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long> getAddressIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException;

	/**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer countAddressIds() throws ServiceException, ServiceDaoException;
	

}

