package com.ptteng.micro.common.service;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.dao.BaseDaoService;
import com.ptteng.micro.common.model.Temp;
import org.osoa.sca.annotations.Remotable;

import java.util.List;

@Remotable
public interface TempService extends BaseDaoService {
    public Long insert(Temp temp)throws ServiceException, ServiceDaoException;



    public List<Temp> insertList(List<Temp> tempList)throws ServiceException, ServiceDaoException;



    public boolean delete(Long id)throws ServiceException, ServiceDaoException;



    public boolean update(Temp temp)throws ServiceException, ServiceDaoException;



    public boolean updateList(List<Temp> tempList)throws ServiceException, ServiceDaoException;



    public Temp getObjectById(Long id)throws ServiceException, ServiceDaoException;



    public List<Temp> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException;

    /**
     *
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getTempIds(Integer start, Integer limit)
            throws ServiceException, ServiceDaoException;

    /**
     *
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Integer countTempIds() throws ServiceException, ServiceDaoException;
}
