package com.ptteng.micro.common.service;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.dao.BaseDaoService;
import com.ptteng.micro.common.model.Moments;
import org.osoa.sca.annotations.Remotable;

import java.util.List;

@Remotable
public interface MomentsService extends BaseDaoService {


    public Long insert(Moments moments) throws ServiceException, ServiceDaoException;


    public List<Moments> insertList(List<Moments> momentsList) throws ServiceException, ServiceDaoException;


    public boolean delete(Long id) throws ServiceException, ServiceDaoException;


    public boolean update(Moments moments) throws ServiceException, ServiceDaoException;


    public boolean updateList(List<Moments> momentsList) throws ServiceException, ServiceDaoException;


    public Moments getObjectById(Long id) throws ServiceException, ServiceDaoException;


    public List<Moments> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Integer countMomentsIdsByName(String name) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getMomentsIdsByName(String name, Integer start, Integer limit) throws ServiceException, ServiceDaoException;

    public List<Long> getMomentsIdsByUserIdAndMerchantId(Long userId, Long merchantId, Integer start, Integer limit) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getMomentsIds(Integer start, Integer limit)
            throws ServiceException, ServiceDaoException;

    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Integer countMomentsIds() throws ServiceException, ServiceDaoException;


}

