package com.ptteng.micro.common.service;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.dao.BaseDaoService;
import com.ptteng.micro.common.model.UserAccountRelation;
import java.util.List;
import org.osoa.sca.annotations.Remotable;

@Remotable
public interface UserAccountRelationService extends BaseDaoService {

	



   		   
		
		public Long insert(UserAccountRelation userAccountRelation)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<UserAccountRelation> insertList(List<UserAccountRelation> userAccountRelationList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean delete(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean update(UserAccountRelation userAccountRelation)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean updateList(List<UserAccountRelation> userAccountRelationList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public UserAccountRelation getObjectById(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<UserAccountRelation> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException;
		  
    	
	


			
			
	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer  countUserAccountRelationIdsByAccount(String account)throws ServiceException, ServiceDaoException;
			
			
	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer  countUserAccountRelationIdsByUid(Long uid)throws ServiceException, ServiceDaoException;
					
			
	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getUserAccountRelationIdsByAccount(String account, Integer start,
      Integer limit)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getUserAccountRelationIdsByUid(Long uid, Integer start, Integer limit)throws ServiceException, ServiceDaoException;
		

	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getUserAccountRelationIdsByUidAndType(Long uid,Integer type, Integer start, Integer limit)throws ServiceException, ServiceDaoException;

	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Long  getUserAccountRelationIdsByUidAndTypeAndAppId(Long uid,Integer type,String appId)throws ServiceException, ServiceDaoException;


	
	
	/**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long> getUserAccountRelationIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException;

	/**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer countUserAccountRelationIds() throws ServiceException, ServiceDaoException;
	

}

