package com.ptteng.micro.common.service;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.dao.BaseDaoService;
import com.ptteng.micro.common.model.Namecards;
import org.osoa.sca.annotations.Remotable;

import java.util.List;

@Remotable
public interface NamecardsService extends BaseDaoService {


    public Long insert(Namecards namecards) throws ServiceException, ServiceDaoException;


    public List<Namecards> insertList(List<Namecards> namecardsList) throws ServiceException, ServiceDaoException;


    public boolean delete(Long id) throws ServiceException, ServiceDaoException;


    public boolean update(Namecards namecards) throws ServiceException, ServiceDaoException;


    public boolean updateList(List<Namecards> namecardsList) throws ServiceException, ServiceDaoException;


    public Namecards getObjectById(Long id) throws ServiceException, ServiceDaoException;


    public List<Namecards> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Integer countNamecardsIdsByMerchantId(Long merchantId) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getNamecardsIdsByMerchantId(Long merchantId, Integer start, Integer limit) throws ServiceException, ServiceDaoException;

    public List<Long> getNamecardsIdsByMerchantIdAndUserId(Long merchantId, Long userId, Integer start, Integer limit) throws ServiceException, ServiceDaoException;

    public Long getNamecardsIdByMerchantIdAndUserIdAndStatus(Long merchantId, Long userId, Integer status) throws ServiceException, ServiceDaoException;

    public Long getNamecardsIdsByMerchantIdAndMobile(Long merchantId, String mobile) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getNamecardsIds(Integer start, Integer limit)
            throws ServiceException, ServiceDaoException;

    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Integer countNamecardsIds() throws ServiceException, ServiceDaoException;


}

