package com.ptteng.micro.common.model;

import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;


@Entity
@Table(name = "user_account_relation")
public class UserAccountRelation implements Serializable {

  /**
   *
   */
  private static final long serialVersionUID = 765502681948581888L;


  /**
   * 账号类型: 微信账号, 支付宝
   */
  public static final Integer TYPE_WX = 10;
  public static final Integer TYPE_WX_UNIONID = 30;
  public static final Integer TYPE_ALIPAY = 20;

  /**
   * 主键,自增长ID
   */
  private Long id;


  /**
   * 用户ID
   */
  private Long uid;


  /**
   * 第三方账号 唯一标识
   */
  private String account;


  /**
   * 第三方账号类型
   */
  private Integer type;


  /**
   * 创建时间
   */
  private Long createAt;


  /**
   * 创建者
   */
  private Long createBy;


  /**
   * 更新时间
   */
  private Long updateAt;


  /**
   * 更新者
   */
  private Long updateBy;
  /**
   * APPID
   */
  private String appId;


  @Id
  @GeneratedValue(strategy = GenerationType.AUTO)
  @Column(name = "id")
  public Long getId() {
    return id;
  }


  public void setId(Long id) {
    this.id = id;
  }

  @Column(name = "uid")
  public Long getUid() {
    return uid;
  }


  public void setUid(Long uid) {
    this.uid = uid;
  }

  @Column(name = "account")
  public String getAccount() {
    return account;
  }


  public void setAccount(String account) {
    this.account = account;
  }

  @Column(name = "type")
  public Integer getType() {
    return type;
  }


  public void setType(Integer type) {
    this.type = type;
  }

  @Column(name = "create_at")
  public Long getCreateAt() {
    return createAt;
  }


  public void setCreateAt(Long createAt) {
    this.createAt = createAt;
  }

  @Column(name = "create_by")
  public Long getCreateBy() {
    return createBy;
  }


  public void setCreateBy(Long createBy) {
    this.createBy = createBy;
  }

  @Column(name = "update_at")
  public Long getUpdateAt() {
    return updateAt;
  }


  public void setUpdateAt(Long updateAt) {
    this.updateAt = updateAt;
  }

  @Column(name = "update_by")
  public Long getUpdateBy() {
    return updateBy;
  }


  public void setUpdateBy(Long updateBy) {
    this.updateBy = updateBy;
  }
    @Column(name = "app_id")
    public String getAppId() {
        return appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String toString() {
    return ToStringBuilder.reflectionToString(this,
        ToStringStyle.MULTI_LINE_STYLE);
  }

}

