package com.ptteng.micro.common.model;


import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import javax.persistence.*;
import java.io.Serializable;

@Entity
@Table(name = "extra_temp")
public class ExtraTemp implements Serializable {

    /**
     * 扫码模板
     */
    public static final Integer TYPE_SCAN = 1;

    /**
     * 标签模板
     */
    public static final Integer TYPE_CODE = 2;

    /**
     * 是否为默认使用
     */
    public static final Integer IS_DEFAULT = 1;


    /**
     * 自增id
     */
    private Long id;

    /**
     * 模板名
     */
    private String name;

    /**
     * 备注
     */
    private String remark;

    /**
     * 模板id
     */
    private Long tempId;

    /**
     *  模板json
     */
    private String extraJson;

    /**
     * 模板类型
     */
    private Integer type;

    /**
     * 是否为默认
     */
    private Integer isDefault;

    /**
     * 创建时间
     */
    private Long createAt;


    /**
     * 创建者
     */
    private Long createBy;


    /**
     * 更新时间
     */
    private Long updateAt;


    /**
     * 更新者
     */
    private Long updateBy;


    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    @Column(name = "id")
    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @Column(name = "name")
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Column(name = "remark")
    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    @Column(name = "temp_id")
    public Long getTempId() {
        return tempId;
    }

    public void setTempId(Long tempId) {
        this.tempId = tempId;
    }

    @Column(name = "extra_json")
    public String getExtraJson() {
        return extraJson;
    }

    public void setExtraJson(String extraJson) {
        this.extraJson = extraJson;
    }

    @Column(name = "type")
    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    @Column(name = "is_default")
    public Integer getIsDefault() {
        return isDefault;
    }

    public void setIsDefault(Integer isDefault) {
        this.isDefault = isDefault;
    }

    @Column(name = "create_at")
    public Long getCreateAt() {
        return createAt;
    }

    public void setCreateAt(Long createAt) {
        this.createAt = createAt;
    }

    @Column(name = "create_by")
    public Long getCreateBy() {
        return createBy;
    }

    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    @Column(name = "update_at")
    public Long getUpdateAt() {
        return updateAt;
    }

    public void setUpdateAt(Long updateAt) {
        this.updateAt = updateAt;
    }

    @Column(name = "update_by")
    public Long getUpdateBy() {
        return updateBy;
    }

    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this,
                ToStringStyle.MULTI_LINE_STYLE);
    }
}
