package com.ptteng.micro.common.model;

import java.io.Serializable;
import javax.persistence.*;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;


@Entity
@Table(name = "user")
public class User implements Serializable {

    /**
     *
     */
    private static final long serialVersionUID = 1951857927738604544L;

    /**
     *
     */
    public static final Integer STATUS_ON = 1;

    /**
     *
     */
    public static final Integer STATUS_OFF = 0;

    /**
     * 主键,自增长ID
     */
    private Long id;


    /**
     * 用户ID
     */
    private Long uid;


    /**
     * 头像
     */
    private String img;


    /**
     * 用户名
     */
    private String name;
    private String number;


    /**
     * 用户绑定手机号
     */
    private String mobile;


    /**
     * 用户状态
     */
    private Integer status;


    /**
     * 创建时间
     */
    private Long createAt;


    /**
     * 创建者
     */
    private Long createBy;


    /**
     * 更新时间
     */
    private Long updateAt;


    /**
     * 更新者
     */
    private Long updateBy;


    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    @Column(name = "id")
    public Long getId() {
        return id;
    }


    public void setId(Long id) {
        this.id = id;
    }

    @Column(name = "uid")
    public Long getUid() {
        return uid;
    }


    public void setUid(Long uid) {
        this.uid = uid;
    }

    @Column(name = "img")
    public String getImg() {
        return img;
    }


    public void setImg(String img) {
        this.img = img;
    }

    @Column(name = "name")
    public String getName() {
        return name;
    }


    public void setName(String name) {
        this.name = name;
    }

    @Column(name = "mobile")
    public String getMobile() {
        return mobile;
    }


    public void setMobile(String mobile) {
        this.mobile = mobile;
    }

    @Column(name = "status")
    public Integer getStatus() {
        return status;
    }


    public void setStatus(Integer status) {
        this.status = status;
    }

    @Column(name = "create_at")
    public Long getCreateAt() {
        return createAt;
    }


    public void setCreateAt(Long createAt) {
        this.createAt = createAt;
    }

    @Column(name = "create_by")
    public Long getCreateBy() {
        return createBy;
    }


    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    @Column(name = "update_at")
    public Long getUpdateAt() {
        return updateAt;
    }


    public void setUpdateAt(Long updateAt) {
        this.updateAt = updateAt;
    }

    @Column(name = "update_by")
    public Long getUpdateBy() {
        return updateBy;
    }


    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }



}

