package com.ptteng.micro.common.service;


import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import org.osoa.sca.annotations.Remotable;

import java.util.Map;

/**支付订单接口
 * @author 
 *
 */
@Remotable
public interface PayOrderService {

	public String payTest(String code, String type);


	/**
	 * 支付
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public String pay(String userid, String merchantOrderId, String merchantOrderTime, String merchantOrderName,
                      String merchantOrderAmt, String merchantOrderDesc, String frontUrl, String backUrl, String type);


	/**
	 * 提现/转账
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public String pyPay(String order_no, String to_bank_no, String to_acct_no, String to_acct_name,
                        String acct_type, String trans_amt, String trans_usage, String type);


	/**
	 * 解析通知报文
	 *
	 * @param xmlString
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public String notice(String xmlString, String type);


	/**
	 * 通知接口
	 *
	 * @param reqData  银联请求参数
	 * @param encoding 编码格式
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public boolean ylnotice(Map<String, String> reqData, String encoding, String type);

	/**
	 * 支付状态查询
	 *
	 * @param merchantOrderId
	 * @param merchantOrderTime
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	String check(String merchantOrderId, String merchantOrderTime, String type);

	/**
	 * 提现/转账状态查询
	 *
	 * @param merchantOrderId
	 * @param merchantOrderTime
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	String checkPayment(String merchantOrderId, String merchantOrderTime, String type);


	public String getParam(String key, String type);

	/**
	 * 快捷支付认证接口（同步接口，需短信确认）
	 *
	 * @param trac_no    商户跟踪号
	 * @param acct_type  卡类型：0-储蓄卡,1-信用卡
	 * @param bank_no    人行联网行号
	 * @param card_no    账号
	 * @param user_name  姓名
	 * @param cert_no    证件号码
	 * @param card_phone 联系电话
	 * @param expireDate 信用卡有效期（仅信用卡时必输，格式MMYY）
	 * @param cvn        信用卡CVN（仅信用卡时必输）
	 * @return json格式结果，返回结果包含字段请参看收付直通车代收接口文档
	 */
	public String epAuthSyncWithSms(String trac_no, String acct_type, String bank_no, String card_no, String user_name, String cert_no, String card_phone, String expireDate, String cvn, String type);

	/**
	 * 快捷认证短信验证码确认接口
	 *
	 * @param trac_no  发起同步认证时的商户跟踪号
	 * @param sms_code 6位数字短信验证码
	 * @return json格式结果，返回结果包含字段请参看收付直通车代收接口文档
	 */
	public String epAuthCheckSms(String trac_no, String sms_code, String type);
	/**
	 * 快捷支付账户认证结果查询接口
	 *
	 * @param trac_no 商户跟踪号
	 * @return json格式结果，返回结果包含字段请参看收付直通车代收接口文档
	 */
	public  String epAuthQuery(String trac_no, String type) ;
}