package com.ptteng.micro.common.service;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.micro.common.model.Version;
import com.ptteng.common.dao.BaseDaoService;
import org.osoa.sca.annotations.Remotable;

import java.util.List;

@Remotable
public interface VersionService extends BaseDaoService {

	



   		   
		
		public Long insert(Version version)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<Version> insertList(List<Version> versionList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean delete(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean update(Version version)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean updateList(List<Version> versionList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public Version getObjectById(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<Version> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException;
		  
    	
	


			
			
	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer  countVersionIdsByOsAndVersionCodeOrderByIsForceUpdate(String os, String versionCode)throws ServiceException, ServiceDaoException;
					
			
	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getVersionIdsByOsAndVersionCodeOrderByIsForceUpdate(String os, String versionCode, Integer start, Integer limit)throws ServiceException, ServiceDaoException;


	/**
	 * @Description 根据平台获取版本id
	 * @param os 平台
	 * @Author: PeiyuFeng
	 * @Time 2017/4/10 13:14
	 */
	public List<Long>  getVersionIdsByOs(String os, Integer start, Integer limit)throws ServiceException, ServiceDaoException;


	/**
	 * @Description 根据平台获取版本id并按版本code排序
	 * @param
	 * @Author: PeiyuFeng
	 * @Time 2017/4/12 20:12
	 */
	public List<Long>  getVersionIdsByOsOrderByVersionCode(String os, Integer start, Integer limit)throws ServiceException, ServiceDaoException;


	/**
	 * @Description 根据平台与版本号获取版本id
	 * @param os 平台
	 * @param code 版本号
	 * @Author: PeiyuFeng
	 * @Time 2017/4/10 13:14
	 */
	public Long  getVersionIdByOsAndVersionCode(String os, String code)throws ServiceException, ServiceDaoException;




	/**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long> getVersionIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException;

	/**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer countVersionIds() throws ServiceException, ServiceDaoException;
	

}

