package com.ptteng.micro.common.model;

import java.io.Serializable;
import java.math.BigDecimal;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;


@Entity
@Table(name = "merchant")
public class Merchant implements Serializable {

    /**
     *
     */
    private static final long serialVersionUID = 4278977928020689920L;


    /**
     * 主键,自增长ID
     */
    private Long id;

    private String name;
    /**
     * 用户ID
     */
    private Long uid;


    /**
     * 用户状态
     */
    private Integer status;


    /**
     * 微信 appid
     */
    private String appId;


    /**
     * 微信 appsecret
     */
    private String appSecret;


    /**
     * 购买次数
     */
    private Integer purchaseTime;


    /**
     * 总金额
     */
    private BigDecimal totalAmount;


    /**
     * 商户号起始时间
     */
    private Long startAt;


    /**
     * 商户号到期时间
     */
    private Long endAt;


    /**
     * 创建时间
     */
    private Long createAt;


    /**
     * 创建者
     */
    private Long createBy;


    /**
     * 更新时间
     */
    private Long updateAt;


    /**
     * 更新者
     */
    private Long updateBy;


    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    @Column(name = "id")
    public Long getId() {
        return id;
    }

    @Column(name = "name")
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @Column(name = "uid")
    public Long getUid() {
        return uid;
    }


    public void setUid(Long uid) {
        this.uid = uid;
    }

    @Column(name = "status")
    public Integer getStatus() {
        return status;
    }


    public void setStatus(Integer status) {
        this.status = status;
    }

    @Column(name = "app_id")
    public String getAppId() {
        return appId;
    }


    public void setAppId(String appId) {
        this.appId = appId;
    }

    @Column(name = "app_secret")
    public String getAppSecret() {
        return appSecret;
    }


    public void setAppSecret(String appSecret) {
        this.appSecret = appSecret;
    }

    @Column(name = "purchase_time")
    public Integer getPurchaseTime() {
        return purchaseTime;
    }


    public void setPurchaseTime(Integer purchaseTime) {
        this.purchaseTime = purchaseTime;
    }

    @Column(name = "total_amount")
    public BigDecimal getTotalAmount() {
        return totalAmount;
    }


    public void setTotalAmount(BigDecimal totalAmount) {
        this.totalAmount = totalAmount;
    }

    @Column(name = "start_at")
    public Long getStartAt() {
        return startAt;
    }


    public void setStartAt(Long startAt) {
        this.startAt = startAt;
    }

    @Column(name = "end_at")
    public Long getEndAt() {
        return endAt;
    }


    public void setEndAt(Long endAt) {
        this.endAt = endAt;
    }

    @Column(name = "create_at")
    public Long getCreateAt() {
        return createAt;
    }


    public void setCreateAt(Long createAt) {
        this.createAt = createAt;
    }

    @Column(name = "create_by")
    public Long getCreateBy() {
        return createBy;
    }


    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    @Column(name = "update_at")
    public Long getUpdateAt() {
        return updateAt;
    }


    public void setUpdateAt(Long updateAt) {
        this.updateAt = updateAt;
    }

    @Column(name = "update_by")
    public Long getUpdateBy() {
        return updateBy;
    }


    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString(this,
                ToStringStyle.MULTI_LINE_STYLE);
    }

}

