package com.ptteng.keeper.home.controller;

import com.ptteng.common.storage.util.ImgStorageUtil;
import com.ptteng.keeper.common.model.Article;
import com.ptteng.keeper.common.model.User;
import com.ptteng.keeper.common.model.UserReadRecord;
import com.ptteng.keeper.common.service.ArticleService;
import com.ptteng.keeper.common.service.UserReadRecordService;
import com.qding.common.util.DataUtils;
import com.qding.common.util.FileUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.File;
import java.util.List;
import java.util.UUID;

/**
 * Article  crud
 *
 * @author magenm
 * @Date 2014-4-16 13:43
 */
@Controller
public class ArticleController {

    private static final Log log = LogFactory.getLog("article");
    @Autowired
    private ArticleService articleService;
    @Autowired
    private UserReadRecordService userReadRecordService;

    @Autowired
    private ImgStorageUtil imgStorageUtil;

    // 图片上传
    @RequestMapping(value = "/a/u/img/{module}", method = RequestMethod.POST)
    public String uploadFile(HttpServletRequest request, HttpServletResponse response, ModelMap model,
                             @RequestParam MultipartFile file, @PathVariable String module) throws Exception {

        log.info("hello upload " + module);
        if (StringUtils.isBlank(module)) {
            module = "common";
        }
        int code = 0;
        log.info(file.getOriginalFilename());


        try {
            String type = file.getContentType();
            long size = file.getSize();
            log.info("  size is =" + size / 1048576);
            String extend = FileUtil.getFileExtension(file.getOriginalFilename());

            String fileName = UUID.randomUUID().toString() + "." + extend;
            log.info("new name is " + fileName);
            String filePath = "/data/temp/" + fileName;

            File tempPic = new File(filePath);
            file.transferTo(tempPic);
            String url = this.imgStorageUtil.imgStorage(null, module + "/" + fileName, filePath);
            log.info(module + " upload success ,and file name is " + fileName + "temp path is " + filePath
                    + " access url is " + url);
            tempPic.delete();
            log.info(file.getOriginalFilename() + " delete success ");
            model.addAttribute("url", url);
            model.addAttribute("code", 0);
            return "/common/img";
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            return "/common/success";
        }

    }

    /**
     * 资讯详情
     *
     * @param aid id
     * @return article
     * @throws Exception 异常
     */
    @RequestMapping(value = "/a/u/article/{aid}", method = RequestMethod.GET)
    public String getArticleJson(HttpServletRequest request,
                                 HttpServletResponse response, ModelMap model, @PathVariable Long aid)
            throws Exception {

        User user = (User) request.getAttribute("user");
        log.info("get article data : id= " + aid+" ,uid="+user.getId());
        try {
            if (aid == null) {
                model.addAttribute("code", -1000);
                return "/common/success";
            } else {

                Article article = articleService.getObjectById(aid);
                log.info(article);
                if (DataUtils.isNotNullOrEmpty(article)) {
                    log.info("get article data is " + article);
                    //查用户阅读记录
                    Long rid = userReadRecordService.getUserReadRecordIdByTargetIdAndUidAndStatusAndType(aid, user.getId(), UserReadRecord.STATUS_READ, UserReadRecord.TYPE_ARTICLE);
                    //设置用户文章阅读状态为已读
                    if (DataUtils.isNullOrEmpty(rid)) {
                        UserReadRecord userReadRecord = new UserReadRecord();
                        userReadRecord.setTargetId(aid);
                        userReadRecord.setUid(user.getId());
                        userReadRecord.setStatus(UserReadRecord.STATUS_READ);
                        userReadRecord.setType(UserReadRecord.TYPE_ARTICLE);
                        userReadRecord.setCreateBy(user.getId());
                        userReadRecord.setUpdateBy(user.getId());
                        Long resultId = userReadRecordService.insert(userReadRecord);
                        log.info("create user read record success, id="+resultId);
                        //给资讯累计阅读记录
                        Integer count = article.getCount();
                        log.info("article count="+count);
                        article.setCount(count+1);
                        articleService.update(article);
                        log.info("update article count success,count="+article.getCount());
                    }else {
                        log.info("user article status is read");
                    }
                    model.addAttribute("code", 0);
                    model.addAttribute("article", article);
                }else {
                    model.addAttribute("code", -1005);
                }
            }
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get article error,id is  " + aid);
            model.addAttribute("code", -100000);
        }

        return "/keeper/article/json/articleDetailJson";
    }


    /**
     * 资讯列表
     *
     * @param page 页码
     * @param size 数据量
     * @param type 所属模块
     * @return Array[article] count
     * @throws Exception 异常
     */
    @RequestMapping(value = "/a/u/article/list", method = RequestMethod.GET)
    public String getArticleList(HttpServletRequest request,
                                 HttpServletResponse response, ModelMap model, Integer page, Integer size,
                                 Integer type)
            throws Exception {
        log.info("get article list:type="+type);
        if (DataUtils.isNullOrEmpty(type)) {
            type = 1;
        }
        if (page == null) {
            page = 1;
        }
        if (size == null) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }
        Integer total = 0;
        List<Long> count = null;
        List<Long> ids = null;
        log.info("pageList : page= " + start + " , size=" + size);
        try {

            ids = articleService.getArticleIdsByTypeAndStatusOrderByPushAtAndUpdateAt(type, Article.STATUS_PUSH, start, size);
            count = articleService.getArticleIdsByTypeAndStatusOrderByPushAtAndUpdateAt(type, Article.STATUS_PUSH, 0, Integer.MAX_VALUE);
            total = count.size();
            log.info("get article list size is" + ids.size());
            log.info("get article total is" + total);


            List<Article> articleList = articleService.getObjectsByIds(ids);
            model.addAttribute("articleList", articleList);

            log.info("code : " + 0);
            model.addAttribute("total", total);
            model.addAttribute("size", size);
            model.addAttribute("page", page);
            model.addAttribute("code", 0);
        } catch (Throwable t) {
            log.error(t.getMessage());
            model.addAttribute("code", -1);
        }

        return "/keeper/article/json/articleListJson";
    }
}

