package com.ptteng.keeper.home.util;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

import javax.servlet.http.HttpServletRequest;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by asus on 2016/8/13.
 */
public class XmlUtil {

    private static final Log log = LogFactory.getLog("wx");

    public String xml(String xml) {
        String result = "";

        try {
            Document document = null;

            document = DocumentHelper.parseText(xml);
            log.info(document.toString());

            Element root = document.getRootElement();
            log.info("root : " + root.toString());
            List<Element> childElements = root.elements();
            log.info(childElements);
            Element return_code = root.element("return_code");
            log.info("return_code : " + return_code);
            Element result_code = root.element("result_code");
            log.info("result_code : " + result_code);
            Element prepay_id = null;
            if (return_code.getText().equals("SUCCESS") && result_code.getText().equals("SUCCESS")) {

                prepay_id = root.element("prepay_id");
                log.info("prepay_id is : " + prepay_id.getText());
                result = prepay_id.getText();
            }
        } catch (Exception e) {
            log.error(e);
        }


        return result;
    }

    //扫码支付相关，返回二维码codeUrl
    public Map<String, String> xmlQRcode(String xml) {
        Map<String, String> result = new HashMap();

        try {
            Document document = null;

            document = DocumentHelper.parseText(xml);
            log.info(document.toString());

            Element root = document.getRootElement();
            log.info("root : " + root.toString());
            List<Element> childElements = root.elements();
            log.info(childElements);
            Element return_code = root.element("return_code");
            log.info("return_code : " + return_code);
            Element result_code = root.element("result_code");
            log.info("result_code : " + result_code);
            Element prepay_id = null;
            Element code_url = null;
            if (return_code.getText().equals("SUCCESS") && result_code.getText().equals("SUCCESS")) {

                prepay_id = root.element("prepay_id");
                code_url = root.element("code_url");
                log.info("prepay_id is : " + prepay_id.getText() + "code_url is : " + code_url.getText());
                result.put("prepay_id", prepay_id.getText());
                result.put("code_url", code_url.getText());
            }
        } catch (Exception e) {
            log.error(e);
        }


        return result;
    }

    //获取xml参数
    public static Map<String, String> xmlParams(String xml, List<String> params) {
        Map<String, String> result = new HashMap<>();
        log.info("xmlParams: will get params is " + params);
        try {
            Document document = null;

            document = DocumentHelper.parseText(xml);
//            log.info(document.toString());

            Element root = document.getRootElement();
//            log.info("root : " + root.toString());
//            List childElements = root.elements();
//            log.info(childElements);
//            Element return_code = root.element("return_code");
//            log.info("return_code : " + return_code);
//            Element result_code = root.element("result_code");
            //所有参数正确时的返回内容
//            if (return_code.getText().equals("SUCCESS")&&result_code.getText().equals("SUCCESS")) {

            for (String param : params) {
                try {
                    result.put(param, root.element(param).getText());

                } catch (Exception e) {
                    log.info(param + " is not found");
//                        continue;
                }

//                }
//                log.info(" result is " + result);
//            }else if (return_code.getText().equals("SUCCESS")){
//                result.put("err_code_des",root.element("err_code_des").getText());
//            }else {
//                result.put("return_msg",root.element("return_msg").getText());
            }
        } catch (Exception e) {
            e.printStackTrace();
            log.error(e);
        }
        return result;
    }


    public static Map<String, String> parseXml(HttpServletRequest request) throws Exception {
        Map<String, String> map = new HashMap<String, String>();
        try {
            // 将解析结果存储在HashMap中

            // 从request中取得输入流
            InputStream inputStream = request.getInputStream();
            // 读取输入流
            SAXReader reader = new SAXReader();
            Document document = reader.read(inputStream);
            // document.selectSingleNode("//")
            // 得到xml根元素
            Element root = document.getRootElement();
            // 得到根元素的所有子节点
            List<Element> elementList = root.elements();
            // 遍历所有子节点
            for (Element e : elementList) {
                map.put(e.getName(), e.getText());
            }
            // 释放资源
            inputStream.close();
            inputStream = null;

        } catch (Exception e) {
            log.error(e);

        }
        return map;
    }

    public static void main(String[] a) {

        String xmlString = "<xml><return_code><![CDATA[SUCCESS]]></return_code>\n" +
                "<return_msg><![CDATA[OK]]></return_msg>\n" +
                "<appid><![CDATA[wx53bc3d04623a459f]]></appid>\n" +
                "<mch_id><![CDATA[1368482702]]></mch_id>\n" +
                "<nonce_str><![CDATA[zJWkoX682AmfQU2t]]></nonce_str>\n" +
                "<sign><![CDATA[A32C5C66FE881DD580B3DB77BEAF7CAF]]></sign>\n" +
                "<result_code><![CDATA[SUCCESS]]></result_code>\n" +
                "<prepay_id><![CDATA[wx201608131132482983a5c25c0082107177]]></prepay_id>\n" +
                "<trade_type><![CDATA[JSAPI]]></trade_type>\n" +
                "</xml>";

        XmlUtil xml = new XmlUtil();
        String result = xml.xml(xmlString);

        log.info(result);
    }
}
