package com.ptteng.keeper.home.controller;

import com.gemantic.common.util.MyTimeUtil;
import com.ptteng.keeper.common.constants.Constants;
import com.ptteng.keeper.common.model.*;
import com.ptteng.keeper.common.service.IncomeRecordService;
import com.ptteng.keeper.common.service.UserAssetService;
import com.ptteng.keeper.common.service.WithdrawIncomeRelationService;
import com.ptteng.keeper.common.service.WithdrawRecordService;
import com.ptteng.keeper.home.util.PropertiesUtil;
import com.ptteng.keeper.home.util.StringUtil;
import com.qding.common.util.DataUtils;
import com.qding.community.common.weixin.service.WeiXinService;
import com.qding.community.common.weixin.util.TemplateUtil;
import com.qding.community.common.weixin.vo.template.TemplateEntry;
import com.qding.community.common.weixin.vo.template.TemplateMessage;
import com.qding.community.common.weixin.vo.template.message.MessageReply;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

/**
 * WithdrawRecord  crud
 *
 * @author magenm
 * @Date 2014-4-16 13:43
 */
@Controller
public class WithdrawRecordController {
    private static final Log log = LogFactory.getLog(WithdrawRecordController.class);

    @Autowired
    private WithdrawRecordService withdrawRecordService;
    @Autowired
    private UserAssetService userAssetService;
    @Autowired
    private WeiXinService weiXinService;
    @Autowired
    private IncomeRecordService incomeRecordService;
    @Autowired
    private WithdrawIncomeRelationService withdrawIncomeRelationService;


    private final Properties wxProperties = PropertiesUtil.loadFilesToProps("weixinconfig.properties");


    /**
     * show 微信提现
     *
     * @param alipayAccount 支付宝账号
     * @param payeeName 收款人姓名
     * @return 操作结果
     * @throws Exception 异常信息
     * @author lishaobo
     * @date 2018/8/4
     */
    @RequestMapping(value = "/a/u/wx/withdraw", method = RequestMethod.POST)
    public String getWithdrawRecordIdsByUidAndStatusOrderByCreateAtJsonList(HttpServletRequest request,
                                                                            HttpServletResponse response, ModelMap model,String payeeName,String alipayAccount) throws Exception {
        User user = (User) request.getAttribute("user");
        log.info("user withdraw:id=" + user.getId()+" ,alipayAccount="+alipayAccount+" ,payeeName="+payeeName);
        if (DataUtils.isNullOrEmpty(payeeName)) {
            model.addAttribute("code", -2035);
            return "/common/success";
        }
        if (DataUtils.isNullOrEmpty(alipayAccount)) {
            model.addAttribute("code", -2034);
            return "/common/success";
        }
        try {
            //获取用户资产
            UserAsset userAsset = userAssetService.getObjectById(user.getId());
            BigDecimal surplusAmount = userAsset.getSurplusAmount();
            log.info("user surplusAmount = " + surplusAmount);
            if (BigDecimal.ZERO.compareTo(surplusAmount) == 0) {
                model.addAttribute("code", -2012);
                return "/common/success";
            }
            //生成记录
            WithdrawRecord withdrawRecord = new WithdrawRecord();
            withdrawRecord.setAmount(surplusAmount);
            withdrawRecord.setStatus(WithdrawRecord.STATUS_APPLYING);
            withdrawRecord.setUid(user.getId());
            withdrawRecord.setCreateBy(user.getId());
            withdrawRecord.setUpdateBy(user.getId());
            withdrawRecord.setAlipayAccount(alipayAccount);
            withdrawRecord.setPayeeName(payeeName);
            String orderNo = MyTimeUtil.getTimeInyyyyMMddHHmmss()+StringUtil.getRandomStringByLength(4)+"";
            log.info("orderNo");
            //查重
            Long id=withdrawRecordService.getWithdrawRecordIdByOrderNo(orderNo);
            while (DataUtils.isNotNullOrEmpty(id)) {
                log.info("流水号重复,重生成");
                orderNo = MyTimeUtil.getTimeInyyyyMMddHHmmss()+StringUtil.getRandomStringByLength(4)+"";
                //查重
                id=withdrawRecordService.getWithdrawRecordIdByOrderNo(orderNo);
            }
            log.info("orderNo="+orderNo);
            withdrawRecord.setOrderNo(orderNo);

            Long resultId = withdrawRecordService.insert(withdrawRecord);
            log.info("create withdraw record success, id=" + resultId);

            //关联曾经失败的收入记录
            List<Long> ids = incomeRecordService.getIncomeRecordIdsByWrId(Constants.DEFAULT_LONG_NONE,user.getId(), 0, Integer.MAX_VALUE);
            List<IncomeRecord> incomeRecordList = incomeRecordService.getObjectsByIds(ids);
            List<WithdrawIncomeRelation> withdrawIncomeRelationList = new ArrayList<>();
            for (IncomeRecord incomeRecord : incomeRecordList) {
                WithdrawIncomeRelation withdrawIncomeRelation = new WithdrawIncomeRelation();
                withdrawIncomeRelation.setIncomeId(incomeRecord.getId());
                withdrawIncomeRelation.setWid(resultId);
                withdrawIncomeRelation.setCreateBy(user.getId());
                withdrawIncomeRelation.setUpdateBy(user.getId());
                withdrawIncomeRelationList.add(withdrawIncomeRelation);

                incomeRecord.setWrId(resultId);
            }
            if (!ids.isEmpty()){
                incomeRecordService.updateList(incomeRecordList);
                log.info("withdrawIncomeRelationList size ="+withdrawIncomeRelationList.size());
                withdrawIncomeRelationService.insertList(withdrawIncomeRelationList);
            }

            //设置资产 提现中金额 = 提现中金额+此次提现值 余额清空
            userAsset.setApplyingAmount(userAsset.getApplyingAmount().add(surplusAmount));
            userAsset.setSurplusAmount(BigDecimal.ZERO);
            userAsset.setUpdateBy(user.getId());
            userAssetService.update(userAsset);
            log.info("user surplusAmount clean success");
            // 发送模板消息
            TemplateMessage templateMessage = new TemplateMessage();
            templateMessage.setTouser(user.getOpenid());
            templateMessage.setTemplate_id(wxProperties.getProperty("template_withdraw"));
            templateMessage.setUrl(wxProperties.getProperty(""));
            templateMessage.setTopcolor(wxProperties.getProperty("color"));

            //{{first.DATA}}
//			{{first.DATA}}
//			提现金额：{{keyword1.DATA}}
//			提现方式：{{keyword2.DATA}}
//			状态：{{keyword3.DATA}}
//			流水号：{{keyword4.DATA}}
//			{{remark.DATA}}
            //{{remark.DATA}}
            MessageReply messageReply = new MessageReply();
            messageReply.setFirst(new TemplateEntry(wxProperties.getProperty("withdraw_title"), wxProperties.getProperty("color")));
            //提现金额
            messageReply.setKeyword1(new TemplateEntry(surplusAmount.setScale(2,BigDecimal.ROUND_HALF_UP).toString(), wxProperties.getProperty("color")));
            messageReply.setKeyword2(new TemplateEntry(wxProperties.getProperty("withdraw_fs"), wxProperties.getProperty("color")));
            messageReply.setKeyword3(new TemplateEntry("申请中", wxProperties.getProperty("color")));
            messageReply.setKeyword4(new TemplateEntry(resultId.toString(), wxProperties.getProperty("color")));
            messageReply.setRemark(new TemplateEntry(wxProperties.getProperty("withdraw_remark"), wxProperties.getProperty("color")));
            templateMessage.setData(messageReply);
            String content = TemplateUtil.convertMessageReply2Jsons(templateMessage);
            log.info("content=" + content);
            weiXinService.sendTemplateMessage(
                    wxProperties.getProperty("appid"),
                    wxProperties.getProperty("appsecret"),
                    content, false
            );
            model.addAttribute("code", 0);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get withdrawRecord list error,");
            // for test
            model.addAttribute("code", -100000);
        }

        return "/common/success";
    }


    /**
     * show 提现列表
     *
     * @return withdrawRecord
     * @throws Exception 异常信息
     * @author lishaobo
     * @date 2018/8/4
     */

    @RequestMapping(value = "/a/u/withdraw/list", method = RequestMethod.GET)
    public String getWithdrawRecordIdsByUidAndStatusOrderByCreateAtJsonList(HttpServletRequest request,
                                                                            HttpServletResponse response, ModelMap model, Integer page,
                                                                            Integer size) throws Exception {
        log.info("withdraw record list:");

        if (page == null) {
            page = 1;
        }
        if (size == null) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }

        log.info("pageList : page= " + start + " , size=" + size);

        try {
            User user = (User) request.getAttribute("user");
            log.info("uid="+user.getId());
            List<Long> ids = withdrawRecordService.getWithdrawRecordIdsByUidOrderByCreateAt(user.getId(), start, size);
            List<WithdrawRecord> withdrawRecordList = new ArrayList<>();
            if (!ids.isEmpty()) {
                withdrawRecordList = withdrawRecordService.getObjectsByIds(ids);
            }
            Integer total = withdrawRecordService.getWithdrawRecordIdsByUidOrderByCreateAt(user.getId(), 0, Integer.MAX_VALUE).size();

            log.info("get withdraw record size is " + total);
            model.addAttribute("code", 0);
            model.addAttribute("page", page);
            model.addAttribute("size", size);

            model.addAttribute("total", total);

            model.addAttribute("withdrawRecordList", withdrawRecordList);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get withdrawRecord list error,page is  " + start + " , size "
                    + size);
            // for test
            model.addAttribute("code", -100000);
        }

        return "/keeper/withdrawRecord/json/withdrawRecordListJson";
    }
    /**
     * show 提现详情
     *
     * @return withdrawRecord
     * @throws Exception 异常信息
     * @author lishaobo
     * @date 2018/8/4
     */

    @RequestMapping(value = "/a/u/withdraw/{id}", method = RequestMethod.GET)
    public String getWithdrawDetail(HttpServletRequest request,
                                                                            HttpServletResponse response, ModelMap model, @PathVariable Long id) throws Exception {
        log.info("withdraw record detail :id="+id);
        if (DataUtils.isNullOrEmpty(id)) {
            model.addAttribute("code", -1000);
            return "/common/success";
        }
        try {
            User user = (User) request.getAttribute("user");
            log.info("uid="+user.getId());
            WithdrawRecord withdrawRecord = withdrawRecordService.getObjectById(id);
            if (DataUtils.isNullOrEmpty(withdrawRecord)) {
                log.info("data not found");
            }
            model.addAttribute("code", 0);
            model.addAttribute("withdrawRecord", withdrawRecord);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get withdrawRecord list error,page is  " );
            // for test
            model.addAttribute("code", -100000);
        }

        return "/keeper/withdrawRecord/json/withdrawRecordDetailJson";
    }
}

