package com.ptteng.keeper.home.util;


import com.qding.community.common.weixin.vo.template.TemplateMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import sun.net.www.protocol.http.Handler;
import sun.net.www.protocol.http.HttpURLConnection;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;

import java.net.URL;
import java.util.UUID;

/**
 * Created by asus on 2016/8/19.
 */
public class WxUtil {
    private static final Log log = LogFactory.getLog("WxUtil");

    public static String sign(String appid, String noncestr, String packages, String partnerid, String prepayid, String timestamp, String key) {


        String perPaySign =
                "appid=" + appid
                        + "&noncestr=" + noncestr
                        + "&package=" + packages
                        + "&partnerid=" + partnerid
                        + "&prepayid=" + prepayid
                        + "&timestamp=" + timestamp
                        + "&key=" + key;

        log.info("perPaySign is : " + perPaySign);

        String paySign = MD5.MD5Encode(perPaySign);
        paySign = exChange(paySign);
        log.info("pay sign is : " + paySign);

        return paySign;
    }

    public static String exChange(String str) {
        StringBuffer sb = new StringBuffer();
        if (str != null) {
            for (int i = 0; i < str.length(); i++) {
                char c = str.charAt(i);
                if ('a' <= c && c <= 'z') {
                    sb.append(Character.toUpperCase(c));
                } else {
                    sb.append(c);
                }
            }
        }

        return sb.toString();
    }


    public static File urlToFile(String path) throws Exception {
        try {
            //new一个URL对象
            URL url = new URL(null, path, new Handler());
            //打开链接
            HttpURLConnection conn = (HttpURLConnection) url.openConnection();
            //设置请求方式为"GET"
            conn.setRequestMethod("GET");
            //超时响应时间为5秒
            conn.setConnectTimeout(5 * 1000);
            //通过输入流获取图片数据
            InputStream inStream = conn.getInputStream();

            //得到图片的二进制数据，以二进制封装得到数据，具有通用性
            byte[] data = readInputStream(inStream);
            //new一个文件对象用来保存图片，默认保存当前工程根目录
            String fileName = UUID.randomUUID().toString() + ".jpg";
            String filePath = "/data/temp/" + fileName;
            File imageFile = new File(filePath);

            //创建输出流
            FileOutputStream outStream = new FileOutputStream(imageFile);
            //写入数据
            outStream.write(data);
            //关闭输出流
            outStream.close();
            log.info("urlToFille success,file name is" + imageFile.getName());

            return imageFile;
        } catch (Throwable throwable) {
            throwable.printStackTrace();
            log.error(throwable.getMessage(), throwable);
            return null;
        }


    }

    private static byte[] readInputStream(InputStream inStream) throws Exception {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        //创建一个Buffer字符串
        byte[] buffer = new byte[1024];
        //每次读取的字符串长度，如果为-1，代表全部读取完毕
        int len = 0;
        //使用一个输入流从buffer里把数据读取出来
        while ((len = inStream.read(buffer)) != -1) {
            //用输出流往buffer里写入数据，中间参数代表从哪个位置开始读，len代表读取的长度
            outStream.write(buffer, 0, len);
        }
        //关闭输入流
        inStream.close();
        //把outStream里的数据写入内存
        return outStream.toByteArray();
    }

}
