package com.ptteng.keeper.home.controller;

import com.gemantic.common.util.MyListUtil;
import com.ptteng.keeper.common.model.Article;
import com.ptteng.keeper.common.model.Message;
import com.ptteng.keeper.common.model.User;
import com.ptteng.keeper.common.model.UserReadRecord;
import com.ptteng.keeper.common.service.ArticleService;
import com.ptteng.keeper.common.service.MessageService;
import com.ptteng.keeper.common.service.UserReadRecordService;
import com.qding.common.util.DataUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.List;

/**
 * Article  crud
 *
 * @author magenm
 * @Date 2014-4-16 13:43
 */
@Controller
public class messageController {

    private static final Log log = LogFactory.getLog("article");
    @Autowired
    private MessageService messageService;
    @Autowired
    private UserReadRecordService userReadRecordService;


    /**
     * 消息详情
     *
     * @param id id
     * @return message
     * @throws Exception 异常
     */
    @RequestMapping(value = "/a/u/message/{id}", method = RequestMethod.GET)
    public String getArticleJson(HttpServletRequest request,
                                 HttpServletResponse response, ModelMap model, @PathVariable Long id)
            throws Exception {

        User user = (User) request.getAttribute("user");
        log.info("get message data : id= " + id+" ,uid="+user.getId());
        try {
            if (id == null) {
                model.addAttribute("code", -1000);
                return "/common/success";
            } else {

                Message message = messageService.getObjectById(id);
                if (DataUtils.isNotNullOrEmpty(message)) {
                    log.info("get message data is " + message);
                    //查用户阅读记录
                    Long rid = userReadRecordService.getUserReadRecordIdByTargetIdAndUidAndStatusAndType(id, user.getId(), UserReadRecord.STATUS_READ, UserReadRecord.TYPE_MESSAGE);
                    //设置用户消息阅读状态为已读
                    if (DataUtils.isNullOrEmpty(rid)) {
                        UserReadRecord userReadRecord = new UserReadRecord();
                        userReadRecord.setTargetId(id);
                        userReadRecord.setUid(user.getId());
                        userReadRecord.setStatus(UserReadRecord.STATUS_READ);
                        userReadRecord.setType(UserReadRecord.TYPE_MESSAGE);
                        userReadRecord.setCreateBy(user.getId());
                        userReadRecord.setUpdateBy(user.getId());
                        Long resultId = userReadRecordService.insert(userReadRecord);
                        log.info("create user read record success, id="+resultId);
                    }else {
                        log.info("user message status is read");
                    }
                    model.addAttribute("code", 0);
                    model.addAttribute("message", message);
                }else {
                    model.addAttribute("code", -10);
                }
            }
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get article error,id is  " + id);
            model.addAttribute("code", -100000);
        }

        return "/keeper/message/json/messageDetailJson";
    }


    /**
     * 消息列表
     *
     * @param page 页码
     * @param size 数据量
     * @return Array[article] count
     * @throws Exception 异常
     */
    @RequestMapping(value = "/a/u/message/list", method = RequestMethod.GET)
    public String getArticleList(HttpServletRequest request,
                                 HttpServletResponse response, ModelMap model, Integer page, Integer size)
            throws Exception {
        User user = (User) request.getAttribute("user");
        log.info("get message list:type="+user.getId());

        if (page == null) {
            page = 1;
        }
        if (size == null) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }
        Integer total = 0;
        List<Long> count = null;
        List<Long> ids = null;
        log.info("pageList : page= " + start + " , size=" + size);
        try {
            ids = messageService.getMessageIdsByStatusOrderByPushAt(Message.STATUS_PUSH, start, size);
            count = messageService.getMessageIdsByStatusOrderByPushAt(Message.STATUS_PUSH, 0, Integer.MAX_VALUE);
            total = count.size();
            log.info("get message list size is" + ids.size());
            log.info("get message total is" + total);


            List<Message> messageList = messageService.getObjectsByIds(ids);
            //查用户消息阅读记录,jsp通过contains的包含关系判断是否已读
            List<Long> rids = userReadRecordService.getUserReadRecordIdsByUidAndStatusAndType(user.getId(), UserReadRecord.STATUS_READ, UserReadRecord.TYPE_MESSAGE, 0, Integer.MAX_VALUE);

            if (rids.size() > 0) {
                List<UserReadRecord> userReadRecords = userReadRecordService.getObjectsByIds(rids);
                rids = MyListUtil.getList(UserReadRecord.class.getDeclaredField("targetId"), userReadRecords);
            }
            log.info("rids size is "+rids.size());
            model.addAttribute("messageList", messageList);

            log.info("code : " + 0);
            model.addAttribute("total", total);
            model.addAttribute("rids", rids);
            model.addAttribute("size", size);
            model.addAttribute("page", page);
            model.addAttribute("code", 0);
        } catch (Throwable t) {
            log.error(t.getMessage());
            model.addAttribute("code", -1);
        }

        return "/keeper/message/json/messageListJson";
    }

    /**
     * 设置消息已读
     *
     * @return 操作解结果
     * @throws Exception 异常
     */
    @RequestMapping(value = "/a/u/message/read", method = RequestMethod.POST)
    public String readMessage(HttpServletRequest request,
                                 HttpServletResponse response, ModelMap model)
            throws Exception {
        User user = (User) request.getAttribute("user");
        log.info("read message :uid="+user.getId());
        try {
            List<Long> ids = messageService.getMessageIdsByStatusOrderByPushAt(Message.STATUS_PUSH, 0, Integer.MAX_VALUE);
            log.info("get message list size is" + ids.size());
            //查用户消息已阅读记录
            List<Long> rids = userReadRecordService.getUserReadRecordIdsByUidAndStatusAndType(user.getId(), UserReadRecord.STATUS_READ, UserReadRecord.TYPE_MESSAGE, 0, Integer.MAX_VALUE);
            //计算未读消息ids
            ids.removeAll(rids);
            log.info("unread message ids size is " + ids.size());
            //添加消息阅读记录
            List<UserReadRecord> userReadRecordList = new ArrayList<>();
            for (int i = 0, len = ids.size(); i < len; i++) {
                UserReadRecord userReadRecord = new UserReadRecord();
                userReadRecord.setType(UserReadRecord.TYPE_MESSAGE);
                userReadRecord.setStatus(UserReadRecord.STATUS_READ);
                userReadRecord.setUid(user.getId());
                userReadRecord.setUpdateBy(user.getId());
                userReadRecord.setCreateBy(user.getId());
                userReadRecordList.add(userReadRecord);
            }
            userReadRecordService.insertList(userReadRecordList);
            log.info("create message read record success,size is "+userReadRecordList.size());
            model.addAttribute("code", 0);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage(),t);
            model.addAttribute("code", -1);
        }

        return "/common/success";
    }
}

