package com.ptteng.keeper.home.controller;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.common.util.MyListUtil;
import com.gemantic.common.util.MyTimeUtil;
import com.gemantic.common.util.PasswordUtils;
import com.ptteng.keeper.common.constants.Constants;
import com.ptteng.keeper.common.model.*;
import com.ptteng.keeper.common.service.*;
import com.ptteng.keeper.home.constant.SmsCodeConstant;
import com.ptteng.keeper.home.constant.WxConfig;
import com.ptteng.keeper.home.interceptor.CookieConstant;
import com.ptteng.keeper.home.util.*;
import com.qding.common.util.DataUtils;
import com.qding.common.util.http.cookie.CookieUtil;
import com.qding.community.common.weixin.service.WeiXinService;
import com.qding.community.common.weixin.util.TemplateUtil;
import com.qding.community.common.weixin.vo.WXUser;
import com.qding.community.common.weixin.vo.template.TemplateEntry;
import com.qding.community.common.weixin.vo.template.TemplateMessage;
import com.qding.community.common.weixin.vo.template.message.MessageReply;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * User  crud
 *
 * @author cjsff
 * @Date 2018年1月3日17:26:38
 */
@Controller
public class UserController {
    private static final Log log = LogFactory.getLog(UserController.class);

    @Autowired
    private UserService userService;
    @Autowired
    private SmsService smsService;
    @Resource(name = "accountConfig")
    private Map<String, String> accountConfig;
    @Autowired
    private com.qding.common.util.http.cookie.CookieUtil cookieUtil;

    @Autowired
    private WeiXinService weiXinService;
    @Autowired
    private UserAssetService userAssetService;
    @Autowired
    private CopartnerRelationService copartnerRelationService;
    @Autowired
    private IncomeRecordService incomeRecordService;
    @Autowired
    private MessageService messageService;
    @Autowired
    private UserReadRecordService userReadRecordService;

    private final Properties wxProperties = PropertiesUtil.loadFilesToProps("weixinconfig.properties");

    /**
     * show 申请代理
     *
     * @param mobile           手机号
     * @param verificationCode 验证码
     * @param invitationCode   邀请码
     * @return 操作结果
     * @throws Exception 异常信息
     * @author lishaobo
     * @date 2018/8/5
     */
    @RequestMapping(value = "/a/u/proxy", method = RequestMethod.PUT)
    public String setProxy(HttpServletRequest request,
                           HttpServletResponse response, ModelMap model, String mobile, String verificationCode, String invitationCode)
            throws Exception {

        log.info("==============a/u/proxy==============");
        log.info(LogUtil.convertParam("mobile", mobile, "verificationCode", verificationCode, "invitationCode", invitationCode));
        if (DataUtils.isNullOrEmpty(mobile)) {
            model.addAttribute("code", -2001);
            return "common/success";
        }
        if (DataUtils.isNullOrEmpty(verificationCode)) {
            model.addAttribute("code", -1006);
            return "common/success";
        }

        try {
            User user = (User) request.getAttribute("user");


            //验证码校验
            boolean verifyResult = false;
            String type = Sms.TYPE_REGISTER;
            // 测试模式
            log.info("testMode=" + verifyModel());

            //验证用户是否已成为代理
            if (DataUtils.isNotNullOrEmpty(user.getMobile())) {
                model.addAttribute("code", -2011);
                return "common/success";
            }
            if (verifyModel()) {
                if ("555555".equals(verificationCode)) {
                    log.info("test ,so not verify mobile ");
                    verifyResult = true;
                } else {
                    verifyResult = verifyMobileCode(model, mobile, type, verificationCode);
                }
            } else {
                verifyResult = verifyMobileCode(model, mobile, type, verificationCode);
            }
            if (verifyResult) {
                //判断用户是否是扫邀请码过来的
                if (!Objects.equals(user.getRecommendId(), Constants.DEFAULT_LONG_NONE)) {
                    User recommend = userService.getObjectById(user.getRecommendId());
                    invitationCode = recommend.getInvitationCode();
                }
                //生成邀请码
                String code = StringUtil.getRandomStringByLength(7);
                //邀请码查重
                synchronized (this){
                    Long result = userService.getUserIdByInvitationCode(code);
                    log.info("random code is "+code);
                    while (DataUtils.isNotNullOrEmpty(result)){
                        log.info("code is exist!!!");
                        code = StringUtil.getRandomStringByLength(7);
                    }
                }
                log.info("code=" + code);
                user.setInvitationCode(code);
                user.setMobile(mobile);
                //验证邀请码
                if (DataUtils.isNotNullOrEmpty(invitationCode)) {
                    Long rid = userService.getUserIdByInvitationCode(invitationCode);
                    if (DataUtils.isNullOrEmpty(rid)) {
                        model.addAttribute("code", -2010);
                        return "common/success";
                    } else {
                        User rUser = userService.getObjectById(rid);
                        //先判断邀请人是不是vip
                        if (User.IS_VIP_TRUE.equals(rUser.getIsVip())) {
                            user.setTeamUid(rid);
                        } else {
                            user.setTeamUid(rUser.getTeamUid());
                        }
                        user.setLevel(rUser.getLevel() + 1);
                        user.setVipAt(System.currentTimeMillis());
                        user.setIsVip(User.IS_VIP_FALSE);
                        user.setRecommendId(rid);
                        log.info("recommendId=" + rid);
                        user.setUpdateBy(rid);
                        //生成推荐一级合伙人信息关系
                        CopartnerRelation copartnerRelation = new CopartnerRelation();
                        copartnerRelation.setLevel(CopartnerRelation.LEVEL_FIRST);
                        copartnerRelation.setUid(rid);
                        copartnerRelation.setSubUid(user.getId());
                        copartnerRelation.setCreateBy(user.getId());
                        copartnerRelation.setUpdateBy(user.getId());
                        Long resultId = copartnerRelationService.insert(copartnerRelation);
                        log.info("一级合伙人关系 = "+copartnerRelation);
                        log.info("create copartner success ,id=" + resultId);
                        //添加合伙人数量
                        //修改上级合伙人资产
                        UserAsset recommendUserAsset = userAssetService.getObjectById(rid);
                        recommendUserAsset.setFirstCoprtnerCount(recommendUserAsset.getFirstCoprtnerCount() + 1);
                        recommendUserAsset.setUpdateBy(user.getId());
                        userAssetService.update(recommendUserAsset);
                        log.info("update first recommend asset success");
                        //给上级合伙人加一笔收入记录（0）用户后台查询
                        createIncome(rid, user.getId(), IncomeRecord.LEVEL_FIRST);

                        //修改上上级合伙人资产
                        Long secondCopartnerRelationId = copartnerRelationService.getCopartnerRelationIdBySubUidAndLevel(rid,CopartnerRelation.LEVEL_FIRST);
                        if (DataUtils.isNotNullOrEmpty(secondCopartnerRelationId)) {
                            CopartnerRelation secondCopartnerRelation = copartnerRelationService.getObjectById(secondCopartnerRelationId);
                            Long secondCopartnerId = secondCopartnerRelation.getUid();
                            //添加二级合伙人关系
                            CopartnerRelation secondCopartner = new CopartnerRelation();
                            secondCopartner.setLevel(CopartnerRelation.LEVEL_SECOND);
                            secondCopartner.setUid(secondCopartnerId);
                            secondCopartner.setSubUid(user.getId());
                            secondCopartner.setCreateBy(user.getId());
                            secondCopartner.setUpdateBy(user.getId());
                            resultId = copartnerRelationService.insert(secondCopartner);
                            log.info("二级合伙人关系 = "+copartnerRelation);

                            log.info("create second copartner success ,id=" + resultId);

                            //修改上上级合伙人资产
                            recommendUserAsset = userAssetService.getObjectById(secondCopartnerId);
                            recommendUserAsset.setSecondCoprtnerCount(recommendUserAsset.getSecondCoprtnerCount() + 1);
                            userAssetService.update(recommendUserAsset);
                            log.info("update second recommend asset success");

                            //给上上级合伙人加一笔收入记录（0）用户后台查询
                            createIncome(secondCopartnerId, user.getId(), IncomeRecord.LEVEL_SECOND);
                        }

                    }
                }
                userService.update(user);
                log.info("user update success,id=" + user.getId());
                model.addAttribute("code", 0);
            } else {
                return "common/success";
            }
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            model.addAttribute("code", -100000);
        }

        return "/common/success";
    }

    /**
     * show 用户登录
     *
     * @param code 微信授权码
     * @return java.lang.String
     * @throws Exception 异常信息
     * @author lishaobo
     * @date 2018/8/8
     */
    @RequestMapping(value = "/a/wx/login", method = RequestMethod.POST)
    public String login(HttpServletRequest request, HttpServletResponse response, ModelMap mapModel, String code) throws Exception {

        log.info("patient login is " + "code " + code);
        if (DataUtils.isNullOrEmpty(code)) {
            mapModel.addAttribute("code", -2009);
            return "common/success";
        }
        WXUser wxUser = new WXUser();

        try {
            wxUser = weiXinService.getUserInfoByCode(WxConfig.appID, WxConfig.appSecret, code);
            log.info("wxUser is"+wxUser);
        } catch (Throwable throwable) {
            throwable.printStackTrace();
            mapModel.addAttribute("code", -11);
            return "/common/success";
        }

        log.info("=================用户登录开始= code==============="+code);
        try {
            // 获取用户信息

            log.info("openId is :" + wxUser.getOpenid());

            Long id = userService.getUserIdByOpenid(wxUser.getOpenid());

            User user ;
            UserAsset userAsset = new UserAsset();
            if (DataUtils.isNullOrEmpty(id)) {
                user = new User();
                log.info("user does not exist!");
                user.setNick(wxUser.getNickname());
                user.setAvatar(wxUser.getHeadimgurl());
                user.setOpenid(wxUser.getOpenid());
                user.setStatus(User.STATUS_NORMAL);
                user.setRecommendId(Constants.DEFAULT_LONG_NONE);
                user.setInvitationCode(Constants.DEFAULT_STR_NONE);
                user.setName(Constants.DEFAULT_STR_NONE);
                user.setMobile(Constants.DEFAULT_STR_NONE);
                user.setPwd(Constants.DEFAULT_STR_NONE);
                user.setCreateBy(Constants.DEFAULT_LONG_NONE);
                user.setUpdateBy(Constants.DEFAULT_LONG_NONE);
                user.setLastLoginAt(System.currentTimeMillis());
                user.setToken(Constants.DEFAULT_STR_NONE);
                user.setIdCard(Constants.DEFAULT_STR_NONE);
                id = userService.insert(user);
                log.info("create user success ,id is " + id);

                //创建用户据资产数据
                userAsset = createUserAsset(id);
            } else {
                log.info("=================老用户================");
                user = userService.getObjectById(id);
                //验证用户状态-冻结则禁止登陆
                if (User.STATUS_FREEZE.equals(user.getStatus())) {
                    log.info("=================冻结用户================");
                    Map<String, String> maps = new HashMap<String, String>();
                    user.setInvitationCode("");
                    maps.put(CookieUtil.USER_ID, id + "");
                    maps.put(CookieConstant.Cookie_WEB_mobile, user.getOpenid());
                    log.info("maps ="+maps);
                    cookieUtil.setIdentity(request, response, maps, id);
                    log.info("=================登陆结束================");

                    mapModel.addAttribute("code", -3);
                    mapModel.addAttribute("user", user);
                    mapModel.addAttribute("userAsset", userAsset);
                    return "/muscle-main-service/user/json/login";
                }
                user.setNick(wxUser.getNickname());
                user.setAvatar(wxUser.getHeadimgurl());
                user.setLastLoginAt(System.currentTimeMillis());
                userService.update(user);
                log.info("user update success");

                Long uAid = userAssetService.getUserAssetIdByUid(id);
                if (DataUtils.isNotNullOrEmpty(uAid)) {
                    userAsset = userAssetService.getObjectById(uAid);
                } else {
                    userAsset = createUserAsset(id);
                }

            }

            if (!Constants.DEFAULT_LONG_NONE.equals(user.getRecommendId())) {
                User recommendUser = userService.getObjectById(user.getRecommendId());
                mapModel.addAttribute("recommendCode", recommendUser.getInvitationCode());
            }
            // 查询用户是否关注公众号
            wxUser=weiXinService.getUserInfo(WxConfig.appID, WxConfig.appSecret, user.getOpenid());
            log.info("wxUser ="+wxUser);
            Map<String, String> maps = new HashMap<String, String>();
            maps.put(CookieUtil.USER_ID, id + "");
            maps.put(CookieConstant.Cookie_WEB_mobile, user.getOpenid());
            log.info("maps ="+maps);
            cookieUtil.setIdentity(request, response, maps, id);
            log.info("=================登陆结束================");

            mapModel.addAttribute("code", 0);
            mapModel.addAttribute("user", user);
            mapModel.addAttribute("wxUser", wxUser);
            mapModel.addAttribute("userAsset", userAsset);

        } catch (Throwable throwable) {
            throwable.printStackTrace();
            log.error(throwable);
            mapModel.addAttribute("code", -1);
        }
        return "/muscle-main-service/user/json/login";
    }

    /**
     * show 用户详情
     *
     * @return java.lang.String
     * @throws Exception 异常信息
     * @author lishaobo
     * @date 2018/8/8
     */
    @RequestMapping(value = "/a/u/user/detail", method = RequestMethod.GET)
    public String getUserDetail(HttpServletRequest request, HttpServletResponse response, ModelMap mapModel) throws Exception {

        try {
            log.info("==========用户详情开始=============");
            // 获取用户信息
            User user = (User) request.getAttribute("user");

            UserAsset userAsset = userAssetService.getObjectById(user.getId());
            if (DataUtils.isNullOrEmpty(userAsset)) {
                userAsset = createUserAsset(user.getId());
            }
            if (!Constants.DEFAULT_LONG_NONE.equals(user.getRecommendId())) {
                User recommendUser = userService.getObjectById(user.getRecommendId());
                mapModel.addAttribute("recommendCode", recommendUser.getInvitationCode());
            }
            List<Long> ids = messageService.getMessageIdsByStatusOrderByPushAt(Message.STATUS_PUSH, 0, Integer.MAX_VALUE);
            log.info("get message list size is" + ids.size());
            //查用户消息阅读记录,jsp通过contains的包含关系判断是否已读
            List<Long> rids = userReadRecordService.getUserReadRecordIdsByUidAndStatusAndType(user.getId(), UserReadRecord.STATUS_READ, UserReadRecord.TYPE_MESSAGE, 0, Integer.MAX_VALUE);

            if (rids.size() > 0) {
                List<UserReadRecord> userReadRecords = userReadRecordService.getObjectsByIds(rids);
                rids = MyListUtil.getList(UserReadRecord.class.getDeclaredField("targetId"), userReadRecords);
            }

            boolean result=ids.removeAll(rids);
            log.info("remove read record -->"+result+" ,unread ids="+ids);
            mapModel.addAttribute("unreadCount", ids.size());
            mapModel.addAttribute("code", 0);
            mapModel.addAttribute("user", user);
            mapModel.addAttribute("userAsset", userAsset);

        } catch (Throwable throwable) {
            throwable.printStackTrace();
            log.error(throwable);
            mapModel.addAttribute("code", -1);
        }
        return "/keeper/user/json/userDetail";
    }

    private UserAsset createUserAsset(Long uid) {
        try {
            UserAsset userAsset = new UserAsset();
            userAsset.setId(uid);
            userAsset.setUid(uid);
            userAsset.setApplyingAmount(BigDecimal.ZERO);
            userAsset.setRebateAmount(BigDecimal.ZERO);
            userAsset.setCopartnerAmount(BigDecimal.ZERO);
            userAsset.setSurplusAmount(BigDecimal.ZERO);
            userAsset.setTodayAmount(BigDecimal.ZERO);
            userAsset.setFirstCoprtnerAmout(BigDecimal.ZERO);
            userAsset.setSecondCoprtnerAmout(BigDecimal.ZERO);
            userAsset.setFirstCoprtnerCount(Constants.DEFAULT_NUMBER_ZORE);
            userAsset.setSecondCoprtnerCount(Constants.DEFAULT_NUMBER_ZORE);
            userAsset.setCreateBy(uid);
            userAsset.setUpdateBy(uid);
            Long id = userAssetService.insert(userAsset);
            log.info("create user asset success ,id is " + id);
            return userAsset;
        } catch (Throwable throwable) {
            throwable.printStackTrace();
            log.error(throwable);
        }
        return null;
    }

    private IncomeRecord createIncome(Long uid, Long createId, Integer level) {
        try {
            IncomeRecord incomeRecord = new IncomeRecord();
            incomeRecord.setUid(uid);
            incomeRecord.setTargetId(Constants.DEFAULT_LONG_NONE);
            incomeRecord.setCreateBy(createId);
            incomeRecord.setUpdateBy(createId);
            incomeRecord.setAmount(BigDecimal.ZERO);
            incomeRecord.setLevel(level);
            incomeRecord.setType(Constants.DEFAULT_INT_NONE);
            incomeRecord.setProductId(Constants.DEFAULT_LONG_NONE);
            Long id = incomeRecordService.insert(incomeRecord);
            log.info("create user income success ,id is " + id);
            return incomeRecord;
        } catch (Throwable throwable) {
            throwable.printStackTrace();
            log.error(throwable);
        }
        return null;
    }

    /**
     * show 获取合伙人
     *
     * @param level 合伙人等级 1下级2下下级
     * @return
     * @throws Exception 异常信息
     * @author lishaobo
     * @date 2018/8/5
     */
    @RequestMapping(value = "/a/u/copartner/list", method = RequestMethod.GET)
    public String getCopartner(HttpServletRequest request, HttpServletResponse response, ModelMap model, Integer level) throws Exception {
        User user = (User) request.getAttribute("user");
        log.info("get copartner list :id=" + user.getId()+"level = "+level);
        if (level == null || level > CopartnerRelation.LEVEL_SECOND) {
            level = CopartnerRelation.LEVEL_FIRST;
        }
        try {

            //下级/下下级合伙人列表
            List<Long> copartnerrelationIds = copartnerRelationService.getCopartnerRelationIdsByUidAndLevel(user.getId(), level, 0, Integer.MAX_VALUE);
            List<CopartnerRelation> copartnerRelationList = new ArrayList<>();
            if (copartnerrelationIds.size() > 0) {
                copartnerRelationList = copartnerRelationService.getObjectsByIds(copartnerrelationIds);
            }
            List<Long> uids = MyListUtil.getList(CopartnerRelation.class.getDeclaredField("subUid"), copartnerRelationList);
            List<User> copartnerList = userService.getObjectsByIds(uids);
            for (User u : copartnerList) {
                u.setMobile(StringUtil.stringEncryption(u.getMobile()));
            }
            log.info("copartnerList "+level+"  size is " + copartnerList.size());
            //合伙人收入
            Map<String, Object> map = DynamicUtil.getSumAmountByUidAndLevel(user.getId(), level);
            Object result = incomeRecordService.getObjectByDynamicCondition(IncomeRecord.class, map, 0, Integer.MAX_VALUE);
            List<Object[]> amountList = (List<Object[]>) ObjectConvertUtil.objectToArrayList(result);

            log.info("amountList size is " + amountList.size());
            model.addAttribute("copartnerList", copartnerList);
            model.addAttribute("amountList", amountList);
            model.addAttribute("code", 0);
        } catch (Exception t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error(" get copartner list error ");
            model.addAttribute("code", SmsCodeConstant.SYSTEM_EXCEPTION);
        }

        return "/keeper/copartnerRelation/json/copartnerRelationListJson";
    }


    /**
     * show 验证码发送
     *
     * @param mobile 手机
     * @param type   验证码类型
     * @return 操作结果
     */
    @RequestMapping(value = "/a/u/code/send", method = RequestMethod.POST)
    public String sendVerify(HttpServletRequest request,
                             HttpServletResponse response, ModelMap model, String mobile,
                             String type) throws ServiceException, ServiceDaoException {
        log.info("-----------------------send code start------------------------");
        log.info(mobile + " want send sms of type " + type);

        if (StringUtils.isBlank(mobile)) {
            log.info(mobile + " want send sms of type " + type + " null mobile ");
            model.addAttribute("code", -2001);
            return "/common/success";
        }

        int code = SmsCodeConstant.SYSTEM_SUCCESS;

        try {
            log.info("sms is start");
            String result = this.smsService.sendMsg(mobile, type);
            switch (result) {
                case SmsService.ErrorCode_SMS_InvalidType:
                    code = SmsCodeConstant.VERIFYCODE_TYPE_NOT_SUPPORT;
                    break;
                case SmsService.ErrorCode_SMS_smsMoreThan5:
                    code = SmsCodeConstant.VERIFYCODE_MORETHAN_FIVE;
                    break;
                default:
            }

            log.info("-----------------------send code end------------------------");
            model.addAttribute("code", code);
        } catch (Exception t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error(mobile + " send message error of type " + type);
            model.addAttribute("code", SmsCodeConstant.SYSTEM_EXCEPTION);
        }
        return "/common/success";
    }


    public String dateTime() {
        Long time = System.currentTimeMillis();
        DateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String date = format.format(time);
        return date;
    }

    /**
     * 拦截器用户状态异常返回
     *
     * @param request
     * @param response
     * @param model
     * @param url
     * @return
     */
    @RequestMapping(value = "/a/login/statusOff", method = RequestMethod.GET)
    public String testLongin(HttpServletRequest request, HttpServletResponse response, ModelMap model, String url) {

        log.info("---------------------------get the login test start---------------------------");
        try {
            model.addAttribute("code", -3);
        } catch (Throwable t) {
            log.error("get signature info error");
            t.printStackTrace();
        }
        return "/common/success";

    }


    // 验证码校验
    private boolean verifyMobileCode(ModelMap modelMap, String mobile, String type,
                                     String verify) throws ServiceException, ServiceDaoException {
        log.info("log2: mobile is " + mobile + ",type = " + type + ",verify" + verify);
        // 是否有发送验证码
        Long sid = smsService.getSmsIdByMobileAndType(mobile, type);
        log.info("sid is " + sid);
        if (sid == null) {
            return false;
        }
        // 获取验证码信息
        Sms sms = smsService.getObjectById(sid);
        log.info("sms is " + sms);
        // 获取验证码
        String message = sms.getMessage();
        log.info("message is " + message);
        //发送是否超时
        Long delay = System.currentTimeMillis() - sms.getSendAt();
        if (delay > 600000) {
            log.info("require verify too long");
            modelMap.addAttribute("code", -1010);
            return false;
        }
        if (message.equals(verify)) {
            return true;
        } else {
            modelMap.addAttribute("code", -1006);
            return false;
        }
    }

    private boolean verifyModel() {
        return "test".equals(this.accountConfig.get("testModel"));
    }

    public static void main(String[] args) {
        String test = "123456";
        String testT = PasswordUtils.encode(test);
        System.out.println(testT);
    }

}

