package com.ptteng.keeper.home.community.util;

import com.qding.common.util.DataUtils;

import java.util.HashMap;
import java.util.Map;

public class DynamicUtil {

    public static String withQuote(String value) {

        if (value != null) {
            return "\"" + value + "\"";
        } else {
            return "\"\"";
        }
    }

    public static Map<String, Object> convert2News(Long publicsID, String author,
                                                   String qupdateFrom, String qupdateTo, String status, boolean count) {
        Map<String, Object> params = new HashMap();


        params.put("n.id", "nr.news_id");


        if (publicsID != null) {
            params.put("nr.publics_id", publicsID);
        }
        if (DataUtils.isNotNullOrEmpty(author)) {
            params.put("n.author", publicsID);
        }
        if (DataUtils.isNotNullOrEmpty(qupdateFrom)) {
            params.put("n.release_at & >= ", qupdateFrom);
        }
        if (DataUtils.isNotNullOrEmpty(qupdateTo)) {
            params.put("n.release_at & <= ", qupdateTo);
        }


        if (DataUtils.isNotNullOrEmpty(status)) {
            params.put("n.status", withQuote(status));
        }


        if (count) {
            params.put("@query", "count( distinct n.id)");
        } else {
            params.put("@order", "n.update_at desc");
            params.put("@query", " distinct  n.id");
        }
        params.put("@table", "news n ,news_publics_relation nr");

        return params;
    }
}
