package com.ptteng.keeper.home.controller;

import com.ptteng.keeper.common.model.User;
import com.ptteng.keeper.common.model.UserAsset;
import com.ptteng.keeper.common.model.WithdrawRecord;
import com.ptteng.keeper.common.service.UserAssetService;
import com.ptteng.keeper.common.service.WithdrawRecordService;
import com.ptteng.keeper.home.util.PropertiesUtil;
import com.qding.community.common.weixin.service.WeiXinService;
import com.qding.community.common.weixin.util.TemplateUtil;
import com.qding.community.common.weixin.vo.template.TemplateEntry;
import com.qding.community.common.weixin.vo.template.TemplateMessage;
import com.qding.community.common.weixin.vo.template.message.MessageReply;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.util.Properties;

/**
 * WithdrawRecord  crud
 *
 * @author magenm
 * @Date 2014-4-16 13:43
 */
@Controller
public class WithdrawRecordController {
    private static final Log log = LogFactory.getLog(WithdrawRecordController.class);

    @Autowired
    private WithdrawRecordService withdrawRecordService;
    @Autowired
    private UserAssetService userAssetService;
    @Autowired
    private WeiXinService weiXinService;


    private final Properties wxProperties = PropertiesUtil.loadFilesToProps("weixinconfig.properties");


    /**
     * show 微信提现
     *
     * @return 操作结果
     * @throws Exception 异常信息
     * @author lishaobo
     * @date 2018/8/4
     */
    @RequestMapping(value = "/a/u/wx/withdraw", method = RequestMethod.POST)
    public String getWithdrawRecordIdsByUidAndStatusOrderByCreateAtJsonList(HttpServletRequest request,
                                                                            HttpServletResponse response, ModelMap model) throws Exception {
        User user = (User) request.getAttribute("user");
        log.info("user withdraw:id=" + user.getId());
        try {
            //获取用户资产
            UserAsset userAsset = userAssetService.getObjectById(user.getId());
            BigDecimal surplusAmount = userAsset.getSurplusAmount();
            log.info("user surplusAmount = " + surplusAmount);
            if (BigDecimal.ZERO.compareTo(surplusAmount) == 0) {
                model.addAttribute("code", -2012);
                return "/common/success";
            }
            //生成记录
            WithdrawRecord withdrawRecord = new WithdrawRecord();
            withdrawRecord.setAmount(surplusAmount);
            withdrawRecord.setStatus(WithdrawRecord.STATUS_APPLYING);
            withdrawRecord.setUid(user.getId());
            withdrawRecord.setCreateBy(user.getId());
            withdrawRecord.setUpdateBy(user.getId());
            Long resultId = withdrawRecordService.insert(withdrawRecord);
            log.info("create withdraw record success, id=" + resultId);

            //设置资产 提现中金额 = 提现中金额+此次提现值 余额清空
            userAsset.setApplyingAmount(userAsset.getApplyingAmount().add(surplusAmount));
            userAsset.setSurplusAmount(BigDecimal.ZERO);
            userAsset.setUpdateBy(user.getId());
            userAssetService.update(userAsset);
            log.info("user surplusAmount clean success");
            // 发送模板消息
            TemplateMessage templateMessage = new TemplateMessage();
            templateMessage.setTouser(user.getOpenid());
            templateMessage.setTemplate_id(wxProperties.getProperty("template_withdraw"));
            templateMessage.setUrl(wxProperties.getProperty(""));
            templateMessage.setTopcolor(wxProperties.getProperty("color"));

            //{{first.DATA}}
//			{{first.DATA}}
//			提现金额：{{keyword1.DATA}}
//			提现方式：{{keyword2.DATA}}
//			状态：{{keyword3.DATA}}
//			流水号：{{keyword4.DATA}}
//			{{remark.DATA}}
            //{{remark.DATA}}
            MessageReply messageReply = new MessageReply();
            messageReply.setFirst(new TemplateEntry(wxProperties.getProperty("withdraw_title"), wxProperties.getProperty("color")));
            //提现金额
            messageReply.setKeyword1(new TemplateEntry(surplusAmount.setScale(2,BigDecimal.ROUND_HALF_UP).toString(), wxProperties.getProperty("color")));
            messageReply.setKeyword2(new TemplateEntry(wxProperties.getProperty("withdraw_fs"), wxProperties.getProperty("color")));
            messageReply.setKeyword3(new TemplateEntry("申请中", wxProperties.getProperty("color")));
            messageReply.setKeyword4(new TemplateEntry(resultId.toString(), wxProperties.getProperty("color")));
            messageReply.setRemark(new TemplateEntry(wxProperties.getProperty("withdraw_remark"), wxProperties.getProperty("color")));
            templateMessage.setData(messageReply);
            String content = TemplateUtil.convertMessageReply2Jsons(templateMessage);
            log.info("content=" + content);
            weiXinService.sendTemplateMessage(
                    wxProperties.getProperty("appid"),
                    wxProperties.getProperty("appsecret"),
                    content, false
            );
            model.addAttribute("code", 0);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get withdrawRecord list error,");
            // for test
            model.addAttribute("code", -100000);
        }

        return "/common/success";
    }


}

