package com.ptteng.keeper.home.controller;

import com.ptteng.keeper.common.model.Version;
import com.ptteng.keeper.common.service.VersionService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

/**
 * Created by asus on 2016/8/20.
 */
@Controller
public class VersionController {

    private static final Log log = LogFactory.getLog("version");

    @Autowired
    private VersionService versionService;


    /**
     * 我的信息
     */
    @RequestMapping(value = "/a/version", method = RequestMethod.GET)
    public String version(HttpServletRequest request, HttpServletResponse response, ModelMap model) {
        /**错误信息*/
        HashMap<String, String> errorMap = new HashMap<String, String>();
        HashMap<String, Long> numMap = new HashMap<String, Long>();
        HashMap<String, Object> objMap = new HashMap<String, Object>();

        try {
            List<Long> andVids = versionService.getVersionIdsByOsOrderByVersionCode(Version.OS_ANDROID, 0, Integer.MAX_VALUE);
            log.info("android version id list : " + andVids);

            if (CollectionUtils.isNotEmpty(andVids)) {

                List<Version> andVersions = versionService.getObjectsByIds(andVids);
                Collections.sort(andVersions);
                /*test*/
                Version andVersion = andVersions.get(0);
                log.info(andVersion);

                model.addAttribute("andVersion", andVersion);

            } else {
                log.info("no android version");
            }

            List<Long> iosVids = versionService.getVersionIdsByOsOrderByVersionCode(Version.OS_IOS, 0, Integer.MAX_VALUE);
            log.info("ios version id list : " + iosVids);

            if (CollectionUtils.isNotEmpty(iosVids)) {

                List<Version> iosVersions = versionService.getObjectsByIds(iosVids);

                Collections.sort(iosVersions);
                Version iosVersion = iosVersions.get(0);
                log.info(iosVersion);

                model.addAttribute("iosVersion", iosVersion);

            } else {
                log.info("no ios version");
            }

            model.addAttribute("code", 0);

        } catch (Exception e) {
            e.printStackTrace();
        }
        return "/academy-course-service/system/version";
    }


}
