package com.ptteng.keeper.home.util;

import com.qding.common.util.DataUtils;
import org.junit.Test;

import java.util.Random;

public class StringUtil {
    /**
     * 自定义进制(0,1没有加入,容易与o,l混淆)
     */
    private static final char[] r = new char[]{'q', 'w', 'e', '8', 'a', 's', '2', 'd', 'z', 'x', '9', 'c', '7', 'p', '5', 'i', 'k', '3', 'm', 'j', 'u', 'f', 'r', '4', 'v', 'y', 'l', 't', 'n', '6', 'b', 'g', 'h'};

    /**
     * (不能与自定义进制有重复)
     */
    private static final char b = 'o';

    /**
     * 进制长度
     */
    private static final int binLen = r.length;

    /**
     * 序列最小长度
     */
    private static int s = 6;

    /**
     * 根据ID生成六位随机码
     *
     * @param id ID
     * @return 随机码
     */
    public static String toSerialCode(long id, int len) {
        char[] buf = new char[32];
        int charPos = 32;
        if (DataUtils.isNotNullOrEmpty(len)) {
            s = len;
        }
        while ((id / binLen) > 0) {
            int ind = (int) (id % binLen);
            buf[--charPos] = r[ind];
            id /= binLen;
        }
        buf[--charPos] = r[(int) (id % binLen)];
        String str = new String(buf, charPos, (32 - charPos));
        // 不够长度的自动随机补全
        if (str.length() < s) {
            StringBuilder sb = new StringBuilder();
            sb.append(b);
            Random rnd = new Random();
            for (int i = 1; i < s - str.length(); i++) {
                sb.append(r[rnd.nextInt(binLen)]);
            }
            str += sb.toString();
        }
        return str;
    }

    public static long codeToId(String code) {
        char chs[] = code.toCharArray();
        long res = 0L;
        for (int i = 0; i < chs.length; i++) {
            int ind = 0;
            for (int j = 0; j < binLen; j++) {
                if (chs[i] == r[j]) {
                    ind = j;
                    break;
                }
            }
            if (chs[i] == b) {
                break;
            }
            if (i > 0) {
                res = res * binLen + ind;
            } else {
                res = ind;
            }
        }
        return res;
    }

    public static String stringEncryption(String string) {
        // 括号表示组，被替换的部分$n表示第n组的内容
        return string.replaceAll("(\\d{3})\\d{4}(\\d{4})", "$1****$2");
    }


    public static boolean isIdCard(String arrIdCard) {
        int sigma = 0;
        Integer[] a = { 7, 9, 10, 5, 8, 4, 2, 1, 6, 3, 7, 9, 10, 5, 8, 4, 2 };
        String[] w = { "1", "0", "X", "9", "8", "7", "6", "5", "4", "3", "2" };
        for (int i = 0; i < 17; i++) {
            int ai = Integer.parseInt(arrIdCard.substring(i, i + 1));
            int wi = a[i];
            sigma += ai * wi;
        }
        int number = sigma % 11;
        String check_number = w[number];
        if (!arrIdCard.substring(17).equals(check_number)) {
            return false;
        } else {
            return true;
        }
    }

    public static String getRandomStringByLength(int length) {
        String base = "0123456789";
        Random random = new Random();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < length; i++) {
            int number = random.nextInt(base.length());
            sb.append(base.charAt(number));
        }
        return sb.toString();
    }
//
    @Test
    public void ee() {
        System.out.println(isIdCard("460200199111114445"));
        System.out.println(codeToId("sobyrz"));
        System.out.println(getRandomStringByLength(7));
    }

}

