package com.ptteng.keeper.home.controller;

import com.ptteng.common.storage.util.ImgStorageUtil;
import com.ptteng.keeper.common.constants.Constants;
import com.ptteng.keeper.common.model.User;
import com.ptteng.keeper.common.service.UserService;
import com.ptteng.keeper.home.constant.WxConfig;
import com.ptteng.keeper.home.util.WxUtil;
import com.ptteng.keeper.home.util.XmlUtil;
import com.qding.common.util.DataUtils;
import com.qding.community.common.weixin.service.WeiXinService;
import com.qding.community.common.weixin.vo.JSAPI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.File;
import java.util.*;

/**
 * Created by lishaobo on 2018/8/08/04
 */
@Controller
public class WxController {

    private static final Log log = LogFactory.getLog(WxController.class);

    @Autowired
    private WeiXinService weixinService;
    @Autowired
    private UserService userService;
    @Autowired
    private ImgStorageUtil imgStorageUtil;


    private final static String EVENT_SUBSCRIBE = "subscribe";
    private final static String EVENT_UNSUBSCRIBE = "unsubscribe";
    private final static String EVENT_SCAN = "SCAN";

    /**
     * 网址接入
     *
     * @param timestamp 时间戳
     * @param signature 微信加密签名，signature结合了开发者填写的token参数和请求中的timestamp参数、nonce参数
     * @param nonce     随机数
     * @param echostr   随机字符串
     * @return echostr
     * @throws Exception ex
     */
    @RequestMapping(value = "/a/wx", method = {RequestMethod.GET})
    public String doGet(HttpServletRequest request, ModelMap model, HttpServletResponse response, String signature,
                        String timestamp, String nonce, String echostr) throws Exception {

        log.info("-------------------access weixin start-----------------------");

        log.info("signature=" + signature + ", timestamp=" + timestamp + ",nonce=" + nonce + ",echostr=" + echostr);

        if (null != timestamp && null != nonce && null != echostr && null != signature

                && weixinService.access(WxConfig.token, signature, timestamp, nonce)) {

        } else {

            log.warn("请求来源校验失败, signature=" + signature + ", timestamp=" + timestamp + ",nonce=" + nonce);
        }
        log.info(echostr);
        log.info("-------------------access weixin end-----------------------");

        model.addAttribute("echostr", echostr);

        return "/weixin/token/show";
    }


    /**
     * show 接受微信消息推送
     *
     * @param content xml串
     * @return string
     * @throws Exception ex
     */
    @RequestMapping(value = "/a/wx", method = RequestMethod.POST)
    public String getMessage(HttpServletRequest request, ModelMap model, HttpServletResponse response, @RequestBody String content) throws Exception {

        log.info("-------------------get weixin push messgae start-----------------------");
        log.info("str is " + content);
        try {
            List<String> params = new ArrayList<>();
            params.add("ToUserName");
            params.add("FromUserName");
            params.add("CreateTime");
            params.add("MsgType");
            params.add("Event");
            params.add("EventKey");
            params.add("Ticket");

            Map<String, String> map = XmlUtil.xmlParams(content, params);
            String openID = map.get("FromUserName");
            String invitationCode = map.get("EventKey");
            String event = map.get("Event");
            log.info("map is " + map);
            log.info("openID=" + openID + " ,Event=" + event + " ,EventKey=" + invitationCode);
            //用户未关注时，扫码关注后推送的消息
            if (EVENT_SUBSCRIBE.equals(event) && DataUtils.isNotNullOrEmpty(invitationCode)) {
                //查openid是否注册
                Long uid = userService.getUserIdByOpenid(openID);
                if (DataUtils.isNotNullOrEmpty(uid)) {
                    log.info("User already exists ,id is " + uid);
                    return "";
                }

                //查找邀请码归属
                invitationCode = invitationCode.split("qrscene_")[1];
                log.info("invitationCode is " + invitationCode);
                uid = userService.getUserIdByInvitationCode(invitationCode);
                if (DataUtils.isNullOrEmpty(uid)) {
                    log.info("Invitation code does not exist");
                    return "";
                }
                //创建用户
                User user = new User();
                user.setMobile(Constants.DEFAULT_STR_NONE);
                user.setPwd(Constants.DEFAULT_STR_NONE);
                user.setStatus(User.STATUS_NORMAL);
                user.setAvatar(Constants.DEFAULT_STR_NONE);
                user.setNick(Constants.DEFAULT_STR_NONE);
                user.setOpenid(openID);
                user.setRecommendId(uid);
                user.setInvitationCode(Constants.DEFAULT_STR_NONE);
                user.setCreateBy(uid);
                user.setUpdateBy(uid);
                user.setLastLoginAt(Constants.DEFAULT_LONG_NONE);
                user.setToken(Constants.DEFAULT_STR_NONE);
                user.setName(Constants.DEFAULT_STR_NONE);
                user.setIdCard(Constants.DEFAULT_STR_NONE);
                Long resultId = userService.insert(user);
                log.info("create user success ,id is " + resultId);
            }
            //未成为代理用户取关清空邀请信息
            if (EVENT_UNSUBSCRIBE.equals(event)) {
                Long uid = userService.getUserIdByOpenid(openID);
                User user = userService.getObjectById(uid);
                if (DataUtils.isNullOrEmpty(user.getMobile()) && DataUtils.isNullOrEmpty(user.getInvitationCode())) {
                    user.setRecommendId(Constants.DEFAULT_LONG_NONE);
                    user.setCreateBy(Constants.DEFAULT_LONG_NONE);
                    user.setUpdateBy(Constants.DEFAULT_LONG_NONE);
                    userService.update(user);
                    log.info("clear user recommend id success ,id is " + uid);
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
            log.error(e);
        }
        log.info("-------------------get weixin push messgae  end-----------------------");

        model.addAttribute("echostr", "");

        return "/weixin/token/show";
    }

    /**
     * show 获取签名
     *
     * @param url 获取签名页面
     * @return 签名信息
     */
    @RequestMapping(value = "/a/wx/signature", method = RequestMethod.GET)
    public String updateToken(HttpServletRequest request, HttpServletResponse response, ModelMap model, String url) {

        log.info("---------------------------get the signature start---------------------------");

        log.info("usl is :" + url);

        try {

            weixinService.updateAccessToken();

            JSAPI jsapi = weixinService.getJSAPI(null, null, url);

            log.info("url " + url + " get JSAPI success :" + jsapi);

            log.info("---------------------------get the signature end---------------------------");

            model.addAttribute("code", 0);
            model.addAttribute("jsapi", jsapi);

        } catch (Throwable t) {
            log.error("get signature info error");
            t.printStackTrace();
        }
        return "/weixin/jsapi/show";

    }

    private static final Integer IS_SAVE_TRUE = 1;
    private static final Integer IS_SAVE_FAIL = 0;

    /**
     * show 获取二维码ticket
     *
     * @param str    字符参数信息
     * @param num    数字参数信息
     * @param isSave 是否需要转存 0否1是
     * @return 签名信息
     */
    @RequestMapping(value = "/a/u/wx/qrcode", method = RequestMethod.GET)
    public String getQrCode(HttpServletRequest request, HttpServletResponse response, ModelMap model, Long num, String str, Integer isSave) {

        log.info("---------------------------get the QRCode start---------------------------");

        log.info("num is :" + num + " ,str is " + str + " ,isSave is " + isSave);
        if (DataUtils.isNullOrEmpty(isSave)) {
            isSave = IS_SAVE_FAIL;
        }
        try {
            String ticket = weixinService.getQRTicket(WxConfig.appID, WxConfig.appSecret, num, str);
            log.info("ticket " + ticket);
            log.info("---------------------------get the QRCode end---------------------------");

            model.addAttribute("ticket", ticket);

            if (IS_SAVE_TRUE.equals(isSave)) {
                String imgUrl = weixinService.createLimitQRCode(ticket);
                log.info("imgUrl=" + imgUrl);
                File file = WxUtil.urlToFile(imgUrl);
                assert file != null;
                log.info("file is " + file.getName());

                String ossPath = imgStorageUtil.imgStorage(null, "QRCode" + "/" + file.getName(), file.getPath());
                log.info("QRCode" + " upload success ,and file name is " + file.getName() + "temp path is " + file.getPath()
                        + " access url is " + ossPath);
                boolean result = file.delete();
                log.info("delete result:" + result);
                model.addAttribute("url", ossPath);
            }

            model.addAttribute("code", 0);


        } catch (Throwable t) {
            log.error("get signature info error");
            t.printStackTrace();
        }
        return "/weixin/qrCode/show";

    }


//  /**
//   * 创建菜单
//   *
//   * @param timestamp 时间戳
//   * @param signature 微信加密签名，signature结合了开发者填写的token参数和请求中的timestamp参数、nonce参数
//   * @param nonce 随机数
//   * @param echostr 随机字符串
//   * @return echostr
//   * @throws Exception ex
//   */
//  @RequestMapping(value = "/a/wx/createMenu", method = {RequestMethod.GET})
//  public String createMenu(HttpServletRequest request, ModelMap model, HttpServletResponse response, String signature,
//                      String timestamp, String nonce, String echostr) throws Exception {
//
//    log.info("-------------------access weixin start-----------------------");
//
//    log.info("signature=" + signature + ", timestamp=" + timestamp + ",nonce=" + nonce + ",echostr=" + echostr);
//
//    if (null != timestamp && null != nonce && null != echostr && null != signature
//
//            && weixinService.access(WxConfig.token, signature, timestamp, nonce)) {
//
//    } else {
//
//      log.warn("请求来源校验失败, signature=" + signature + ", timestamp=" + timestamp + ",nonce=" + nonce);
//    }
//    log.info(echostr);
//    log.info("-------------------access weixin end-----------------------");
//
//    model.addAttribute("echostr", echostr);
//
//    return "/weixin/token/show";
//  }


//  //微信支付订单信息
//  @RequestMapping(value = "/a/u/pay/info/{oid}", method = RequestMethod.GET)
//  public String getPayInfo(HttpServletRequest request, HttpServletResponse response, ModelMap model, @PathVariable Long oid) {
//    log.info("order : " + oid + " get pay info ");
//
//    XmlUtil xmlUtil = new XmlUtil();
//
//    String name = "";
//
//    try {
//      log.info("==========检验是否拥有本订单==========");
//      Orders order = orderService.getObjectById(oid);
//      if (null == order) {
//        log.info("already pay the order");
//        model.addAttribute("code", -3007);
//        return "/common/success";
//      }
//
//      name = order.getProduct();
//
//      /* 校验订单状态 */
//      Integer status = order.getStatus();
//      switch (status) {
//        case Orders.ORDER_FAILED: {
//          log.info("orders status is :" + status);
//          model.addAttribute("code", -24014);
//          return "/common/success";
//        }
//        case Orders.PAYMENT_FAIL: {
//          log.info("orders status is :" + status);
//          model.addAttribute("code", -24015);
//          return "/common/success";
//        }
//        case Orders.PAYMENT_IS_SUCCESSFUL: {
//          log.info("orders status is :" + status);
//          model.addAttribute("code", -24016);
//          return "/common/success";
//        }
//        default:
//          break;
//      }
//
//
//      String nonce_str = getRandomStringByLength(16);
//      String timestamp = create_timestamp();
//
//      //调用微信预下单接口
//      String perSign = "appid=" + WxConstantConfig.appid
//              + "&body=" + name
//              + "&mch_id=" + WxConstantConfig.mch_id
//              + "&nonce_str=" + nonce_str
//              + "&notify_url=" + "http://dev.patient.ptteng.com/wx/payback"
//              + "&out_trade_no=" + order.getOrderNo()
//              + "&spbill_create_ip=" + "123.66.195.80"
//              + "&total_fee=" + order.getAmount().multiply(new BigDecimal(100)).intValue()
//              + "&trade_type=APP"
//              + "&key=" + WxConstantConfig.app_key;
//
//      String sign = MD5.MD5Encode(perSign);
//      sign = WxUtil.exChange(sign);
//      log.info("sign is : " + sign);
//
//      String url = "<xml>" +
//              "<appid>" + WxConstantConfig.appid + "</appid>" +
//              "<body>" + name + "</body>" +
//              "<mch_id>" + WxConstantConfig.mch_id + "</mch_id>" +
//              "<nonce_str>" + nonce_str + "</nonce_str>" +
//              "<notify_url>" + "http://dev.patient.ptteng.com/wx/payback" + "</notify_url>" +
//              "<out_trade_no>" + order.getOrderNo() + "</out_trade_no>" +
//              "<spbill_create_ip>" + "123.66.195.80" + "</spbill_create_ip>" +
//              "<total_fee>" + order.getAmount().multiply(new BigDecimal(100)).intValue() + "</total_fee>" +
//              "<trade_type>APP</trade_type>" +
//              "<sign>" + sign + "</sign>" +
//              "</xml>";
//      log.info("url is : " + url);
//
//
//      String httpsresponse = httpClientUtil.sendPostRequestByJava(WxConstantConfig.order_url, url);
//      log.info("get order url result is " + httpsresponse);
//
//      String prepay_id = xmlUtil.xml(httpsresponse);
//
//      log.info("prepay_id is :" + prepay_id);
//
//      String perPaySign =
//              "appid=" + WxConstantConfig.appid
//                      + "&noncestr=" + nonce_str
//                      + "&package=Sign=WXPay"
//                      + "&partnerid=" + WxConstantConfig.mch_id
//                      + "&prepayid=" + prepay_id
//                      + "&timestamp=" + timestamp
//                      + "&key=" + WxConstantConfig.app_key;
//      String paySign = MD5.MD5Encode(perPaySign);
//      paySign = WxUtil.exChange(paySign);
//      log.info("paySign is :" +paySign);
//
//      model.addAttribute("code", 0);
//      model.addAttribute("prepay_id",prepay_id);
//      model.addAttribute("nonceStr", nonce_str);
//      model.addAttribute("signType", "MD5");
//      model.addAttribute("timeStamp", timestamp);
//      model.addAttribute("paySign", paySign);
//
//    } catch (Throwable t) {
//      log.error("get signature info error");
//      t.printStackTrace();
//    }
//    return "/weixin/order/show";
//
//
//  }


    public static String getRandomStringByLength(int length) {
        String base = "abcdefghijklmnopqrstuvwxyz0123456789";
        Random random = new Random();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < length; i++) {
            int number = random.nextInt(base.length());
            sb.append(base.charAt(number));
        }
        return sb.toString();
    }

    private static String create_timestamp() {
        return Long.toString(System.currentTimeMillis() / 1000);
    }


    //通过xml 发给微信消息
    public static String setXml(String return_code, String return_msg) {
        SortedMap<String, String> parameters = new TreeMap<String, String>();
        parameters.put("return_code", return_code);
        parameters.put("return_msg", return_msg);
        return "<xml><return_code><![CDATA[" + return_code + "]]>" +
                "</return_code><return_msg><![CDATA[" + return_msg + "]]></return_msg></xml>";
    }

}
