package com.ptteng.keeper.home.controller;

import com.gemantic.common.util.MyListUtil;
import com.ptteng.keeper.common.model.*;
import com.ptteng.keeper.common.service.ApplyingRecordService;
import com.ptteng.keeper.common.service.IncomeRecordService;
import com.ptteng.keeper.common.service.ProductService;
import com.ptteng.keeper.common.service.UserAssetService;
import com.ptteng.keeper.home.util.StringUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.List;

/**
 * Product  crud
 *
 * @author magenm
 * @Date 2014-4-16 13:43
 */
@Controller
public class IncomeController {
    private static final Log log = LogFactory.getLog(IncomeController.class);

    @Autowired
    private ProductService productService;
    @Autowired
    private UserAssetService userAssetService;
    @Autowired
    private IncomeRecordService incomeRecordService;
    @Autowired
    private ApplyingRecordService applyingRecordService;

    /**
     * show 我的工资
     *
     * @return userAsset
     * @throws Exception 异常信息
     * @author lishaobo
     * @date 2018/8/4
     */
    @RequestMapping(value = "/a/u/income", method = RequestMethod.GET)
    public String getIncome(HttpServletRequest request,
                            HttpServletResponse response, ModelMap model, Integer page,
                            Integer size, Integer belongModule) throws Exception {
        User user = (User) request.getAttribute("user");
        log.info(" get income ,id=" + user.getId());

        try {

            UserAsset userAsset = userAssetService.getObjectById(user.getId());
            model.addAttribute("code", 0);

            model.addAttribute("userAsset", userAsset);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get product list error");
            // for test
            model.addAttribute("code", -100000);
        }

        return "/keeper/userAsset/json/userAssetDetailJson";
    }


    /**
     * show 工资明细
     *
     * @param type 收入类型1返佣 2合伙人
     * @return income apply product
     * @throws Exception 异常信息
     * @author lishaobo
     * @date 2018/8/4
     */
    @RequestMapping(value = "/a/u/income/detail", method = RequestMethod.GET)
    public String getIncomeDetail(HttpServletRequest request,
                                  HttpServletResponse response, ModelMap model, Integer type) throws Exception {
        User user = (User) request.getAttribute("user");
        log.info(" get income detail : id=" + user.getId());
        if (type == null || type > IncomeRecord.TYPE_COPARTNER) {
            type = IncomeRecord.TYPE_REBATE;
        }


        try {
            //用户收入记录
            List<Long> irids = incomeRecordService.getIncomeRecordIdsByUidAndTypeOrderByCreateAt(user.getId(), type, 0, Integer.MAX_VALUE);
            List<IncomeRecord> incomeRecordList = new ArrayList<>();
            if (irids.size() >0) {
                incomeRecordList = incomeRecordService.getObjectsByIds(irids);
            }
            //产品列表
            List<Long> pids = MyListUtil.getList(IncomeRecord.class.getDeclaredField("productId"), incomeRecordList);
            List<Product> productList = new ArrayList<>();
            if (pids.size() >0) {
                productList = productService.getObjectsByIds(pids);
            }

            //申请信息
            List<Long> aids = MyListUtil.getList(IncomeRecord.class.getDeclaredField("targetId"), incomeRecordList);
            List<ApplyingRecord> applyingRecordList = applyingRecordService.getObjectsByIds(aids);
            for (ApplyingRecord applyingRecord : applyingRecordList) {
                applyingRecord.setMobile(StringUtil.stringEncryption(applyingRecord.getMobile()));
            }


            model.addAttribute("code", 0);

            model.addAttribute("applyingRecordList", applyingRecordList);
            model.addAttribute("productList", productList);
            model.addAttribute("incomeRecordList", incomeRecordList);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get product list error");
            // for test
            model.addAttribute("code", -1);
        }

        return "/keeper/incomeRecord/json/incomeRecordListJson";
    }


}

