package com.ptteng.keeper.finance.etl;

import com.ptteng.common.dao.util.SQLUtil;
import com.ptteng.keeper.common.model.UserAsset;
import com.ptteng.keeper.common.service.UserAssetService;
import com.ptteng.keeper.finance.etl.unit.DynamicUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.stereotype.Component;

@Component
public class UserAssetEtl {


    private static final Log log = LogFactory.getLog("commentEtl");



    private UserAssetService userAssetService;

    private Long interval = 30000L;


    public void process() throws InterruptedException {
            try {
                log.info("this time is " +System.currentTimeMillis());
                Object d =userAssetService.getObjectByDynamicCondition(UserAsset.class, DynamicUtil.updateUserAssetTodayAmount(), 0, Integer.MAX_VALUE);
                log.info("==d "+d);
            } catch (Throwable t) {

                t.printStackTrace();
                log.error("process goods bytime status error ,sleep " + t.getMessage());
            }
    }

    public UserAssetService getUserAssetService() {
        return userAssetService;
    }

    public void setUserAssetService(UserAssetService userAssetService) {
        this.userAssetService = userAssetService;
    }


    public Long getInterval() {
        return interval;
    }

    public void setInterval(Long interval) {
        this.interval = interval;
    }


    public static void main(String[] arg) {

    }


}
