package com.ptteng.keeper.common.util.cft;

import com.alibaba.fastjson.JSONObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.io.*;
import java.net.URL;
import java.security.*;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.*;

/**
 * ǩ��&��ǩ��
 * @author xiezz
 * @version 1.0.0
 * @date 2015-08-06
 */
public class Signature {


    private static final Log log = LogFactory
            .getLog(Signature.class);
    private static char[] hexChar = {'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    /**
     * ����ǩ��MAC�ַ���
     * @return MAC�ַ���
     */
    public static String generateMAC(Map<String, String> params,String commKey,String mrch_cert,String mrch_cert_pwd) {

       	/* Ĭ��ΪSHA1�㷨 */

        log.info(" generateMAC  start = mrch_cert =  "+mrch_cert+" mrch_cert_pwd = "+mrch_cert_pwd);
        if (params.containsKey("sign_type") && params.get("sign_type").equals("RSA")) {
            log.info("  sign_type  =  RSA ");
            try {
                PrivateKey privKey = readPrivateKey(mrch_cert,mrch_cert_pwd);
                log.info("  privKey  =  privKey "+privKey);
                java.security.Signature signature = java.security.Signature.getInstance("SHA1WithRSA");

                signature.initSign(privKey);
                signature.update(generateParamStr(params).getBytes());
                byte[] signed = signature.sign();

                // 计算base64encode(signed)，无换行。如无法使用，请自行替换为其它BASE64类库。
                @SuppressWarnings("restriction")
                String mac = new sun.misc.BASE64Encoder().encode(signed)
                        .replaceAll(System.getProperty("line.separator"), "");

                return mac;
            } catch (Exception e) {
                log.info("   error SIGNATURE_RSA_CERT_ERROR ");
                // 读取证书等出错
                return "SIGNATURE_RSA_CERT_ERROR";
            }
        } else {		/* 默认为SHA1算法 */
            log.info("  sign_type  =  SAH1 ");
            return encryptBySHA(generateParamStr(params) + "&" +commKey);
        }


    }
    /**
     * SHAժҪ�㷨���������ݽ���UTF-8����
     * @param content ��������
     * @return ����ժҪ��40λ16�����ַ���
     */
    private static String encryptBySHA(String content) {
        if (content == null) return null;

        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            byte[] output = md.digest(content.getBytes("UTF-8"));
            return bytesToHexStr(output);
        } catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return null;
    }
    /**
     * ��byte����ת��Ϊ16���Ƹ�ʽ���ַ���
     * @param bytes ��ת������
     * @return 16���Ƹ�ʽ���ַ���
     */
    private static String bytesToHexStr(byte[] bytes) {
        StringBuffer sb = new StringBuffer(bytes.length * 2);
        for (int i = 0; i < bytes.length; i++) {
            sb.append(hexChar[(bytes[i] & 0xf0) >>> 4]);
            sb.append(hexChar[bytes[i] & 0x0f]);
        }
        return sb.toString();
    }
    /**
     * ��������MAC����Ĳ����ַ�����<br>
     * @return ģʽΪkey=value&key=value
     */
    private static String generateParamStr(Map<String, String> params) {
        // ȡ���зǿ��ֶ����ݣ���mac���⣩�������б�
        List<String> paramList = new ArrayList<String>();
        for (String key : params.keySet()) {
            if ("mac".equals(key)) {
                continue;
            }
            String val = params.get(key);
            paramList.add(key + "=" + val);
        }
        // ����
        if (paramList.size() == 0) {
            return null;
        }
        // ���б��������
        Collections.sort(paramList);
        // ��&���ָ�ƴװ���ַ���
        StringBuilder sb = new StringBuilder();
        sb.append(paramList.get(0));
        for (int i = 1; i < paramList.size(); i++) {
            sb.append("&").append(paramList.get(i));
        }
        return sb.toString();
    }
    /**
     * 验证服务器返回的信息中签名的正确性
     * @param params    参数列表（包含mac参数）
     * @return true-验签通过，false-验签失败
     */
    public static boolean verifyMAC(Map<String, String> params,String commKey,String cert) {
        if (!params.containsKey("mac")) return false;
        String mac = params.get("mac");
        log.info(" mac = "+mac);
        if (params.containsKey("sign_type") && params.get("sign_type").equals("RSA")) {
            if (mac == null) return false;
            log.info(" sign_type =  RSA  ");
            try {
                PublicKey pubKey = readPublicKey(cert);
                java.security.Signature signature = java.security.Signature.getInstance("SHA1WithRSA");

                signature.initVerify(pubKey);
                signature.update(generateParamStr(params).getBytes());

                // 计算base64decode(mac)。如无法使用，请自行替换为其它BASE64类库。
                @SuppressWarnings("restriction")
                byte[] bmac = new sun.misc.BASE64Decoder().decodeBuffer(mac);
              //  log.info(" veryfy result  "+signature.verify(bmac));
                Boolean result = signature.verify(bmac);
                log.info("  result = "+result);
                return result;
            } catch (Exception e) {
                return false;
            }
        } else {		/* 默认为SHA1算法 */
            if (mac != null && mac.equals(generateMAC(params,commKey,"",""))) return true;
            else return false;
        }
        }

    public static Map<String, String> jsonToMap(String jsonStr) {
        Map<String, String> map = new HashMap<String, String>();
        JSONObject json = JSONObject.parseObject(jsonStr);
        Iterator<String> keys = json.keySet().iterator();
        while (keys.hasNext()) {
            String key = (String) keys.next();
            String value = json.get(key).toString();
            map.put(key, value);
        }
        return map;
    }

    /**
     * 读取PFX文件中的商户私钥，实际使用中可缓存该函数返回值
     * @param certPath    证书文件路径
     * @param password    密码
     * @return 私钥
     * @throws KeyStoreException
     * @throws NoSuchAlgorithmException
     * @throws CertificateException
     * @throws IOException
     * @throws UnrecoverableKeyException
     */
    private static PrivateKey readPrivateKey(String certPath, String password)
            throws KeyStoreException, NoSuchAlgorithmException, CertificateException,
            IOException, UnrecoverableKeyException {

        KeyStore keyStore = KeyStore.getInstance("pkcs12");
        InputStream is = null;

        File file = new File(certPath);
        if (file.exists()) {
            is = new FileInputStream(certPath);
        } else {
            Class<? extends Signature> clz = Signature.class;
            ClassLoader cl = clz.getClassLoader();

            URL url = cl.getResource(certPath);
            if (url == null) throw new FileNotFoundException();

            is = cl.getResourceAsStream(certPath);
        }
        keyStore.load(is, password == null ? null : password.toCharArray());
        if (is != null) is.close();

        return (PrivateKey) keyStore.getKey(keyStore.aliases().nextElement(), password == null ? null : password.toCharArray());
    }
    /**
     * 读取CRT文件中的银行公钥，实际使用中可缓存该函数返回值
     * @param certPath    证书文件路径
     * @return 公钥
     * @throws CertificateException
     * @throws IOException
     */
    private static PublicKey readPublicKey(String certPath)
            throws CertificateException, IOException {

        File file = new File(certPath);
        InputStream is = null;
        if (file.exists()) {
            is = new FileInputStream(certPath);
        } else {
            Class<? extends Signature> clz = Signature.class;
            ClassLoader cl = clz.getClassLoader();

            URL url = cl.getResource(certPath);
            if (url == null) throw new FileNotFoundException();

            is = cl.getResourceAsStream(certPath);
        }
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        X509Certificate cert = (X509Certificate) cf.generateCertificate(is);
        if (is != null) is.close();
        return cert.getPublicKey();
    }

}
