package com.ptteng.keeper.common.service.impl;

import java.util.List;
import java.util.ArrayList;
import java.util.Map;

import org.osoa.sca.annotations.Remotable;

import com.ptteng.keeper.common.model.WithdrawIncomeRelation;
import com.ptteng.keeper.common.service.WithdrawIncomeRelationService;



import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;


import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.Dao;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;


public class WithdrawIncomeRelationServiceImpl extends BaseDaoServiceImpl implements WithdrawIncomeRelationService {



	private static final Log log = LogFactory.getLog(WithdrawIncomeRelationServiceImpl.class);




	@Override
	public Long insert(WithdrawIncomeRelation withdrawIncomeRelation)throws ServiceException, ServiceDaoException{



		log.info(" insert data : " + withdrawIncomeRelation);

		if (withdrawIncomeRelation == null) {
			return null;
		}

		long currentTimeMillis = System.currentTimeMillis();
		withdrawIncomeRelation.setCreateAt(currentTimeMillis);
		withdrawIncomeRelation.setUpdateAt(currentTimeMillis);

		Long result = null;
		try {
			result = (Long) dao.save(withdrawIncomeRelation);
		} catch (DaoException e) {
			log.error(" insert wrong : " + withdrawIncomeRelation);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}

		log.info(" insert data success : " + result);

		return result;
	}


	@Override
	public List<WithdrawIncomeRelation> insertList(List<WithdrawIncomeRelation> withdrawIncomeRelationList)throws ServiceException, ServiceDaoException{



		log.info(" insert lists : " + (withdrawIncomeRelationList == null ? "null" : withdrawIncomeRelationList.size()));

		List<WithdrawIncomeRelation> resultList = null;

		if (CollectionUtils.isEmpty(withdrawIncomeRelationList)) {
			return new ArrayList<WithdrawIncomeRelation>();
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (WithdrawIncomeRelation withdrawIncomeRelation : withdrawIncomeRelationList) {
			withdrawIncomeRelation.setCreateAt(currentTimeMillis);
			withdrawIncomeRelation.setUpdateAt(currentTimeMillis);
		}

		try {
			resultList = (List<WithdrawIncomeRelation>) dao.batchSave(withdrawIncomeRelationList);
		} catch (DaoException e) {
			log.error(" insert list wrong : " + withdrawIncomeRelationList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}

		log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));

		return resultList;



	}


	@Override
	public boolean delete(Long id)throws ServiceException, ServiceDaoException{



		log.info(" delete data : " + id);

		boolean result = false;

		if (id == null) {
			return true;
		}

		try {
			result = dao.delete(WithdrawIncomeRelation.class, id);
		} catch (DaoException e) {
			log.error(" delete wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}

		log.info(" delete data success : " + id);

		return result;

	}


	@Override
	public boolean update(WithdrawIncomeRelation withdrawIncomeRelation)throws ServiceException, ServiceDaoException{



		log.info(" update data : " + (withdrawIncomeRelation == null ? "null" : withdrawIncomeRelation.getId()));

		boolean result = false;

		if (withdrawIncomeRelation == null) {
			return true;
		}

		withdrawIncomeRelation.setUpdateAt(System.currentTimeMillis());

		try {
			result = dao.update(withdrawIncomeRelation);
		} catch (DaoException e) {
			log.error(" update wrong : " + withdrawIncomeRelation);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if(log.isInfoEnabled()){
			log.info(" update data success : " + withdrawIncomeRelation);
		}
		return result;
	}


	@Override
	public boolean updateList(List<WithdrawIncomeRelation> withdrawIncomeRelationList)throws ServiceException, ServiceDaoException{


		log.info(" update lists : " + (withdrawIncomeRelationList == null ? "null" : withdrawIncomeRelationList.size()));

		boolean result = false;

		if (CollectionUtils.isEmpty(withdrawIncomeRelationList)) {
			return true;
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (WithdrawIncomeRelation withdrawIncomeRelation : withdrawIncomeRelationList) {
			withdrawIncomeRelation.setUpdateAt(currentTimeMillis);
		}

		try {
			result = dao.batchUpdate(withdrawIncomeRelationList);
		} catch (DaoException e) {
			log.error(" update list wrong : " + withdrawIncomeRelationList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}

		log.info(" update lists success : " + withdrawIncomeRelationList.size());

		return result;
	}


	@Override
	public WithdrawIncomeRelation getObjectById(Long id)throws ServiceException, ServiceDaoException{



		log.info(" get data : " + id);

		WithdrawIncomeRelation withdrawIncomeRelation = null;

		if (id == null) {
			return withdrawIncomeRelation;
		}

		try {
			withdrawIncomeRelation = (WithdrawIncomeRelation) dao.get(WithdrawIncomeRelation.class, id);
		} catch (DaoException e) {
			log.error(" get wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}

		log.info(" get data success : " + id);

		return withdrawIncomeRelation;
	}


	@Override
	public List<WithdrawIncomeRelation> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{



		log.info(" get lists : " + (ids == null ? "null" : ids));

		List<WithdrawIncomeRelation> withdrawIncomeRelation = null;

		if (CollectionUtils.isEmpty(ids)) {
			return new ArrayList<WithdrawIncomeRelation>();
		}

		try {
			withdrawIncomeRelation = (List<WithdrawIncomeRelation>) dao.getList(WithdrawIncomeRelation.class, ids);
		} catch (DaoException e) {
			log.error(" get wrong : " + ids);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}

		log.info(" get data success : " + (withdrawIncomeRelation == null ? "null" : withdrawIncomeRelation.size()));

		return withdrawIncomeRelation;
	}







	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	@Override
	public List<Long>  getIncomeRecordIdsByWid(Long wid,Integer start,Integer limit)throws ServiceException, ServiceDaoException{

		if(log.isInfoEnabled()){
			log.info(" get ids by wid,start,limit  : " + wid+" , "+start+" , "+limit );
		}
		List<Long> idList = null;

		// TODO 参数检查!

		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}

		try {
			idList = dao.getIdList("getWithdrawIncomeRelationIdsByWid", new Object[] { wid},start,limit, false);


		} catch (DaoException e) {
			log.error(" get ids  wrong by wid,start,limit)  : " + wid+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if(log.isInfoEnabled()){
			log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
		}
		return idList;



	}



	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	@Override
	public List<Long>  getWithdrawIncomeRelationIdsByIncomeId(Long incomeId,Integer start,Integer limit)throws ServiceException, ServiceDaoException{

		if(log.isInfoEnabled()){
			log.info(" get ids by incomeId,start,limit  : " + incomeId+" , "+start+" , "+limit );
		}
		List<Long> idList = null;

		// TODO 参数检查!

		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}

		try {
			idList = dao.getIdList("getWithdrawIncomeRelationIdsByIncomeId", new Object[] { incomeId},start,limit, false);


		} catch (DaoException e) {
			log.error(" get ids  wrong by incomeId,start,limit)  : " + incomeId+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if(log.isInfoEnabled()){
			log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
		}
		return idList;



	}





	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	@Override
	public Integer  countWithdrawIncomeRelationIdsByWid(Long wid)throws ServiceException, ServiceDaoException{

		if(log.isInfoEnabled()){
			log.info(" count ids by wid  : " + wid );
		}
		Integer count=null;



		try {

			count = dao.count("getWithdrawIncomeRelationIdsByWid", new Object[] { wid});


		} catch (DaoException e) {
			log.error(" count ids  wrong by wid)  : " + wid );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if(log.isInfoEnabled()){
			log.info(" count  success : " + count);
		}
		return count;



	}



	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	@Override
	public Integer  countWithdrawIncomeRelationIdsByIncomeId(Long incomeId)throws ServiceException, ServiceDaoException{

		if(log.isInfoEnabled()){
			log.info(" count ids by incomeId  : " + incomeId );
		}
		Integer count=null;



		try {

			count = dao.count("getWithdrawIncomeRelationIdsByIncomeId", new Object[] { incomeId});


		} catch (DaoException e) {
			log.error(" count ids  wrong by incomeId)  : " + incomeId );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if(log.isInfoEnabled()){
			log.info(" count  success : " + count);
		}
		return count;



	}






	@Override
	public List<Long> getWithdrawIncomeRelationIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {

		log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
		List<Long> idList = null;



		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}

		try {
			idList = dao.getIdList("getWithdrawIncomeRelationIdsAll",new Object[] {},start, limit, false);
		} catch (DaoException e) {
			log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
		}
		return idList;
	}


	@Override
	public Integer countWithdrawIncomeRelationIds() throws ServiceException,
			ServiceDaoException {
		Integer count =  0;
		try {
			count = dao.count("getWithdrawIncomeRelationIdsAll",new Object[] {});
		} catch (DaoException e) {
			log.error(" count by getWithdrawIncomeRelationIds " ) ;
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" count  : " + count);
		}
		return count;
	}

}

