package com.ptteng.keeper.common.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.keeper.common.model.IncomeRecord;
import com.ptteng.keeper.common.service.IncomeRecordService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.ArrayList;
import java.util.List;


public class IncomeRecordServiceImpl extends BaseDaoServiceImpl implements IncomeRecordService {

 

	private static final Log log = LogFactory.getLog(IncomeRecordServiceImpl.class);



		   
		@Override
		public Long insert(IncomeRecord incomeRecord)throws ServiceException, ServiceDaoException{
		
	
		          
    log.info(" insert data : " + incomeRecord);

		if (incomeRecord == null) {
			return null;
		}

		long currentTimeMillis = System.currentTimeMillis();
		incomeRecord.setCreateAt(currentTimeMillis);
		incomeRecord.setUpdateAt(currentTimeMillis);

		Long result = null;
		try {
			result = (Long) dao.save(incomeRecord);
		} catch (DaoException e) {
			log.error(" insert wrong : " + incomeRecord);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert data success : " + result);
    
return result;	
		}	
		  
    	   
		@Override
		public List<IncomeRecord> insertList(List<IncomeRecord> incomeRecordList)throws ServiceException, ServiceDaoException{
		
	
		          	
        log.info(" insert lists : " + (incomeRecordList == null ? "null" : incomeRecordList.size()));
      
		List<IncomeRecord> resultList = null;

		if (CollectionUtils.isEmpty(incomeRecordList)) {
			return new ArrayList<IncomeRecord>();
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (IncomeRecord incomeRecord : incomeRecordList) {
			incomeRecord.setCreateAt(currentTimeMillis);
			incomeRecord.setUpdateAt(currentTimeMillis);
		}

		try {
			resultList = (List<IncomeRecord>) dao.batchSave(incomeRecordList);
		} catch (DaoException e) {
			log.error(" insert list wrong : " + incomeRecordList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));
    
		return resultList;
		
		
			
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
	
		            
	    log.info(" delete data : " + id);
 
		boolean result = false;

		if (id == null) {
			return true;
		}

		try {
			result = dao.delete(IncomeRecord.class, id);
		} catch (DaoException e) {
			log.error(" delete wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
 
		log.info(" delete data success : " + id);
   
		return result;
		
		}	
		  
    	   
		@Override
		public boolean update(IncomeRecord incomeRecord)throws ServiceException, ServiceDaoException{
		
	
		          
	log.info(" update data : " + (incomeRecord == null ? "null" : incomeRecord.getId()));

		boolean result = false;

		if (incomeRecord == null) {
			return true;
		}

		incomeRecord.setUpdateAt(System.currentTimeMillis());

		try {
			result = dao.update(incomeRecord);
		} catch (DaoException e) {
			log.error(" update wrong : " + incomeRecord);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
       if(log.isInfoEnabled()){
		log.info(" update data success : " + incomeRecord);
       }
		return result;	
		}	
		  
    	   
		@Override
		public boolean updateList(List<IncomeRecord> incomeRecordList)throws ServiceException, ServiceDaoException{
		
	
		          log.info(" update lists : " + (incomeRecordList == null ? "null" : incomeRecordList.size()));

		boolean result = false;

		if (CollectionUtils.isEmpty(incomeRecordList)) {
			return true;
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (IncomeRecord incomeRecord : incomeRecordList) {
			incomeRecord.setUpdateAt(currentTimeMillis);
		}

		try {
			result = dao.batchUpdate(incomeRecordList);
		} catch (DaoException e) {
			log.error(" update list wrong : " + incomeRecordList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" update lists success : " + incomeRecordList.size());
         
		return result;	
		}	
		  
    	   
		@Override
		public IncomeRecord getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
	
		              
        log.info(" get data : " + id);
      
		IncomeRecord incomeRecord = null;

		if (id == null) {
			return incomeRecord;
		}

		try {
			incomeRecord = (IncomeRecord) dao.get(IncomeRecord.class, id);
		} catch (DaoException e) {
			log.error(" get wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" get data success : " + id);
      
		return incomeRecord;		
		}	
		  
    	   
		@Override
		public List<IncomeRecord> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
	
		          	  
	    log.info(" get lists : " + (ids == null ? "null" : ids));
     
		List<IncomeRecord> incomeRecord = null;

		if (CollectionUtils.isEmpty(ids)) {
			return new ArrayList<IncomeRecord>();
		}

		try {
			incomeRecord = (List<IncomeRecord>) dao.getList(IncomeRecord.class, ids);
		} catch (DaoException e) {
			log.error(" get wrong : " + ids);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" get data success : " + (incomeRecord == null ? "null" : incomeRecord.size()));
    
		return incomeRecord;	
		}





	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	@Override
	public List<Long>  getIncomeRecordIdsByUidAndLevelOrderByCreateAt(Long uid,Integer level,Integer start,Integer limit)throws ServiceException, ServiceDaoException{

		if(log.isInfoEnabled()){
			log.info(" get ids by uid,level,start,limit  : " + uid+" , "+level+" , "+start+" , "+limit );
		}
		List<Long> idList = null;

		// TODO 参数检查!

		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}

		try {
			idList = dao.getIdList("getIncomeRecordIdsByUidAndLevelOrderByCreateAt", new Object[] { uid,level},start,limit, false);


		} catch (DaoException e) {
			log.error(" get ids  wrong by uid,level,start,limit)  : " + uid+" , "+level+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if(log.isInfoEnabled()){
			log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
		}
		return idList;



	}



	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	@Override
	public List<Long>  getIncomeRecordIdsByUidAndLevelAndProductIdOrderByCreateAt(Long uid,Integer level,Long productId,Integer start,Integer limit)throws ServiceException, ServiceDaoException{

		if(log.isInfoEnabled()){
			log.info(" get ids by uid,level,productId,start,limit  : " + uid+" , "+level+" , "+productId+" , "+start+" , "+limit );
		}
		List<Long> idList = null;

		// TODO 参数检查!

		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}

		try {
			idList = dao.getIdList("getIncomeRecordIdsByUidAndLevelAndProductIdOrderByCreateAt", new Object[] { uid,level,productId},start,limit, false);


		} catch (DaoException e) {
			log.error(" get ids  wrong by uid,level,productId,start,limit)  : " + uid+" , "+level+" , "+productId+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if(log.isInfoEnabled()){
			log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
		}
		return idList;



	}




	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getIncomeRecordIdsByTargetIdAndUidOrderByCreateAt(Long targetId,Long uid,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" get ids by targetId,uid,start,limit  : " + targetId+" , "+uid+" , "+start+" , "+limit );
	  }
	 	List<Long> idList = null;
        
        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

	try {
		idList = dao.getIdList("getIncomeRecordIdsByTargetIdAndUidOrderByCreateAt", new Object[] { targetId,uid},start,limit, false);

   
   } catch (DaoException e) {
			log.error(" get ids  wrong by targetId,uid,start,limit)  : " + targetId+" , "+uid+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
   log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
  }
		return idList;
		
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getIncomeRecordIdsByTargetIdAndProductIdOrderByCreateAt(Long targetId,Long productId,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" get ids by targetId,productId,start,limit  : " + targetId+" , "+productId+" , "+start+" , "+limit );
	  }
	 	List<Long> idList = null;
        
        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

	try {
		idList = dao.getIdList("getIncomeRecordIdsByTargetIdAndProductIdOrderByCreateAt", new Object[] { targetId,productId},start,limit, false);

   
   } catch (DaoException e) {
			log.error(" get ids  wrong by targetId,productId,start,limit)  : " + targetId+" , "+productId+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
   log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
  }
		return idList;
		
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getIncomeRecordIdsByTargetIdOrderByCreateAt(Long targetId,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" get ids by targetId,start,limit  : " + targetId+" , "+start+" , "+limit );
	  }
	 	List<Long> idList = null;
        
        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

	try {
		idList = dao.getIdList("getIncomeRecordIdsByTargetIdOrderByCreateAt", new Object[] { targetId},start,limit, false);

   
   } catch (DaoException e) {
			log.error(" get ids  wrong by targetId,start,limit)  : " + targetId+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
   log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
  }
		return idList;
		
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getIncomeRecordIdsByUidAndProductIdOrderByCreateAt(Long uid,Long productId,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" get ids by uid,productId,start,limit  : " + uid+" , "+productId+" , "+start+" , "+limit );
	  }
	 	List<Long> idList = null;
        
        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

	try {
		idList = dao.getIdList("getIncomeRecordIdsByUidAndProductIdOrderByCreateAt", new Object[] { uid,productId},start,limit, false);

   
   } catch (DaoException e) {
			log.error(" get ids  wrong by uid,productId,start,limit)  : " + uid+" , "+productId+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
   log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
  }
		return idList;
		
	
	
	}




    /**
     *
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public List<Long>  getIncomeRecordIdsByUidAndTypeOrderByCreateAt(Long uid,Integer type,Integer start,Integer limit)throws ServiceException, ServiceDaoException{

        if(log.isInfoEnabled()){
            log.info(" get ids by uid,type,start,limit  : " + uid+" , "+type+" , "+start+" , "+limit );
        }
        List<Long> idList = null;

        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

        try {
            idList = dao.getIdList("getIncomeRecordIdsByUidAndTypeOrderByCreateAt", new Object[] { uid,type},start,limit, false);


        } catch (DaoException e) {
            log.error(" get ids  wrong by uid,type,start,limit)  : " + uid+" , "+type+" , "+start+" , "+limit );
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if(log.isInfoEnabled()){
            log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
        }
        return idList;



    }

    /**
     *
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public List<Long>  getIncomeRecordIdsByWrId(Long wrId,Long uid,Integer start,Integer limit)throws ServiceException, ServiceDaoException{

        if(log.isInfoEnabled()){
            log.info(" get ids by wrId,uid,start,limit  : " +wrId +" , "+uid +" , "+start+" , "+limit );
        }
        List<Long> idList = null;

        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

        try {
            idList = dao.getIdList("getIncomeRecordIdsByWrId", new Object[] { wrId,uid},start,limit, false);


        } catch (DaoException e) {
			log.error(" get ids by wrId,uid,start,limit  : " +wrId +" , "+uid +" , "+start+" , "+limit );
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if(log.isInfoEnabled()){
            log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
        }
        return idList;



    }
    /**
     *
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public List<Long>  getIncomeRecordIdsByWrIdAndStatus(Long wrId,Long uid,Integer status,Integer start,Integer limit)throws ServiceException, ServiceDaoException{

        if(log.isInfoEnabled()){
            log.info(" get ids by wrId,uid,status,start,limit  : " +wrId +" , "+uid +" , "+" , "+status +" , "+start+" , "+limit );
        }
        List<Long> idList = null;

        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

        try {
            idList = dao.getIdList("getIncomeRecordIdsByWrIdAndStatus", new Object[] { wrId,uid,status},start,limit, false);


        } catch (DaoException e) {
            log.error(" get ids by wrId,uid,status,start,limit  : " +wrId +" , "+uid +" , "+" , "+status +" , "+start+" , "+limit );
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if(log.isInfoEnabled()){
            log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
        }
        return idList;



    }


    /**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	@Override
	public List<Long>  getIncomeRecordIdsByUidAndTypeAndLevelOrderByCreateAt(Long uid,Integer type,Integer level,Integer start,Integer limit)throws ServiceException, ServiceDaoException{

		if(log.isInfoEnabled()){
			log.info(" get ids by uid,type,level,start,limit  : " + uid+" , "+type+" , "+level+" , "+start+" , "+limit );
		}
		List<Long> idList = null;

		// TODO 参数检查!

		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}

		try {
			idList = dao.getIdList("getIncomeRecordIdsByUidAndTypeAndLevelOrderByCreateAt", new Object[] { uid,type,level},start,limit, false);


		} catch (DaoException e) {
			log.error(" get ids  wrong by uid,type,level,start,limit)  : " + uid+" , "+type+" , "+level+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if(log.isInfoEnabled()){
			log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
		}
		return idList;



	}

	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getIncomeRecordIdsByUidOrderByCreateAt(Long uid,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" get ids by uid,start,limit  : " + uid+" , "+start+" , "+limit );
	  }
	 	List<Long> idList = null;
        
        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

	try {
		idList = dao.getIdList("getIncomeRecordIdsByUidOrderByCreateAt", new Object[] { uid},start,limit, false);

   
   } catch (DaoException e) {
			log.error(" get ids  wrong by uid,start,limit)  : " + uid+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
   log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
  }
		return idList;
		
	
	
	}
	
		
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countIncomeRecordIdsByTargetIdAndUidOrderByCreateAt(Long targetId,Long uid)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" count ids by targetId,uid  : " + targetId+" , "+uid );
	  }
	 	Integer count=null;
        
       

	try {
	   
		count = dao.count("getIncomeRecordIdsByTargetIdAndUidOrderByCreateAt", new Object[] { targetId,uid});

   
   } catch (DaoException e) {
			log.error(" count ids  wrong by targetId,uid)  : " + targetId+" , "+uid );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
    log.info(" count  success : " + count);
  }
		return count;
		
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countIncomeRecordIdsByTargetIdAndProductIdOrderByCreateAt(Long targetId,Long productId)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" count ids by targetId,productId  : " + targetId+" , "+productId );
	  }
	 	Integer count=null;
        
       

	try {
	   
		count = dao.count("getIncomeRecordIdsByTargetIdAndProductIdOrderByCreateAt", new Object[] { targetId,productId});

   
   } catch (DaoException e) {
			log.error(" count ids  wrong by targetId,productId)  : " + targetId+" , "+productId );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
    log.info(" count  success : " + count);
  }
		return count;
		
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countIncomeRecordIdsByTargetIdOrderByCreateAt(Long targetId)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" count ids by targetId  : " + targetId );
	  }
	 	Integer count=null;
        
       

	try {
	   
		count = dao.count("getIncomeRecordIdsByTargetIdOrderByCreateAt", new Object[] { targetId});

   
   } catch (DaoException e) {
			log.error(" count ids  wrong by targetId)  : " + targetId );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
    log.info(" count  success : " + count);
  }
		return count;
		
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countIncomeRecordIdsByUidAndProductIdOrderByCreateAt(Long uid,Long productId)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" count ids by uid,productId  : " + uid+" , "+productId );
	  }
	 	Integer count=null;
        
       

	try {
	   
		count = dao.count("getIncomeRecordIdsByUidAndProductIdOrderByCreateAt", new Object[] { uid,productId});

   
   } catch (DaoException e) {
			log.error(" count ids  wrong by uid,productId)  : " + uid+" , "+productId );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
    log.info(" count  success : " + count);
  }
		return count;
		
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countIncomeRecordIdsByUidOrderByCreateAt(Long uid)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" count ids by uid  : " + uid );
	  }
	 	Integer count=null;
        
       

	try {
	   
		count = dao.count("getIncomeRecordIdsByUidOrderByCreateAt", new Object[] { uid});

   
   } catch (DaoException e) {
			log.error(" count ids  wrong by uid)  : " + uid );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
    log.info(" count  success : " + count);
  }
		return count;
		
	
	
	}
	
		
	
	
	
		
	@Override
	public List<Long> getIncomeRecordIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		
		log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
		List<Long> idList = null;
		
		
		
		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}
		
		try {
			idList = dao.getIdList("getIncomeRecordIdsAll",new Object[] {},start, limit, false);
		} catch (DaoException e) {
			log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
		}
		return idList;
	}
	
	
		@Override
	public Integer countIncomeRecordIds() throws ServiceException,
			ServiceDaoException {
		Integer count =  0;
		try {
			count = dao.count("getIncomeRecordIdsAll",new Object[] {});
		} catch (DaoException e) {
			log.error(" count by getIncomeRecordIds " ) ;
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" count  : " + count);
		}
		return count;
	}

}

