/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.keeper.common.util.cft;

import com.ptteng.keeper.common.util.cft.IRequestService;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HttpsPostRequest
extends IRequestService {
    private static final Log log = LogFactory.getLog(HttpsPostRequest.class);
    private static final int BUFFER_SIZE = 2048;

    @Override
    public Object sendPost(String url, Map<String, String> params) throws KeyManagementException, NoSuchAlgorithmException, IOException {
        log.info((Object)(" sendPost url =  " + url + " params = " + params));
        StringBuffer paramstr = new StringBuffer();
        for (Map.Entry<String, String> entry : params.entrySet()) {
            paramstr.append(entry.getKey()).append("=").append(URLEncoder.encode(entry.getValue(), "UTF-8")).append("&");
        }
        String param = paramstr.toString();
        log.info((Object)(" param = " + param));
        return this.sendPost(url, param.substring(0, param.length() - 1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object sendPost(String url, String params) throws IOException, KeyManagementException, NoSuchAlgorithmException {
        log.info((Object)("  sendPost url =" + url + " params = " + params));
        URL connurl = new URL(url);
        HttpURLConnection conn = null;
        Object ret = null;
        OutputStream outStream = null;
        InputStream inStream = null;
        try {
            conn = (HttpURLConnection)connurl.openConnection();
            conn.setRequestMethod("POST");
            conn.setDoOutput(true);
            outStream = conn.getOutputStream();
            outStream.write(params.getBytes("UTF-8"));
            outStream.flush();
            log.info((Object)"  1212   ");
            inStream = conn.getInputStream();
            byte[] bin = HttpsPostRequest.readInputStream(inStream);
            ret = "application/octet-stream".equals(conn.getContentType()) ? bin : (Object)new String(bin, "UTF-8");
        }
        finally {
            if (inStream != null) {
                inStream.close();
            }
            if (outStream != null) {
                outStream.close();
            }
            if (conn != null) {
                conn.disconnect();
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] readInputStream(InputStream inStream) throws IOException {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        byte[] data = null;
        byte[] buffer = new byte[2048];
        int len = 0;
        try {
            while ((len = inStream.read(buffer)) != -1) {
                outStream.write(buffer, 0, len);
            }
            data = outStream.toByteArray();
        }
        finally {
            if (outStream != null) {
                outStream.close();
            }
        }
        return data;
    }

    private static void ignoreSSLVerify(HttpsURLConnection conn) throws NoSuchAlgorithmException, KeyManagementException {
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        SSLContext sc = SSLContext.getInstance("SSL");
        sc.init(null, trustAllCerts, new SecureRandom());
        conn.setSSLSocketFactory(sc.getSocketFactory());
        conn.setHostnameVerifier(new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession session) {
                return true;
            }
        });
    }
}

