/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.keeper.common.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.keeper.common.model.Product;
import com.ptteng.keeper.common.service.ProductService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ProductServiceImpl
extends BaseDaoServiceImpl
implements ProductService {
    private static final Log log = LogFactory.getLog(ProductServiceImpl.class);

    public Long insert(Product product) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + product));
        if (product == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        product.setCreateAt(Long.valueOf(currentTimeMillis));
        product.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)product);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + product));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<Product> insertList(List<Product> productList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (productList == null ? "null" : Integer.valueOf(productList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(productList)) {
            return new ArrayList<Product>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Product product : productList) {
            product.setCreateAt(Long.valueOf(currentTimeMillis));
            product.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(productList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + productList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(Product.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(Product product) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (product == null ? "null" : product.getId())));
        boolean result = false;
        if (product == null) {
            return true;
        }
        product.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)product);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + product));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + product));
        }
        return result;
    }

    public boolean updateList(List<Product> productList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (productList == null ? "null" : Integer.valueOf(productList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(productList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Product product : productList) {
            product.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(productList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + productList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + productList.size()));
        return result;
    }

    public Product getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        Product product = null;
        if (id == null) {
            return product;
        }
        try {
            product = (Product)this.dao.get(Product.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return product;
    }

    public List<Product> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List product = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<Product>();
        }
        try {
            product = this.dao.getList(Product.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (product == null ? "null" : Integer.valueOf(product.size()))));
        return product;
    }

    public List<Long> getProductIdsByBelongModuleOrderByStatusChangeAt(Integer belongModule, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by belongModule,start,limit  : " + belongModule + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getProductIdsByBelongModuleOrderByStatusChangeAt", new Object[]{belongModule}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by belongModule,start,limit)  : " + belongModule + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public List<Long> getProductIdsByStatusAndTypeOrderByStatusChangeAt(Integer status, Integer type, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by status,type,start,limit  : " + status + "," + type + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getProductIdsByStatusAndTypeOrderByStatusChangeAt", new Object[]{status, type}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by status,type,start,limit)  : " + status + " , " + type + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countProductIdsByBelongModuleOrderByStatusChangeAt(Integer belongModule) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by belongModule  : " + belongModule));
        }
        Integer count = null;
        try {
            count = this.dao.count("getProductIdsByBelongModuleOrderByStatusChangeAt", new Object[]{belongModule});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by belongModule)  : " + belongModule));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public Integer countProductIdsByStatusOrderByStatusChangeAt(Integer status) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by status  : " + status));
        }
        Integer count = null;
        try {
            count = this.dao.count("getProductIdsByStatusOrderByStatusChangeAt", new Object[]{status});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by status)  : " + status));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public List<Long> getProductIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getProductIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countProductIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getProductIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getProductIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }
}

