package com.ptteng.keeper.common.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.keeper.common.model.CopartnerRelation;
import com.ptteng.keeper.common.service.CopartnerRelationService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.ArrayList;
import java.util.List;


public class CopartnerRelationServiceImpl extends BaseDaoServiceImpl implements CopartnerRelationService {

 

	private static final Log log = LogFactory.getLog(CopartnerRelationServiceImpl.class);



		   
		@Override
		public Long insert(CopartnerRelation copartnerRelation)throws ServiceException, ServiceDaoException{
		
	
		          
    log.info(" insert data : " + copartnerRelation);

		if (copartnerRelation == null) {
			return null;
		}

		long currentTimeMillis = System.currentTimeMillis();
		copartnerRelation.setCreateAt(currentTimeMillis);
		copartnerRelation.setUpdateAt(currentTimeMillis);

		Long result = null;
		try {
			result = (Long) dao.save(copartnerRelation);
		} catch (DaoException e) {
			log.error(" insert wrong : " + copartnerRelation);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert data success : " + result);
    
return result;	
		}	
		  
    	   
		@Override
		public List<CopartnerRelation> insertList(List<CopartnerRelation> copartnerRelationList)throws ServiceException, ServiceDaoException{
		
	
		          	
        log.info(" insert lists : " + (copartnerRelationList == null ? "null" : copartnerRelationList.size()));
      
		List<CopartnerRelation> resultList = null;

		if (CollectionUtils.isEmpty(copartnerRelationList)) {
			return new ArrayList<CopartnerRelation>();
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (CopartnerRelation copartnerRelation : copartnerRelationList) {
			copartnerRelation.setCreateAt(currentTimeMillis);
			copartnerRelation.setUpdateAt(currentTimeMillis);
		}

		try {
			resultList = (List<CopartnerRelation>) dao.batchSave(copartnerRelationList);
		} catch (DaoException e) {
			log.error(" insert list wrong : " + copartnerRelationList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));
    
		return resultList;
		
		
			
		}

	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	@Override
	public List<Long>  getCopartnerRelationIdsBySubUid(Long subUid,Integer start,Integer limit)throws ServiceException, ServiceDaoException{

		if(log.isInfoEnabled()){
			log.info(" get ids by subUid,start,limit  : " + subUid+" , "+start+" , "+limit );
		}
		List<Long> idList = null;

		// TODO 参数检查!

		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}

		try {
			idList = dao.getIdList("getCopartnerRelationIdsBySubUid", new Object[] { subUid},start,limit, false);


		} catch (DaoException e) {
			log.error(" get ids  wrong by subUid,start,limit)  : " + subUid+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if(log.isInfoEnabled()){
			log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
		}
		return idList;



	}



	@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
	
		            
	    log.info(" delete data : " + id);
 
		boolean result = false;

		if (id == null) {
			return true;
		}

		try {
			result = dao.delete(CopartnerRelation.class, id);
		} catch (DaoException e) {
			log.error(" delete wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
 
		log.info(" delete data success : " + id);
   
		return result;
		
		}	
		  
    	   
		@Override
		public boolean update(CopartnerRelation copartnerRelation)throws ServiceException, ServiceDaoException{
		
	
		          
	log.info(" update data : " + (copartnerRelation == null ? "null" : copartnerRelation.getId()));

		boolean result = false;

		if (copartnerRelation == null) {
			return true;
		}

		copartnerRelation.setUpdateAt(System.currentTimeMillis());

		try {
			result = dao.update(copartnerRelation);
		} catch (DaoException e) {
			log.error(" update wrong : " + copartnerRelation);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
       if(log.isInfoEnabled()){
		log.info(" update data success : " + copartnerRelation);
       }
		return result;	
		}	
		  
    	   
		@Override
		public boolean updateList(List<CopartnerRelation> copartnerRelationList)throws ServiceException, ServiceDaoException{
		
	
		          log.info(" update lists : " + (copartnerRelationList == null ? "null" : copartnerRelationList.size()));

		boolean result = false;

		if (CollectionUtils.isEmpty(copartnerRelationList)) {
			return true;
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (CopartnerRelation copartnerRelation : copartnerRelationList) {
			copartnerRelation.setUpdateAt(currentTimeMillis);
		}

		try {
			result = dao.batchUpdate(copartnerRelationList);
		} catch (DaoException e) {
			log.error(" update list wrong : " + copartnerRelationList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" update lists success : " + copartnerRelationList.size());
         
		return result;	
		}	
		  
    	   
		@Override
		public CopartnerRelation getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
	
		              
        log.info(" get data : " + id);
      
		CopartnerRelation copartnerRelation = null;

		if (id == null) {
			return copartnerRelation;
		}

		try {
			copartnerRelation = (CopartnerRelation) dao.get(CopartnerRelation.class, id);
		} catch (DaoException e) {
			log.error(" get wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" get data success : " + id);
      
		return copartnerRelation;		
		}	
		  
    	   
		@Override
		public List<CopartnerRelation> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
	
		          	  
	    log.info(" get lists : " + (ids == null ? "null" : ids));
     
		List<CopartnerRelation> copartnerRelation = null;

		if (CollectionUtils.isEmpty(ids)) {
			return new ArrayList<CopartnerRelation>();
		}

		try {
			copartnerRelation = (List<CopartnerRelation>) dao.getList(CopartnerRelation.class, ids);
		} catch (DaoException e) {
			log.error(" get wrong : " + ids);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" get data success : " + (copartnerRelation == null ? "null" : copartnerRelation.size()));
    
		return copartnerRelation;	
		}	
		  
    	
		
	
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getCopartnerRelationIdsByUidOrderByCreateAt(Long uid,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" get ids by uid,start,limit  : " + uid+" , "+start+" , "+limit );
	  }
	 	List<Long> idList = null;
        
        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

	try {
		idList = dao.getIdList("getCopartnerRelationIdsByUidOrderByCreateAt", new Object[] { uid},start,limit, false);

   
   } catch (DaoException e) {
			log.error(" get ids  wrong by uid,start,limit)  : " + uid+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
   log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
  }
		return idList;
		
	
	
	}

	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	@Override
	public List<Long>  getCopartnerRelationIdsByUidAndLevel(Long uid,Integer level,Integer start,Integer limit)throws ServiceException, ServiceDaoException{

		if(log.isInfoEnabled()){
			log.info(" get ids by uid,level,start,limit  : " + uid+" , "+level+" , "+start+" , "+limit );
		}
		List<Long> idList = null;

		// TODO 参数检查!

		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}

		try {
			idList = dao.getIdList("getCopartnerRelationIdsByUidAndLevel", new Object[] { uid,level},start,limit, false);


		} catch (DaoException e) {
			log.error(" get ids  wrong by uid,level,start,limit)  : " + uid+" , "+level+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if(log.isInfoEnabled()){
			log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
		}
		return idList;



	}

	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	@Override
	public Long  getCopartnerRelationIdBySubUidAndLevel(Long subUid,Integer level)throws ServiceException, ServiceDaoException{

		if(log.isInfoEnabled()){
			log.info(" get id by subUid,level  : " + subUid+" , "+level );
		}
		Long id = null;

		// TODO 参数检查!

		try {



			id = (Long) dao.getMapping("getCopartnerRelationIdBySubUidAndLevel", new Object[] {subUid,level });
		} catch (DaoException e) {
			log.error(" get id wrong by subUid,level  : " + subUid+" , "+level );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if(log.isInfoEnabled()){
			log.info(" get id success : " + id);
		}
		return id;





	}




	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Long  getCopartnerRelationIdBySubUid(Long subUid)throws ServiceException, ServiceDaoException{
		
		      if(log.isInfoEnabled()){
	  log.info(" get id by subUid  : " + subUid );
	  }
	  Long id = null;
	
      // TODO 参数检查!
      
	try {
		
	
	
        id = (Long) dao.getMapping("getCopartnerRelationIdBySubUid", new Object[] {subUid });
   } catch (DaoException e) {
			log.error(" get id wrong by subUid  : " + subUid );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
   log.info(" get id success : " + id);
   }
		return id;
        
	
	
	
	
	}
	
		
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countCopartnerRelationIdsByUidOrderByCreateAt(Long uid)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" count ids by uid  : " + uid );
	  }
	 	Integer count=null;
        
       

	try {
	   
		count = dao.count("getCopartnerRelationIdsByUidOrderByCreateAt", new Object[] { uid});

   
   } catch (DaoException e) {
			log.error(" count ids  wrong by uid)  : " + uid );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
    log.info(" count  success : " + count);
  }
		return count;
		
	
	
	}
	
		
	
	
	
		
	@Override
	public List<Long> getCopartnerRelationIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		
		log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
		List<Long> idList = null;
		
		
		
		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}
		
		try {
			idList = dao.getIdList("getCopartnerRelationIdsAll",new Object[] {},start, limit, false);
		} catch (DaoException e) {
			log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
		}
		return idList;
	}
	
	
		@Override
	public Integer countCopartnerRelationIds() throws ServiceException,
			ServiceDaoException {
		Integer count =  0;
		try {
			count = dao.count("getCopartnerRelationIdsAll",new Object[] {});
		} catch (DaoException e) {
			log.error(" count by getCopartnerRelationIds " ) ;
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" count  : " + count);
		}
		return count;
	}

}

