/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.keeper.common.bean.yl.sdk;

import com.ptteng.keeper.common.bean.yl.sdk.LogUtil;
import com.ptteng.keeper.common.bean.yl.sdk.SDKConfig;
import com.ptteng.keeper.common.bean.yl.sdk.SDKUtil;
import com.ptteng.keeper.common.bean.yl.sdk.SecureUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.RSAPublicKeySpec;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class CertUtil {
    private static KeyStore keyStore = null;
    private static X509Certificate encryptCert = null;
    private static PublicKey encryptTrackKey = null;
    private static X509Certificate validateCert = null;
    private static Map<String, X509Certificate> certMap = new HashMap<String, X509Certificate>();
    private static final ThreadLocal<KeyStore> certKeyStoreLocal = new ThreadLocal();
    private static final Map<String, KeyStore> certKeyStoreMap = new ConcurrentHashMap<String, KeyStore>();

    public static void init() {
        if ("true".equals(SDKConfig.getConfig().getSingleMode())) {
            CertUtil.initSignCert();
        }
        CertUtil.initEncryptCert();
        CertUtil.initTrackKey();
        CertUtil.initValidateCertFromDir();
    }

    public static void initSignCert() {
        if (null != keyStore) {
            keyStore = null;
        }
        try {
            keyStore = CertUtil.getKeyInfo(SDKConfig.getConfig().getSignCertPath(), SDKConfig.getConfig().getSignCertPwd(), SDKConfig.getConfig().getSignCertType());
            LogUtil.writeLog("InitSignCert Successful. CertId=[" + CertUtil.getSignCertId() + "]");
        }
        catch (IOException e) {
            LogUtil.writeErrorLog("InitSignCert Error", e);
        }
    }

    public static void initSignCert(String certFilePath, String certPwd) {
        LogUtil.writeLog("\u52a0\u8f7d\u8bc1\u4e66\u6587\u4ef6[" + certFilePath + "]\u548c\u8bc1\u4e66\u5bc6\u7801[" + certPwd + "]\u7684\u7b7e\u540d\u8bc1\u4e66\u5f00\u59cb.");
        certKeyStoreLocal.remove();
        File files = new File(certFilePath);
        if (!files.exists()) {
            LogUtil.writeLog("\u8bc1\u4e66\u6587\u4ef6\u4e0d\u5b58\u5728,\u521d\u59cb\u5316\u7b7e\u540d\u8bc1\u4e66\u5931\u8d25.");
            return;
        }
        try {
            certKeyStoreLocal.set(CertUtil.getKeyInfo(certFilePath, certPwd, "PKCS12"));
        }
        catch (IOException e) {
            LogUtil.writeErrorLog("\u52a0\u8f7d\u7b7e\u540d\u8bc1\u4e66\u5931\u8d25", e);
        }
        LogUtil.writeLog("\u52a0\u8f7d\u8bc1\u4e66\u6587\u4ef6[" + certFilePath + "]\u548c\u8bc1\u4e66\u5bc6\u7801[" + certPwd + "]\u7684\u7b7e\u540d\u8bc1\u4e66\u7ed3\u675f.");
    }

    public static void loadRsaCert(String certFilePath, String certPwd) {
        KeyStore keyStore = null;
        try {
            keyStore = CertUtil.getKeyInfo(certFilePath, certPwd, "PKCS12");
            certKeyStoreMap.put(certFilePath, keyStore);
            LogUtil.writeLog("LoadRsaCert Successful");
        }
        catch (IOException e) {
            LogUtil.writeErrorLog("LoadRsaCert Error", e);
        }
    }

    private static void initEncryptCert() {
        LogUtil.writeLog("\u52a0\u8f7d\u654f\u611f\u4fe1\u606f\u52a0\u5bc6\u8bc1\u4e66==>" + SDKConfig.getConfig().getEncryptCertPath());
        if (!SDKUtil.isEmpty(SDKConfig.getConfig().getEncryptCertPath())) {
            encryptCert = CertUtil.initCert(SDKConfig.getConfig().getEncryptCertPath());
            LogUtil.writeLog("LoadEncryptCert Successful");
        } else {
            LogUtil.writeLog("WARN: acpsdk.encryptCert.path is empty");
        }
    }

    private static void initTrackKey() {
        if (!SDKUtil.isEmpty(SDKConfig.getConfig().getEncryptTrackKeyModulus()) && !SDKUtil.isEmpty(SDKConfig.getConfig().getEncryptTrackKeyExponent())) {
            encryptTrackKey = SecureUtil.getPublicKey(SDKConfig.getConfig().getEncryptTrackKeyModulus(), SDKConfig.getConfig().getEncryptTrackKeyExponent());
            LogUtil.writeLog("LoadEncryptTrackKey Successful");
        } else {
            LogUtil.writeLog("WARN: acpsdk.encryptTrackKey.modulus or acpsdk.encryptTrackKey.exponent is empty");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static X509Certificate initCert(String path) {
        X509Certificate encryptCertTemp = null;
        CertificateFactory cf = null;
        FileInputStream in = null;
        try {
            cf = CertificateFactory.getInstance("X.509");
            in = new FileInputStream(path);
            encryptCertTemp = (X509Certificate)cf.generateCertificate(in);
            LogUtil.writeLog("[" + path + "][CertId=" + encryptCertTemp.getSerialNumber().toString() + "]");
        }
        catch (CertificateException e) {
            LogUtil.writeErrorLog("InitCert Error", e);
        }
        catch (FileNotFoundException e) {
            LogUtil.writeErrorLog("InitCert Error File Not Found", e);
        }
        finally {
            if (null != in) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    LogUtil.writeErrorLog(e.toString());
                }
            }
        }
        return encryptCertTemp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initValidateCertFromDir() {
        certMap.clear();
        String dir = SDKConfig.getConfig().getValidateCertDir();
        LogUtil.writeLog("\u52a0\u8f7d\u9a8c\u8bc1\u7b7e\u540d\u8bc1\u4e66\u76ee\u5f55==>" + dir);
        if (SDKUtil.isEmpty(dir)) {
            LogUtil.writeLog("ERROR: acpsdk.validateCert.dir is empty");
            return;
        }
        CertificateFactory cf = null;
        FileInputStream in = null;
        try {
            cf = CertificateFactory.getInstance("X.509");
            File fileDir = new File(dir);
            File[] files = fileDir.listFiles(new CerFilter());
            for (int i = 0; i < files.length; ++i) {
                File file = files[i];
                in = new FileInputStream(file.getAbsolutePath());
                validateCert = (X509Certificate)cf.generateCertificate(in);
                certMap.put(validateCert.getSerialNumber().toString(), validateCert);
                LogUtil.writeLog("[" + file.getAbsolutePath() + "][CertId=" + validateCert.getSerialNumber().toString() + "]");
            }
            LogUtil.writeLog("LoadVerifyCert Successful");
        }
        catch (CertificateException e) {
            LogUtil.writeErrorLog("LoadVerifyCert Error", e);
        }
        catch (FileNotFoundException e) {
            LogUtil.writeErrorLog("LoadVerifyCert Error File Not Found", e);
        }
        finally {
            if (null != in) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    LogUtil.writeErrorLog(e.toString());
                }
            }
        }
    }

    public static PrivateKey getSignCertPrivateKey() {
        try {
            Enumeration<String> aliasenum = keyStore.aliases();
            String keyAlias = null;
            if (aliasenum.hasMoreElements()) {
                keyAlias = aliasenum.nextElement();
            }
            PrivateKey privateKey = (PrivateKey)keyStore.getKey(keyAlias, SDKConfig.getConfig().getSignCertPwd().toCharArray());
            return privateKey;
        }
        catch (KeyStoreException e) {
            LogUtil.writeErrorLog("getSignCertPrivateKey Error", e);
            return null;
        }
        catch (UnrecoverableKeyException e) {
            LogUtil.writeErrorLog("getSignCertPrivateKey Error", e);
            return null;
        }
        catch (NoSuchAlgorithmException e) {
            LogUtil.writeErrorLog("getSignCertPrivateKey Error", e);
            return null;
        }
    }

    public static PrivateKey getSignCertPrivateKeyByThreadLocal(String certPath, String certPwd) {
        if (null == certKeyStoreLocal.get()) {
            CertUtil.initSignCert(certPath, certPwd);
        }
        try {
            Enumeration<String> aliasenum = certKeyStoreLocal.get().aliases();
            String keyAlias = null;
            if (aliasenum.hasMoreElements()) {
                keyAlias = aliasenum.nextElement();
            }
            PrivateKey privateKey = (PrivateKey)certKeyStoreLocal.get().getKey(keyAlias, certPwd.toCharArray());
            return privateKey;
        }
        catch (Exception e) {
            LogUtil.writeErrorLog("\u83b7\u53d6[" + certPath + "]\u7684\u7b7e\u540d\u8bc1\u4e66\u7684\u79c1\u94a5\u5931\u8d25", e);
            return null;
        }
    }

    public static PrivateKey getSignCertPrivateKeyByStoreMap(String certPath, String certPwd) {
        if (!certKeyStoreMap.containsKey(certPath)) {
            CertUtil.loadRsaCert(certPath, certPwd);
        }
        try {
            Enumeration<String> aliasenum = certKeyStoreMap.get(certPath).aliases();
            String keyAlias = null;
            if (aliasenum.hasMoreElements()) {
                keyAlias = aliasenum.nextElement();
            }
            PrivateKey privateKey = (PrivateKey)certKeyStoreMap.get(certPath).getKey(keyAlias, certPwd.toCharArray());
            return privateKey;
        }
        catch (KeyStoreException e) {
            LogUtil.writeErrorLog("getSignCertPrivateKeyByStoreMap Error", e);
            return null;
        }
        catch (UnrecoverableKeyException e) {
            LogUtil.writeErrorLog("getSignCertPrivateKeyByStoreMap Error", e);
            return null;
        }
        catch (NoSuchAlgorithmException e) {
            LogUtil.writeErrorLog("getSignCertPrivateKeyByStoreMap Error", e);
            return null;
        }
    }

    public static PublicKey getEncryptCertPublicKey() {
        if (null == encryptCert) {
            String path = SDKConfig.getConfig().getEncryptCertPath();
            if (!SDKUtil.isEmpty(path)) {
                encryptCert = CertUtil.initCert(path);
                return encryptCert.getPublicKey();
            }
            LogUtil.writeLog("ERROR: acpsdk.encryptCert.path is empty");
            return null;
        }
        return encryptCert.getPublicKey();
    }

    public static PublicKey getEncryptTrackPublicKey() {
        if (null == encryptTrackKey) {
            CertUtil.initTrackKey();
        }
        return encryptTrackKey;
    }

    public static PublicKey getValidateKey() {
        if (null == validateCert) {
            return null;
        }
        return validateCert.getPublicKey();
    }

    public static PublicKey getValidateKey(String certId) {
        X509Certificate cf = null;
        if (certMap.containsKey(certId)) {
            cf = certMap.get(certId);
            return cf.getPublicKey();
        }
        CertUtil.initValidateCertFromDir();
        if (certMap.containsKey(certId)) {
            cf = certMap.get(certId);
            return cf.getPublicKey();
        }
        LogUtil.writeErrorLog("\u7f3a\u5c11certId=[" + certId + "]\u5bf9\u5e94\u7684\u9a8c\u7b7e\u8bc1\u4e66.");
        return null;
    }

    public static String getSignCertId() {
        try {
            Enumeration<String> aliasenum = keyStore.aliases();
            String keyAlias = null;
            if (aliasenum.hasMoreElements()) {
                keyAlias = aliasenum.nextElement();
            }
            X509Certificate cert = (X509Certificate)keyStore.getCertificate(keyAlias);
            return cert.getSerialNumber().toString();
        }
        catch (Exception e) {
            LogUtil.writeErrorLog("getSignCertId Error", e);
            return null;
        }
    }

    public static String getEncryptCertId() {
        if (null == encryptCert) {
            String path = SDKConfig.getConfig().getEncryptCertPath();
            if (!SDKUtil.isEmpty(path)) {
                encryptCert = CertUtil.initCert(path);
                return encryptCert.getSerialNumber().toString();
            }
            LogUtil.writeLog("ERROR: acpsdk.encryptCert.path is empty");
            return null;
        }
        return encryptCert.getSerialNumber().toString();
    }

    public static String getEncryptTrackCertId() {
        return "";
    }

    public static PublicKey getSignPublicKey() {
        try {
            Enumeration<String> aliasenum = keyStore.aliases();
            String keyAlias = null;
            if (aliasenum.hasMoreElements()) {
                keyAlias = aliasenum.nextElement();
            }
            Certificate cert = keyStore.getCertificate(keyAlias);
            PublicKey pubkey = cert.getPublicKey();
            return pubkey;
        }
        catch (Exception e) {
            LogUtil.writeErrorLog(e.toString());
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KeyStore getKeyInfo(String pfxkeyfile, String keypwd, String type) throws IOException {
        LogUtil.writeLog("\u52a0\u8f7d\u7b7e\u540d\u8bc1\u4e66==>" + pfxkeyfile);
        FileInputStream fis = null;
        try {
            KeyStore ks = null;
            if ("JKS".equals(type)) {
                ks = KeyStore.getInstance(type);
            } else if ("PKCS12".equals(type)) {
                String jdkVendor = System.getProperty("java.vm.vendor");
                String javaVersion = System.getProperty("java.version");
                LogUtil.writeLog("java.vm.vendor=[" + jdkVendor + "]");
                LogUtil.writeLog("java.version=[" + javaVersion + "]");
                if (null != jdkVendor && jdkVendor.startsWith("IBM")) {
                    Security.insertProviderAt((Provider)new BouncyCastleProvider(), 1);
                    CertUtil.printSysInfo();
                } else {
                    Security.addProvider((Provider)new BouncyCastleProvider());
                }
                ks = KeyStore.getInstance(type);
            }
            LogUtil.writeLog("Load RSA CertPath=[" + pfxkeyfile + "],Pwd=[" + keypwd + "]");
            fis = new FileInputStream(pfxkeyfile);
            char[] nPassword = null;
            char[] cArray = nPassword = null == keypwd || "".equals(keypwd.trim()) ? null : keypwd.toCharArray();
            if (null != ks) {
                ks.load(fis, nPassword);
            }
            KeyStore keyStore = ks;
            return keyStore;
        }
        catch (Exception e) {
            if (Security.getProvider("BC") == null) {
                LogUtil.writeLog("BC Provider not installed.");
            }
            LogUtil.writeErrorLog("getKeyInfo Error", e);
            if (e instanceof KeyStoreException && "PKCS12".equals(type)) {
                Security.removeProvider("BC");
            }
            KeyStore keyStore = null;
            return keyStore;
        }
        finally {
            if (null != fis) {
                fis.close();
            }
        }
    }

    public static void printSysInfo() {
        LogUtil.writeLog("================= SYS INFO begin====================");
        LogUtil.writeLog("os_name:" + System.getProperty("os.name"));
        LogUtil.writeLog("os_arch:" + System.getProperty("os.arch"));
        LogUtil.writeLog("os_version:" + System.getProperty("os.version"));
        LogUtil.writeLog("java_vm_specification_version:" + System.getProperty("java.vm.specification.version"));
        LogUtil.writeLog("java_vm_specification_vendor:" + System.getProperty("java.vm.specification.vendor"));
        LogUtil.writeLog("java_vm_specification_name:" + System.getProperty("java.vm.specification.name"));
        LogUtil.writeLog("java_vm_version:" + System.getProperty("java.vm.version"));
        LogUtil.writeLog("java_vm_name:" + System.getProperty("java.vm.name"));
        LogUtil.writeLog("java.version:" + System.getProperty("java.version"));
        CertUtil.printProviders();
        LogUtil.writeLog("================= SYS INFO end=====================");
    }

    public static void printProviders() {
        LogUtil.writeLog("Providers List:");
        Provider[] providers = Security.getProviders();
        for (int i = 0; i < providers.length; ++i) {
            LogUtil.writeLog(i + 1 + "." + providers[i].getName());
        }
    }

    public static String getCertIdByThreadLocal(String certPath, String certPwd) {
        CertUtil.initSignCert(certPath, certPwd);
        try {
            Enumeration<String> aliasenum = certKeyStoreLocal.get().aliases();
            String keyAlias = null;
            if (aliasenum.hasMoreElements()) {
                keyAlias = aliasenum.nextElement();
            }
            X509Certificate cert = (X509Certificate)certKeyStoreLocal.get().getCertificate(keyAlias);
            return cert.getSerialNumber().toString();
        }
        catch (Exception e) {
            LogUtil.writeErrorLog("\u83b7\u53d6\u7b7e\u540d\u8bc1\u4e66\u7684\u5e8f\u5217\u53f7\u5931\u8d25", e);
            return "";
        }
    }

    public static String getCertIdByKeyStoreMap(String certPath, String certPwd) {
        if (!certKeyStoreMap.containsKey(certPath)) {
            CertUtil.loadRsaCert(certPath, certPwd);
        }
        return CertUtil.getCertIdIdByStore(certKeyStoreMap.get(certPath));
    }

    private static String getCertIdIdByStore(KeyStore keyStore) {
        Enumeration<String> aliasenum = null;
        try {
            aliasenum = keyStore.aliases();
            String keyAlias = null;
            if (aliasenum.hasMoreElements()) {
                keyAlias = aliasenum.nextElement();
            }
            X509Certificate cert = (X509Certificate)keyStore.getCertificate(keyAlias);
            return cert.getSerialNumber().toString();
        }
        catch (KeyStoreException e) {
            LogUtil.writeErrorLog("getCertIdIdByStore Error", e);
            return null;
        }
    }

    public static Map<String, X509Certificate> getCertMap() {
        return certMap;
    }

    public static void setCertMap(Map<String, X509Certificate> certMap) {
        CertUtil.certMap = certMap;
    }

    public static PublicKey getPublicKey(String modulus, String exponent) {
        try {
            BigInteger b1 = new BigInteger(modulus);
            BigInteger b2 = new BigInteger(exponent);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            RSAPublicKeySpec keySpec = new RSAPublicKeySpec(b1, b2);
            return keyFactory.generatePublic(keySpec);
        }
        catch (Exception e) {
            LogUtil.writeErrorLog("\u6784\u9020RSA\u516c\u94a5\u5931\u8d25\uff1a" + e);
            return null;
        }
    }

    public static PublicKey getEncryptTrackCertPublicKey(String modulus, String exponent) {
        if (SDKUtil.isEmpty(modulus) || SDKUtil.isEmpty(exponent)) {
            LogUtil.writeErrorLog("[modulus] OR [exponent] invalid");
            return null;
        }
        return CertUtil.getPublicKey(modulus, exponent);
    }

    static {
        CertUtil.init();
    }

    static class CerFilter
    implements FilenameFilter {
        CerFilter() {
        }

        public boolean isCer(String name) {
            return name.toLowerCase().endsWith(".cer");
        }

        @Override
        public boolean accept(File dir, String name) {
            return this.isCer(name);
        }
    }
}

