package com.ptteng.keeper.common.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.keeper.common.model.UserReadRecord;
import com.ptteng.keeper.common.service.UserReadRecordService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.ArrayList;
import java.util.List;


public class UserReadRecordServiceImpl extends BaseDaoServiceImpl implements UserReadRecordService {

 

	private static final Log log = LogFactory.getLog(UserReadRecordServiceImpl.class);



		   
		@Override
		public Long insert(UserReadRecord userReadRecord)throws ServiceException, ServiceDaoException{
		
	
		          
    log.info(" insert data : " + userReadRecord);

		if (userReadRecord == null) {
			return null;
		}

		long currentTimeMillis = System.currentTimeMillis();
		userReadRecord.setCreateAt(currentTimeMillis);
		userReadRecord.setUpdateAt(currentTimeMillis);

		Long result = null;
		try {
			result = (Long) dao.save(userReadRecord);
		} catch (DaoException e) {
			log.error(" insert wrong : " + userReadRecord);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert data success : " + result);
    
return result;	
		}	
		  
    	   
		@Override
		public List<UserReadRecord> insertList(List<UserReadRecord> userReadRecordList)throws ServiceException, ServiceDaoException{
		
	
		          	
        log.info(" insert lists : " + (userReadRecordList == null ? "null" : userReadRecordList.size()));
      
		List<UserReadRecord> resultList = null;

		if (CollectionUtils.isEmpty(userReadRecordList)) {
			return new ArrayList<UserReadRecord>();
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (UserReadRecord userReadRecord : userReadRecordList) {
			userReadRecord.setCreateAt(currentTimeMillis);
			userReadRecord.setUpdateAt(currentTimeMillis);
		}

		try {
			resultList = (List<UserReadRecord>) dao.batchSave(userReadRecordList);
		} catch (DaoException e) {
			log.error(" insert list wrong : " + userReadRecordList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));
    
		return resultList;
		
		
			
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
	
		            
	    log.info(" delete data : " + id);
 
		boolean result = false;

		if (id == null) {
			return true;
		}

		try {
			result = dao.delete(UserReadRecord.class, id);
		} catch (DaoException e) {
			log.error(" delete wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
 
		log.info(" delete data success : " + id);
   
		return result;
		
		}	
		  
    	   
		@Override
		public boolean update(UserReadRecord userReadRecord)throws ServiceException, ServiceDaoException{
		
	
		          
	log.info(" update data : " + (userReadRecord == null ? "null" : userReadRecord.getId()));

		boolean result = false;

		if (userReadRecord == null) {
			return true;
		}

		userReadRecord.setUpdateAt(System.currentTimeMillis());

		try {
			result = dao.update(userReadRecord);
		} catch (DaoException e) {
			log.error(" update wrong : " + userReadRecord);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
       if(log.isInfoEnabled()){
		log.info(" update data success : " + userReadRecord);
       }
		return result;	
		}	
		  
    	   
		@Override
		public boolean updateList(List<UserReadRecord> userReadRecordList)throws ServiceException, ServiceDaoException{
		
	
		          log.info(" update lists : " + (userReadRecordList == null ? "null" : userReadRecordList.size()));

		boolean result = false;

		if (CollectionUtils.isEmpty(userReadRecordList)) {
			return true;
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (UserReadRecord userReadRecord : userReadRecordList) {
			userReadRecord.setUpdateAt(currentTimeMillis);
		}

		try {
			result = dao.batchUpdate(userReadRecordList);
		} catch (DaoException e) {
			log.error(" update list wrong : " + userReadRecordList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" update lists success : " + userReadRecordList.size());
         
		return result;	
		}	
		  
    	   
		@Override
		public UserReadRecord getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
	
		              
        log.info(" get data : " + id);
      
		UserReadRecord userReadRecord = null;

		if (id == null) {
			return userReadRecord;
		}

		try {
			userReadRecord = (UserReadRecord) dao.get(UserReadRecord.class, id);
		} catch (DaoException e) {
			log.error(" get wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" get data success : " + id);
      
		return userReadRecord;		
		}	
		  
    	   
		@Override
		public List<UserReadRecord> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
	
		          	  
	    log.info(" get lists : " + (ids == null ? "null" : ids));
     
		List<UserReadRecord> userReadRecord = null;

		if (CollectionUtils.isEmpty(ids)) {
			return new ArrayList<UserReadRecord>();
		}

		try {
			userReadRecord = (List<UserReadRecord>) dao.getList(UserReadRecord.class, ids);
		} catch (DaoException e) {
			log.error(" get wrong : " + ids);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" get data success : " + (userReadRecord == null ? "null" : userReadRecord.size()));
    
		return userReadRecord;	
		}	
		  
    	
		
	
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Long  getUserReadRecordIdByTargetIdAndUid(Long targetId,Long uid)throws ServiceException, ServiceDaoException{
		
		      if(log.isInfoEnabled()){
	  log.info(" get id by targetId,uid  : " + targetId+" , "+uid );
	  }
	  Long id = null;
	
      // TODO 参数检查!
      
	try {
		
	
	
        id = (Long) dao.getMapping("getUserReadRecordIdByTargetIdAndUid", new Object[] {targetId,uid });
   } catch (DaoException e) {
			log.error(" get id wrong by targetId,uid  : " + targetId+" , "+uid );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
   log.info(" get id success : " + id);
   }
		return id;
        
	
	
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getUserReadRecordIdsByUidAndStatusAndType(Long uid,Integer status,Integer type,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" get ids by uid,status,type,start,limit  : " + uid+" , "+status+" , "+type+" , "+start+" , "+limit );
	  }
	 	List<Long> idList = null;
        
        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

	try {
		idList = dao.getIdList("getUserReadRecordIdsByUidAndStatusAndType", new Object[] { uid,status,type},start,limit, false);

   
   } catch (DaoException e) {
			log.error(" get ids  wrong by uid,status,type,start,limit)  : " + uid+" , "+status+" , "+type+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
   log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
  }
		return idList;
		
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Long  getUserReadRecordIdByTargetIdAndUidAndStatus(Long targetId,Long uid,Integer status)throws ServiceException, ServiceDaoException{
		
		      if(log.isInfoEnabled()){
	  log.info(" get id by targetId,uid,status  : " + targetId+" , "+uid+" , "+status );
	  }
	  Long id = null;
	
      // TODO 参数检查!
      
	try {
		
	
	
        id = (Long) dao.getMapping("getUserReadRecordIdByTargetIdAndUidAndStatus", new Object[] {targetId,uid,status });
   } catch (DaoException e) {
			log.error(" get id wrong by targetId,uid,status  : " + targetId+" , "+uid+" , "+status );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
   log.info(" get id success : " + id);
   }
		return id;
        
	
	
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Long  getUserReadRecordIdByTargetIdAndUidAndType(Long targetId,Long uid,Integer type)throws ServiceException, ServiceDaoException{
		
		      if(log.isInfoEnabled()){
	  log.info(" get id by targetId,uid,type  : " + targetId+" , "+uid+" , "+type );
	  }
	  Long id = null;
	
      // TODO 参数检查!
      
	try {
		
	
	
        id = (Long) dao.getMapping("getUserReadRecordIdByTargetIdAndUidAndType", new Object[] {targetId,uid,type });
   } catch (DaoException e) {
			log.error(" get id wrong by targetId,uid,type  : " + targetId+" , "+uid+" , "+type );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
   log.info(" get id success : " + id);
   }
		return id;
        
	
	
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Long  getUserReadRecordIdByTargetIdAndUidAndStatusAndType(Long targetId,Long uid,Integer status,Integer type)throws ServiceException, ServiceDaoException{
		
		      if(log.isInfoEnabled()){
	  log.info(" get id by targetId,uid,status,type  : " + targetId+" , "+uid+" , "+status+" , "+type );
	  }
	  Long id = null;
	
      // TODO 参数检查!
      
	try {
		
	
	
        id = (Long) dao.getMapping("getUserReadRecordIdByTargetIdAndUidAndStatusAndType", new Object[] {targetId,uid,status,type });
   } catch (DaoException e) {
			log.error(" get id wrong by targetId,uid,status,type  : " + targetId+" , "+uid+" , "+status+" , "+type );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
   log.info(" get id success : " + id);
   }
		return id;
        
	
	
	
	
	}
	
		
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countUserReadRecordIdsByUidAndStatusAndType(Long uid,Integer status,Integer type)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" count ids by uid,status,type  : " + uid+" , "+status+" , "+type );
	  }
	 	Integer count=null;
        
       

	try {
	   
		count = dao.count("getUserReadRecordIdsByUidAndStatusAndType", new Object[] { uid,status,type});

   
   } catch (DaoException e) {
			log.error(" count ids  wrong by uid,status,type)  : " + uid+" , "+status+" , "+type );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
    log.info(" count  success : " + count);
  }
		return count;
		
	
	
	}
	
		
	
	
	
		
	@Override
	public List<Long> getUserReadRecordIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		
		log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
		List<Long> idList = null;
		
		
		
		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}
		
		try {
			idList = dao.getIdList("getUserReadRecordIdsAll",new Object[] {},start, limit, false);
		} catch (DaoException e) {
			log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
		}
		return idList;
	}
	
	
		@Override
	public Integer countUserReadRecordIds() throws ServiceException,
			ServiceDaoException {
		Integer count =  0;
		try {
			count = dao.count("getUserReadRecordIdsAll",new Object[] {});
		} catch (DaoException e) {
			log.error(" count by getUserReadRecordIds " ) ;
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" count  : " + count);
		}
		return count;
	}

}

