package com.ptteng.keeper.common.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.keeper.common.model.UserAsset;
import com.ptteng.keeper.common.service.UserAssetService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.ArrayList;
import java.util.List;


public class UserAssetServiceImpl extends BaseDaoServiceImpl implements UserAssetService {

 

	private static final Log log = LogFactory.getLog(UserAssetServiceImpl.class);



		   
		@Override
		public Long insert(UserAsset userAsset)throws ServiceException, ServiceDaoException{
		
	
		          
    log.info(" insert data : " + userAsset);

		if (userAsset == null) {
			return null;
		}

		long currentTimeMillis = System.currentTimeMillis();
		userAsset.setCreateAt(currentTimeMillis);
		userAsset.setUpdateAt(currentTimeMillis);

		Long result = null;
		try {
			result = (Long) dao.save(userAsset);
		} catch (DaoException e) {
			log.error(" insert wrong : " + userAsset);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert data success : " + result);
    
return result;	
		}	
		  
    	   
		@Override
		public List<UserAsset> insertList(List<UserAsset> userAssetList)throws ServiceException, ServiceDaoException{
		
	
		          	
        log.info(" insert lists : " + (userAssetList == null ? "null" : userAssetList.size()));
      
		List<UserAsset> resultList = null;

		if (CollectionUtils.isEmpty(userAssetList)) {
			return new ArrayList<UserAsset>();
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (UserAsset userAsset : userAssetList) {
			userAsset.setCreateAt(currentTimeMillis);
			userAsset.setUpdateAt(currentTimeMillis);
		}

		try {
			resultList = (List<UserAsset>) dao.batchSave(userAssetList);
		} catch (DaoException e) {
			log.error(" insert list wrong : " + userAssetList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));
    
		return resultList;
		
		
			
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
	
		            
	    log.info(" delete data : " + id);
 
		boolean result = false;

		if (id == null) {
			return true;
		}

		try {
			result = dao.delete(UserAsset.class, id);
		} catch (DaoException e) {
			log.error(" delete wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
 
		log.info(" delete data success : " + id);
   
		return result;
		
		}	
		  
    	   
		@Override
		public boolean update(UserAsset userAsset)throws ServiceException, ServiceDaoException{
		
	
		          
	log.info(" update data : " + (userAsset == null ? "null" : userAsset.getId()));

		boolean result = false;

		if (userAsset == null) {
			return true;
		}

		userAsset.setUpdateAt(System.currentTimeMillis());

		try {
			result = dao.update(userAsset);
		} catch (DaoException e) {
			log.error(" update wrong : " + userAsset);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
       if(log.isInfoEnabled()){
		log.info(" update data success : " + userAsset);
       }
		return result;	
		}	
		  
    	   
		@Override
		public boolean updateList(List<UserAsset> userAssetList)throws ServiceException, ServiceDaoException{
		
	
		          log.info(" update lists : " + (userAssetList == null ? "null" : userAssetList.size()));

		boolean result = false;

		if (CollectionUtils.isEmpty(userAssetList)) {
			return true;
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (UserAsset userAsset : userAssetList) {
			userAsset.setUpdateAt(currentTimeMillis);
		}

		try {
			result = dao.batchUpdate(userAssetList);
		} catch (DaoException e) {
			log.error(" update list wrong : " + userAssetList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" update lists success : " + userAssetList.size());
         
		return result;	
		}	
		  
    	   
		@Override
		public UserAsset getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
	
		              
        log.info(" get data : " + id);
      
		UserAsset userAsset = null;

		if (id == null) {
			return userAsset;
		}

		try {
			userAsset = (UserAsset) dao.get(UserAsset.class, id);
		} catch (DaoException e) {
			log.error(" get wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" get data success : " + id);
      
		return userAsset;		
		}	
		  
    	   
		@Override
		public List<UserAsset> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
	
		          	  
	    log.info(" get lists : " + (ids == null ? "null" : ids));
     
		List<UserAsset> userAsset = null;

		if (CollectionUtils.isEmpty(ids)) {
			return new ArrayList<UserAsset>();
		}

		try {
			userAsset = (List<UserAsset>) dao.getList(UserAsset.class, ids);
		} catch (DaoException e) {
			log.error(" get wrong : " + ids);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" get data success : " + (userAsset == null ? "null" : userAsset.size()));
    
		return userAsset;	
		}	
		  
    	
		
	
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Long  getUserAssetIdByUid(Long uid)throws ServiceException, ServiceDaoException{

		 if(log.isInfoEnabled()){
			 log.info(" get id by uid  : " + uid );
		 }
		 Long id = null;

		 // TODO 参数检查!

		 try {



			 id = (Long) dao.getMapping("getUserAssetIdByUid", new Object[] {uid });
		 } catch (DaoException e) {
			 log.error(" get id wrong by uid  : " + uid );
			 log.error(e);
			 e.printStackTrace();
			 throw new ServiceDaoException(e);
		 }
		 if(log.isInfoEnabled()){
			 log.info(" get id success : " + id);
		 }
		 return id;




	 }
	
		
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countUserAssetIdsByUidOrderByCreateAt(Long uid)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" count ids by uid  : " + uid );
	  }
	 	Integer count=null;
        
       

	try {
	   
		count = dao.count("getUserAssetIdsByUidOrderByCreateAt", new Object[] { uid});

   
   } catch (DaoException e) {
			log.error(" count ids  wrong by uid)  : " + uid );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
    log.info(" count  success : " + count);
  }
		return count;
		
	
	
	}
	
		
	
	
	
		
	@Override
	public List<Long> getUserAssetIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		
		log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
		List<Long> idList = null;
		
		
		
		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}
		
		try {
			idList = dao.getIdList("getUserAssetIdsAll",new Object[] {},start, limit, false);
		} catch (DaoException e) {
			log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
		}
		return idList;
	}
	
	
		@Override
	public Integer countUserAssetIds() throws ServiceException,
			ServiceDaoException {
		Integer count =  0;
		try {
			count = dao.count("getUserAssetIdsAll",new Object[] {});
		} catch (DaoException e) {
			log.error(" count by getUserAssetIds " ) ;
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" count  : " + count);
		}
		return count;
	}

}

