package com.ptteng.keeper.admin.controller;

import com.ptteng.keeper.admin.model.Manager;
import com.ptteng.keeper.admin.model.Role;
import com.ptteng.keeper.admin.model.RoleModule;
import com.ptteng.keeper.admin.service.ManagerService;
import com.ptteng.keeper.admin.service.ModuleService;
import com.ptteng.keeper.admin.service.RoleModuleService;
import com.ptteng.keeper.admin.service.RoleService;
import com.qding.common.util.http.cookie.CookieUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * Role  crud
 *
 * @author magenm
 * @Date 2014-4-16 13:43
 */
@Controller
public class RoleController {
    private static final Log log = LogFactory.getLog(RoleController.class);

    @Autowired
    private RoleService roleService;
    @Autowired
    private ManagerService managerService;

    @Autowired
    private RoleModuleService roleModuleService;

    @Autowired
    private ModuleService moduleService;

    @Autowired
    private CookieUtil cookieUtil;


    //10.返回单个角色及权限
    @RequestMapping(value = "/a/u/role/{rid}/module", method = RequestMethod.GET)
    public String getRoleModule(HttpServletRequest request, HttpServletResponse response, ModelMap model, @PathVariable Long rid) throws Exception {

        log.info("get data : id= " + rid);

        try {
            if (rid == null) {
                model.addAttribute("code", -1004);
                return "/common/success";
            } else {
                if (rid.longValue() == -1L) {
                    String userId = cookieUtil.getKeyIdentity(request, CookieUtil.USER_ID);
                    Manager manager = this.managerService.getObjectById(Long.valueOf(userId));
                    rid = manager.getRoleID();
                }
                Role role = roleService.getObjectById(rid);

                if (role == null) {
                    model.addAttribute("code", -7001);
                    return "/common/success";
                } else {

                    List<Long> roleModuleIds = roleModuleService.getRoleModuleIdsByRid(rid, 0, Integer.MAX_VALUE);
                    List<RoleModule> roleModules = roleModuleService.getObjectsByIds(roleModuleIds);

                    List<Long> moduleIds = new ArrayList<Long>();


                    for (RoleModule rm : roleModules) {
                        moduleIds.add(rm.getMid());

                    }

                    model.addAttribute("code", 0);
                    model.addAttribute("role", role);
                    model.addAttribute("mids", moduleIds);
                }
            }

        } catch (Throwable t) {
            log.error(t.getMessage());
            log.error("get role error,id is  " + rid);
            model.addAttribute("code", -100000);
        }

        return "/common-skill-service/role/json/roleDetailJson";
    }

    //11.查找角色列表
    @RequestMapping(value = "/a/u/role/", method = RequestMethod.GET)
    public String getRoleList(HttpServletRequest request, HttpServletResponse response, ModelMap model, Integer page, Integer size) throws Exception {
        if (page == null) {
            page = 1;
        }
        if (size == null) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }

        log.info("pageList : page= " + start + " , size=" + size);

        try {
            Boolean next = false;
            size += 1;

            List<Long> ids = roleService.getRoleIds(start, size);
            List<Long> idsTotal = roleService.getRoleIds(0, Integer.MAX_VALUE);
            log.info("get role size is " + ids.size());
            Integer total = idsTotal.size();

            if (ids != null && ids.size() > 0) {

                if (size.equals(ids.size())) {
                    next = true;
                    log.info("ss  " + ids.subList(0, size - 1));
                    model.addAttribute("ids", ids.subList(0, size - 1));
                } else {
                    log.info("ss  " + ids.subList(0, ids.size()));
                    model.addAttribute("ids", ids.subList(0, ids.size()));
                }
            } else {
                model.addAttribute("ids", ids);
            }

            log.info("next is " + next);
            model.addAttribute("code", 0);
            model.addAttribute("size", size - 1);
            model.addAttribute("next", next);
            model.addAttribute("page", page);
            model.addAttribute("total", total);
        } catch (Throwable t) {
            log.error(t.getMessage());
            log.error("get role list error,page is  " + start + " , size "
                    + size);
            // for test
            model.addAttribute("code", -100000);
        }

        return "/common-skill-service/role/json/roleListJson";
    }


    /**
     * 增加角色
     *
     * @param request
     * @param response
     * @param model
     * @param role
     * @return
     * @throws Exception
     */
    //12.新增角色
    @RequestMapping(value = "/a/u/role", method = RequestMethod.POST)
    public String addRole(HttpServletRequest request,
                          HttpServletResponse response, ModelMap model, Role role)
            throws Exception {

        log.info("add role : name= " + role.getName() + " role modules " + role.getPermissionsSet());

        try {
            if (role == null) {
                log.info("role  is  null ");
                model.addAttribute("code", -1004);
                return "/common/success";
            }
            if (role.getName() == null || role.getPermissionsSet() == null || role.getName().trim().equals("") ||
                    role.getPermissionsSet().size() <= 0) {
                log.info("role name or permissions is  null ");
                model.addAttribute("code", -1004);
                return "/common/success";
            }

            List<Long> roleIds = roleService.getRoleIdsByName(role.getName(), 0, Integer.MAX_VALUE);
            if (roleIds.size() > 0) {
                log.info(" role name is exit ");
                List<Long> moduleIds = moduleService.getModuleIds(0, Integer.MAX_VALUE);
                model.addAttribute("code", -7003);
                return "/common/success";
            } else {


                //	Role role = new Role();
                //	role.setName(name);
                Long uid = Long.valueOf(cookieUtil.getKeyIdentity(request,
                        CookieUtil.USER_ID));
                role.setCreateBy(uid);
                role.setId(null);
                role.setStatus(Role.STATUS_USING);
                Long roleId = roleService.insert(role);
                List<RoleModule> roleModules = new ArrayList<RoleModule>();

                for (Long moduleId : role.getPermissionsSet()) {

                    if (null != moduleId && !"".equals(moduleId)) {
                        RoleModule roleModule = new RoleModule();
                        roleModule.setCreateBy(uid);
                        roleModule.setUpdateBy(uid);
                        roleModule.setRid(roleId);
                        roleModule.setMid(Long.valueOf(moduleId));
                        roleModules.add(roleModule);
                    }
                }
                roleModuleService.insertList(roleModules);

                model.addAttribute("code", 0);
                model.addAttribute("rid", roleId);
            }
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("add role error ");
            model.addAttribute("code", -100000);
        }

        return "/common-skill-service/role/json/addRole";
    }

    //13.修改角色
    @RequestMapping(value = "/a/u/role/{rid}", method = RequestMethod.PUT)
    public String updateRole(HttpServletRequest request, HttpServletResponse response, ModelMap model, Role role) throws Exception {
        log.info("update role : role= " + role);

        try {

            if (role == null) {
                log.info("role  is  null ");
                model.addAttribute("code", -1004);
                return "/common/success";
            }
            if (role.getName() == null || role.getPermissionsSet() == null || role.getName().trim().equals("") || role.getPermissionsSet().size() <= 0) {
                log.info("role name or permissions is  null ");
                model.addAttribute("code", -1004);
                return "/common/success";
            }
            if (roleService.getObjectById(role.getId()) == null) {
                model.addAttribute("code", -7001);
                return "/common/success";
            }
            List<Long> roleIds = this.roleService.getRoleIdsByName(role.getName(), 0, Integer.MAX_VALUE);
            log.info("manager name " + role.getName());

            if (roleIds != null && roleIds.size() > 0) {
                if (roleIds.size() == 1 && !(roleIds.get(0).equals(role.getId()))) {
                    log.info(" role name is exit ");
                    model.addAttribute("code", -5019);
                    return "/common/success";

                }
            }
            Role r = roleService.getObjectById(role.getId());
            String userId = cookieUtil.getKeyIdentity(request, CookieUtil.USER_ID);
            role.setUpdateBy(Long.valueOf(userId));
            role.setCreateAt(r.getCreateAt());
            role.setCreateBy(r.getCreateBy());
            role.setStatus(Role.STATUS_USING);
            roleService.update(role);
            List<Long> roleModuleIds = roleModuleService.getRoleModuleIdsByRid(role.getId(), 0, Integer.MAX_VALUE);
            if (roleModuleIds != null && roleModuleIds.size() > 0) {
                for (Long roleModuleId : roleModuleIds) {
                    roleModuleService.delete(roleModuleId);
                }
            }
            List<RoleModule> roleModules = new ArrayList<RoleModule>();
            for (Long moduleId : role.getPermissionsSet()) {
                if (moduleId != null && !"".equals(moduleId)) {
                    RoleModule roleModule = new RoleModule();
                    roleModule.setCreateBy(Long.valueOf(userId));
                    roleModule.setUpdateBy(Long.valueOf(userId));
                    roleModule.setRid(role.getId());
                    roleModule.setMid(moduleId);
                    roleModules.add(roleModule);
                }
            }
            roleModuleService.insertList(roleModules);
            model.addAttribute("code", 0);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("update role error,id is  " + role.getId());
            model.addAttribute("code", -100000);
        }
        return "/common-skill-service/role/json/roleDetailJson";
    }



    //14.删除角色
    @RequestMapping(value = "/a/u/role/{rid}", method = RequestMethod.DELETE)
    public String deleteRole(HttpServletRequest request, HttpServletResponse response, ModelMap model, @PathVariable Long rid) throws Exception {
        log.info("delete role : id= " + rid);
        try {
            if (rid == null) {
                model.addAttribute("code", -1004);
                return "/common/success";
            }
            List<Long> managerIds = managerService.getManagerIdsByRoleID(rid, null, null);
            if (managerIds.size() > 0) {
                log.info("manager has this role");
                model.addAttribute("code", -7004);
            } else {
                if (roleService.getObjectById(rid) == null) {
                    model.addAttribute("code", -7001);
                } else {
                    List<Long> roleModuleIds = roleModuleService.getRoleModuleIdsByRid(rid, 0, Integer.MAX_VALUE);
                    log.info(" roleMudleids  is  " + roleModuleIds);
                    if (roleModuleIds != null && roleModuleIds.size() > 0) {
                        for (Long roleModuleId : roleModuleIds) {
                            roleModuleService.delete(roleModuleId);
                        }
                    }
                    roleService.delete(rid);
                    log.info("delete role success");
                    model.addAttribute("code", 0);
                }
            }

        } catch (Throwable t) {
            log.error(t.getMessage());
            log.error("delete role error,id is  " + rid);
            model.addAttribute("code", -100000);

        }

        return "/common/success";
    }


    //15.批量获取角色详细信息
    @RequestMapping(value = "/a/u/multi/role", method = RequestMethod.GET)
    public String getMultiRole(HttpServletRequest request, HttpServletResponse response, ModelMap model, Long[] ids) throws Exception {
        log.info("get role rid " + ids);
        List<Long> idList = new ArrayList();
        if (ids == null || ids.length <= 0) {
            model.addAttribute("code", 0);
            model.addAttribute("size", 10);
            model.addAttribute("total", 0);
        } else {
            idList = Arrays.asList(ids);
        }
        try {
            if (idList == null || idList.size() <= 0) {
                model.addAttribute("code", 0);
                model.addAttribute("size", 10);
                model.addAttribute("total", 0);
            } else {
                List<Role> roleList = roleService.getObjectsByIds(idList);
                log.info("get roleList size is " + roleList.size());

                if (roleList != null && roleList.size() > 0) {
                    model.addAttribute("code", 0);
                    model.addAttribute("size", 10);
                    model.addAttribute("total", roleList.size());
                    model.addAttribute("roleList", roleList);

                } else {
                    model.addAttribute("code", 0);
                    model.addAttribute("size", 10);
                    model.addAttribute("total", 0);
                    model.addAttribute("roleList", roleList);
                }
            }
        } catch (Throwable t) {
            log.error(t.getMessage());
            log.error("get role error,id is  " + Arrays.toString(ids));
            model.addAttribute("code", -100000);
        }

        return "/common-skill-service/role/json/roleMultiJson";
    }

    /**
     * 获取单个角色
     *
     * @param request
     * @param response
     * @param model
     * @param rid
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/role/{rid}", method = RequestMethod.GET)
    public String getRoleJson(HttpServletRequest request,
                              HttpServletResponse response, ModelMap model, @PathVariable Long rid)
            throws Exception {

        log.info("get  role : role id = " + rid);

        try {
            List<Long> mids = new ArrayList<Long>();

            model.addAttribute("rid", rid);
            Role role = roleService.getObjectById(rid);
            if (role == null) {
                model.addAttribute("code", -7001);
                return "/common/success";
            } else {
                List<Long> roleModuleIds = roleModuleService.getRoleModuleIdsByRid(rid, 0, Integer.MAX_VALUE);
                List<RoleModule> roleModules = roleModuleService.getObjectsByIds(roleModuleIds);

                for (RoleModule rm : roleModules) {
                    mids.add(rm.getMid());
                }
                model.addAttribute("role", role);

            }
            model.addAttribute("code", 0);
            model.addAttribute("mids", mids);

        } catch (Throwable t) {
            log.error(t.getMessage());
            log.error("update role error,id is  " + rid);
            model.addAttribute("code", -100000);

        }

        return "/common-skill-service/role/json/roleJson";
    }


    @RequestMapping(value = "/a/u/role/stop/{id}", method = RequestMethod.PUT)
    public String stopRole(HttpServletRequest request,
                           HttpServletResponse response, ModelMap model, Role role)
            throws Exception {

        log.info("update role : role= " + role);

        try {
            List<Long> managerIds = managerService.getManagerIdsByRoleIDAndStatus(
                    role.getId(), Manager.STATUS_USING, null, null);
            if (managerIds.size() > 0) {
                log.info("manager with status using has this role");
                model.addAttribute("code", -7005);
            } else {
                String userId = cookieUtil.getKeyIdentity(request,
                        CookieUtil.USER_ID);
                role.setUpdateBy(Long.valueOf(userId));

                roleService.update(role);

                model.addAttribute("code", 0);

                model.addAttribute("role", role);
            }

        } catch (Throwable t) {
            log.error(t.getMessage());
            log.error("update role error,id is  " + role.getId());
            model.addAttribute("code", -100000);

        }

        return "/common/success";
    }


}

