package com.ptteng.keeper.admin.interceptor;

import com.ptteng.keeper.admin.model.Manager;
import com.ptteng.keeper.admin.model.Module;
import com.ptteng.keeper.admin.model.RoleModule;
import com.ptteng.keeper.admin.service.ManagerService;
import com.ptteng.keeper.admin.service.ModuleService;
import com.ptteng.keeper.admin.service.RoleModuleService;
import com.ptteng.keeper.admin.service.RoleService;
import com.qding.common.util.http.cookie.CookieUtil;
import com.qding.common.util.http.cookie.UserCryptUtil;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UserInterceptor extends HandlerInterceptorAdapter {

    private static final Log log = LogFactory.getLog(UserInterceptor.class);

    @Autowired
    private ManagerService managerService;
    @Autowired
    private RoleService roleService;

    @Autowired
    private ModuleService moduleService;

    @Autowired
    private RoleModuleService roleModuleService;
    public static String SPLITTER_REGEX = "\\|";
    public static final String USER_ID = "userId";

    @Autowired
    private CookieUtil cookieUtil;

    @Override
    public boolean preHandle(HttpServletRequest request,
                             HttpServletResponse response, Object handler) throws Exception {
        log.info("intercepter preHandle start ...");

        String token = request.getParameter("token");
        if (null == token) {
            token = request.getHeader("token");
        }
        log.info(" intercept token is    " + token);

        Cookie[] cookies = request.getCookies();
        Map<String, String> maps = cookieUtil.getIdentity(request);
        Long uid = cookieUtil.getID(request);


        log.info(uid);
        if (uid == null) {
            log.error("not legal user request");
            return noLogin(response);
        }
        Manager manager = this.managerService.getObjectById(uid);
        if (manager == null) {
            log.error(uid + " not get any data ");
            return noLogin(response);
        } else {
            log.info("get manager name " + manager.getName());
            request.setAttribute("manager", manager);
        }
        log.info("get uid is " + uid);


        String requestUrl = this.getInterceptorUrl(request);

        List<Long> roleModuleIds = roleModuleService.getRoleModuleIdsByRid(manager.getRoleID(), 0, Integer.MAX_VALUE);
        List<RoleModule> roleModules = roleModuleService.getObjectsByIds(roleModuleIds);
        List<Long> mids = new ArrayList<Long>();
        for (RoleModule roleModule : roleModules) {
            mids.add(roleModule.getMid());
        }
        List<Module> modules = moduleService.getObjectsByIds(mids);
        boolean flag = false;
        String[] requestUrls = requestUrl.split("\\?");
        for (Module module : modules) {

            if (module.getUrl() != null) {


                String[] moduleUrls = module.getUrl().split("\\.");
                if (moduleUrls.length > 1) {
                    if (requestUrls[0].contains(moduleUrls[1]))
                        log.info(uid + " is have module " + moduleUrls[1]);
                    flag = true;
                    break;
                }

            } else {
                flag = true;
            }

        }


        if (flag == false) {
            log.info(uid + " is don't have module " + requestUrl);
            return noPermission(response);
        }

        return true;
    }

    public static Map getUserIdentity(String userName, Long userId) {
        Map map = new HashMap();
        map.put(CookieUtil.USER_NAME, userName);
        map.put(CookieUtil.USER_ID, userId);
        return map;
    }

    private Map decodeCookie(String value) {
        if (StringUtils.isBlank(value))
            return null;
        try {
            String[] p = value.split(SPLITTER_REGEX);
            Long userId = new Long(p[0]);
            String crypt = p[1];
            String plainUserInfo = UserCryptUtil.userDecrypt(crypt);
            String userName = UserCryptUtil.getUserNameFromPlain(plainUserInfo);
            Long uid = UserCryptUtil.getUserIdFromPlain(plainUserInfo);
            if (userId.equals(uid)) {
                return getUserIdentity(userName, userId);
            }
        } catch (Exception e) {
            e.printStackTrace();
            log.error("Wrong cookie format: [" + value + "] message is:" + e.getMessage());
            return null;
        }

        return null;
    }

    private boolean noPermission(HttpServletResponse response) throws IOException {

        response.sendRedirect("/noPermissin");
        return false;

    }

    private boolean noLogin(HttpServletResponse response) throws IOException {

        response.sendRedirect("/nologin");
        return false;

    }

    @Override
    public void postHandle(HttpServletRequest request,
                           HttpServletResponse response, Object handler,
                           ModelAndView modelAndView) throws Exception {

        log.info("p =========================================== ");
    }

    /**
     * 获取跳转链接的地址
     *
     * @param request
     * @return
     */
    public String getInterceptorUrl(HttpServletRequest request) {

        String interceptorUrl = request.getRequestURI()
                + (null == request.getQueryString() ? "" : "?"
                + request.getQueryString()).toString();
        interceptorUrl = interceptorUrl.replace("/app/", "/");


        return interceptorUrl;
    }

    public static void main(String[] args) throws UnsupportedEncodingException {

        String x = URLEncoder.encode("p/hello", "utf-8");
        log.info(x);

    }
}
