/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.judao.pay.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.judao.pay.model.PayOrder;
import com.ptteng.judao.pay.service.PayOrderService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PayOrderServiceImpl
extends BaseDaoServiceImpl
implements PayOrderService {
    private static final Log log = LogFactory.getLog(PayOrderServiceImpl.class);

    public Long insert(PayOrder payOrder) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + payOrder));
        if (payOrder == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        payOrder.setCreateAt(Long.valueOf(currentTimeMillis));
        payOrder.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)payOrder);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + payOrder));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<PayOrder> insertList(List<PayOrder> payOrderList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (payOrderList == null ? "null" : Integer.valueOf(payOrderList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(payOrderList)) {
            return new ArrayList<PayOrder>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (PayOrder payOrder : payOrderList) {
            payOrder.setCreateAt(Long.valueOf(currentTimeMillis));
            payOrder.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(payOrderList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + payOrderList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(PayOrder.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(PayOrder payOrder) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (payOrder == null ? "null" : payOrder.getId())));
        boolean result = false;
        if (payOrder == null) {
            return true;
        }
        payOrder.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)payOrder);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + payOrder));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + payOrder));
        }
        return result;
    }

    public boolean updateList(List<PayOrder> payOrderList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (payOrderList == null ? "null" : Integer.valueOf(payOrderList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(payOrderList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (PayOrder payOrder : payOrderList) {
            payOrder.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(payOrderList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + payOrderList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + payOrderList.size()));
        return result;
    }

    public PayOrder getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        PayOrder payOrder = null;
        if (id == null) {
            return payOrder;
        }
        try {
            payOrder = (PayOrder)this.dao.get(PayOrder.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return payOrder;
    }

    public List<PayOrder> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List payOrder = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<PayOrder>();
        }
        try {
            payOrder = this.dao.getList(PayOrder.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (payOrder == null ? "null" : Integer.valueOf(payOrder.size()))));
        return payOrder;
    }

    public List<Long> getPayOrderIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getPayOrderIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countPayOrderIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getPayOrderIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getPayOrderIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }

    public Long getPayOrderIdByOrderNo(String orderNo) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id by orderNo  : " + orderNo));
        }
        Long id = null;
        try {
            id = (Long)this.dao.getMapping("getPayOrderIdByOrderNo", new Object[]{orderNo});
        }
        catch (DaoException e) {
            log.error((Object)(" get id wrong by orderNo  : " + orderNo));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id success : " + id));
        }
        return id;
    }
}

