/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.judao.etl.unit;

import com.qding.common.util.DataUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DynamicUtil {
    private static final Log log = LogFactory.getLog(DynamicUtil.class);

    public static Map<String, Object> getGameOrderList(Integer status, Long endAt, boolean count) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (DataUtils.isNotNullOrEmpty((Object)status)) {
            map.put("status", status);
        }
        if (DataUtils.isNotNullOrEmpty((Object)endAt)) {
            map.put("create_at &  <= ", endAt);
        }
        if (count) {
            map.put("@query", "count(game_order_id)");
        } else {
            map.put("@order", "create_at desc");
            map.put("@query", "game_order_id");
        }
        map.put("@table", "game_orders");
        return map;
    }

    public static Map<String, Object> getGameOrderByBeater(Integer status, Long endAt, boolean count) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (DataUtils.isNotNullOrEmpty((Object)status)) {
            map.put("status", status);
        }
        if (DataUtils.isNotNullOrEmpty((Object)endAt)) {
            map.put("receipt_time &  <= ", endAt);
        }
        if (count) {
            map.put("@query", "count(game_order_id)");
        } else {
            map.put("@order", "create_at desc");
            map.put("@query", "game_order_id");
        }
        map.put("@table", "game_orders");
        return map;
    }

    public static Map<String, Object> getGameOrderbyQuestion(Integer status, Long endAt, boolean count) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (DataUtils.isNotNullOrEmpty((Object)status)) {
            map.put("status", status);
        }
        if (DataUtils.isNotNullOrEmpty((Object)endAt)) {
            map.put("chargeback_time &  <= ", endAt);
        }
        if (count) {
            map.put("@query", "count(game_order_id)");
        } else {
            map.put("@order", "create_at desc");
            map.put("@query", "game_order_id");
        }
        map.put("@table", "game_orders");
        return map;
    }

    public static Map<String, Object> getGameOrderbyOverdue(List<Integer> statusList, Long endAt, boolean count) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (CollectionUtils.isNotEmpty(statusList)) {
            StringBuffer sb = new StringBuffer();
            if (statusList.size() > 1) {
                for (Integer status : statusList) {
                    sb.append(status.toString());
                    sb.append(",");
                }
                sb.deleteCharAt(sb.length() - 1);
                map.put("status & in ", "(" + sb.toString() + ")");
            } else {
                map.put("status", statusList.get(0));
            }
        }
        if (DataUtils.isNotNullOrEmpty((Object)endAt)) {
            map.put("overdue_time &  <= ", endAt);
        }
        if (count) {
            map.put("@query", "count(game_order_id)");
        } else {
            map.put("@order", "create_at desc");
            map.put("@query", "game_order_id");
        }
        map.put("@table", "game_orders");
        return map;
    }

    public static Map<String, Object> getGameOrderAcceptanceTimeOut(Integer status, Long endAt, boolean count) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (DataUtils.isNotNullOrEmpty((Object)status)) {
            map.put("status", status);
        }
        if (DataUtils.isNotNullOrEmpty((Object)endAt)) {
            map.put("completed_time &  <= ", endAt);
        }
        if (count) {
            map.put("@query", "count(game_order_id)");
        } else {
            map.put("@order", "create_at desc");
            map.put("@query", "game_order_id");
        }
        map.put("@table", "game_orders");
        return map;
    }

    public static Map<String, Object> getRefuseTime(Integer status, Long endAt, boolean count) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (DataUtils.isNotNullOrEmpty((Object)status)) {
            map.put("status", status);
        }
        if (DataUtils.isNotNullOrEmpty((Object)endAt)) {
            map.put("refuse_time &  <= ", endAt);
        }
        if (count) {
            map.put("@query", "count(game_order_id)");
        } else {
            map.put("@order", "create_at desc");
            map.put("@query", "game_order_id");
        }
        map.put("@table", "game_orders");
        return map;
    }
}

