/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.judao.etl;

import com.ptteng.judao.common.model.GameOrders;
import com.ptteng.judao.common.model.Studio;
import com.ptteng.judao.common.model.User;
import com.ptteng.judao.common.service.GameOrdersService;
import com.ptteng.judao.common.service.StudioService;
import com.ptteng.judao.common.service.UserService;
import com.ptteng.judao.etl.BillTimeOut;
import com.ptteng.judao.etl.unit.ConfigUtil;
import com.ptteng.judao.etl.unit.CreateUtil;
import com.ptteng.judao.etl.unit.DynamicUtil;
import com.ptteng.judao.pay.model.AmountRecord;
import com.ptteng.judao.pay.service.AmountRecordService;
import com.ptteng.judao.pay.service.PayOrderService;
import com.qding.common.util.DataUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RejectTimeOut {
    private static final Log log = LogFactory.getLog(BillTimeOut.class);
    private GameOrdersService gameOrdersService;
    private UserService userService;
    private PayOrderService payOrderService;
    private AmountRecordService amountRecordService;
    private StudioService studioService;
    private static final String userTime = ConfigUtil.getProperty("two_day");
    private static final int TASK_LEN = 10;
    private static boolean flag = false;

    public PayOrderService getPayOrderService() {
        return this.payOrderService;
    }

    public void setPayOrderService(PayOrderService payOrderService) {
        this.payOrderService = payOrderService;
    }

    public StudioService getStudioService() {
        return this.studioService;
    }

    public void setStudioService(StudioService studioService) {
        this.studioService = studioService;
    }

    public AmountRecordService getAmountRecordService() {
        return this.amountRecordService;
    }

    public void setAmountRecordService(AmountRecordService amountRecordService) {
        this.amountRecordService = amountRecordService;
    }

    public UserService getUserService() {
        return this.userService;
    }

    public void setUserService(UserService userService) {
        this.userService = userService;
    }

    public GameOrdersService getGameOrdersService() {
        return this.gameOrdersService;
    }

    public void setGameOrdersService(GameOrdersService gameOrdersService) {
        this.gameOrdersService = gameOrdersService;
    }

    public void process() {
        log.info((Object)"\u8be2\u62d2\u6536\u5355\u8d85\u65f6\u7684\u8ba2\u5355");
        try {
            Long endAt = System.currentTimeMillis() - Long.valueOf(userTime);
            Map<String, Object> map = DynamicUtil.getRefuseTime(GameOrders.STATUS_REFUSED, endAt, false);
            do {
                List ids;
                if (CollectionUtils.isEmpty((Collection)(ids = this.gameOrdersService.getIdsByDynamicCondition(GameOrders.class, map, Integer.valueOf(0), Integer.valueOf(10))))) {
                    log.info((Object)"not get any more than 15 minute rent orders ");
                    flag = false;
                    continue;
                }
                if (ids.size() < 10) {
                    log.info((Object)"not have next page");
                    flag = false;
                } else {
                    log.info((Object)"have next page");
                    flag = true;
                }
                List gameOrdersList = this.gameOrdersService.getObjectsByIds(ids);
                for (GameOrders gameOrders : gameOrdersList) {
                    log.info((Object)"order status payout");
                    if (!gameOrders.getStatus().equals(GameOrders.STATUS_REFUSED)) {
                        log.error((Object)"order status is error");
                        return;
                    }
                    if (GameOrders.GAME_ORDER_TYPE_HOME.equals(gameOrders.getType())) {
                        BigDecimal currentLimit;
                        Studio studio;
                        AmountRecord beaterMargin;
                        BigDecimal marginStart;
                        User beater = this.userService.getObjectById(gameOrders.getReceiverId());
                        User user = this.userService.getObjectById(gameOrders.getBillerId());
                        if (DataUtils.isNullOrEmpty((Object)beater) || DataUtils.isNullOrEmpty((Object)user)) {
                            log.info((Object)"beater is null");
                            return;
                        }
                        gameOrders.setStatus(GameOrders.STATUS_REFUND);
                        this.gameOrdersService.update(gameOrders);
                        log.info((Object)"update success");
                        BigDecimal payOutAmount = gameOrders.getPayoutAmount();
                        BigDecimal totalAmount = gameOrders.getPrice().add(gameOrders.getMargin());
                        BigDecimal deserveAmount = totalAmount.subtract(payOutAmount);
                        Integer result = deserveAmount.compareTo(gameOrders.getMargin());
                        log.info((Object)("deserve amount is : " + deserveAmount));
                        log.info((Object)("margin amount is : " + gameOrders.getMargin()));
                        ArrayList<AmountRecord> amountRecordList = new ArrayList<AmountRecord>();
                        if (result.equals(0)) {
                            if (User.TYPE_PERSONAL.equals(beater.getType())) {
                                marginStart = beater.getMarginBalance();
                                beater.setMarginBalance(marginStart.add(gameOrders.getMargin()));
                                beaterMargin = CreateUtil.getAmountRecord(beater.getId(), gameOrders.getGameOrderNo(), gameOrders.getRequirement(), gameOrders.getRemark(), marginStart, gameOrders.getMargin(), beater.getMarginBalance(), 40, 30, 10);
                                amountRecordList.add(beaterMargin);
                            } else if (User.TYPE_STUDIO.equals(beater.getType())) {
                                studio = this.studioService.getObjectById(beater.getStudioId());
                                if (DataUtils.isNullOrEmpty((Object)studio)) {
                                    log.info((Object)"studio is null");
                                    return;
                                }
                                currentLimit = studio.getCurrentLimit();
                                studio.setCurrentLimit(currentLimit.add(gameOrders.getMargin()));
                                this.studioService.update(studio);
                            }
                        } else if (result.equals(1)) {
                            AmountRecord beaterBalance;
                            BigDecimal accountStart;
                            BigDecimal balance;
                            if (User.TYPE_PERSONAL.equals(beater.getType())) {
                                marginStart = beater.getMarginBalance();
                                beater.setMarginBalance(marginStart.add(gameOrders.getMargin()));
                                beaterMargin = CreateUtil.getAmountRecord(beater.getId(), gameOrders.getGameOrderNo(), gameOrders.getRequirement(), gameOrders.getRemark(), marginStart, gameOrders.getMargin(), beater.getMarginBalance(), 40, 30, 10);
                                amountRecordList.add(beaterMargin);
                                balance = deserveAmount.subtract(gameOrders.getMargin());
                                accountStart = beater.getAccountBalance();
                                beater.setAccountBalance(accountStart.add(balance));
                                beaterBalance = CreateUtil.getAmountRecord(beater.getId(), gameOrders.getGameOrderNo(), gameOrders.getRequirement(), gameOrders.getRemark(), accountStart, balance, beater.getAccountBalance(), 50, 10, 10);
                                amountRecordList.add(beaterBalance);
                            } else if (User.TYPE_STUDIO.equals(beater.getType())) {
                                studio = this.studioService.getObjectById(beater.getStudioId());
                                if (DataUtils.isNullOrEmpty((Object)studio)) {
                                    log.info((Object)"studio is null");
                                    return;
                                }
                                currentLimit = studio.getCurrentLimit();
                                studio.setCurrentLimit(currentLimit.add(gameOrders.getMargin()));
                                this.studioService.update(studio);
                                balance = deserveAmount.subtract(gameOrders.getMargin());
                                accountStart = beater.getAccountBalance();
                                beater.setAccountBalance(accountStart.add(balance));
                                beaterBalance = CreateUtil.getAmountRecord(beater.getId(), gameOrders.getGameOrderNo(), gameOrders.getRequirement(), gameOrders.getRemark(), accountStart, balance, beater.getAccountBalance(), 50, 10, 10);
                                amountRecordList.add(beaterBalance);
                            }
                        } else if (result.equals(-1)) {
                            if (User.TYPE_PERSONAL.equals(beater.getType())) {
                                marginStart = beater.getMarginBalance();
                                beater.setMarginBalance(marginStart.add(deserveAmount));
                                beaterMargin = CreateUtil.getAmountRecord(beater.getId(), gameOrders.getGameOrderNo(), gameOrders.getRequirement(), gameOrders.getRemark(), marginStart, deserveAmount, beater.getMarginBalance(), 40, 30, 10);
                                amountRecordList.add(beaterMargin);
                            } else if (User.TYPE_STUDIO.equals(beater.getType())) {
                                AmountRecord beaterMarginEnd;
                                AmountRecord beaterBalance;
                                studio = this.studioService.getObjectById(beater.getStudioId());
                                if (DataUtils.isNullOrEmpty((Object)studio)) {
                                    log.info((Object)"studio is null");
                                    return;
                                }
                                currentLimit = studio.getCurrentLimit();
                                studio.setCurrentLimit(currentLimit.add(gameOrders.getMargin()));
                                this.studioService.update(studio);
                                BigDecimal margin = gameOrders.getMargin().subtract(deserveAmount);
                                BigDecimal marginStart2 = beater.getMarginBalance();
                                beater.setMarginBalance(marginStart2.subtract(margin));
                                AmountRecord beaterMargin2 = CreateUtil.getAmountRecord(beater.getId(), gameOrders.getGameOrderNo(), gameOrders.getRequirement(), gameOrders.getRemark(), marginStart2, margin, beater.getMarginBalance(), 30, 30, 10);
                                amountRecordList.add(beaterMargin2);
                                BigDecimal balance = beater.getAccountBalance();
                                Integer flag = balance.compareTo(margin);
                                if (flag.equals(-1)) {
                                    beater.setAccountBalance(balance.subtract(balance));
                                    beaterBalance = CreateUtil.getAmountRecord(beater.getId(), gameOrders.getGameOrderNo(), gameOrders.getRequirement(), gameOrders.getRemark(), balance, balance, beater.getAccountBalance(), 30, 10, 10);
                                    amountRecordList.add(beaterBalance);
                                    beater.setMarginBalance(beater.getMarginBalance().add(balance));
                                    beaterMarginEnd = CreateUtil.getAmountRecord(beater.getId(), gameOrders.getGameOrderNo(), gameOrders.getRequirement(), gameOrders.getRemark(), balance, balance, beater.getAccountBalance(), 50, 30, 10);
                                    amountRecordList.add(beaterMarginEnd);
                                } else {
                                    beater.setAccountBalance(balance.subtract(margin));
                                    beaterBalance = CreateUtil.getAmountRecord(beater.getId(), gameOrders.getGameOrderNo(), gameOrders.getRequirement(), gameOrders.getRemark(), balance, margin, beater.getAccountBalance(), 30, 10, 10);
                                    amountRecordList.add(beaterBalance);
                                    beater.setMarginBalance(beater.getMarginBalance().add(margin));
                                    beaterMarginEnd = CreateUtil.getAmountRecord(beater.getId(), gameOrders.getGameOrderNo(), gameOrders.getRequirement(), gameOrders.getRemark(), balance, margin, beater.getAccountBalance(), 50, 30, 10);
                                    amountRecordList.add(beaterMarginEnd);
                                }
                            }
                        }
                        BigDecimal userStartAmount = user.getAccountBalance();
                        user.setAccountBalance(userStartAmount.add(gameOrders.getPayoutAmount()));
                        ArrayList<User> userList = new ArrayList<User>();
                        userList.add(beater);
                        userList.add(user);
                        this.userService.updateList(userList);
                        AmountRecord end = CreateUtil.getAmountRecord(user.getId(), gameOrders.getGameOrderNo(), gameOrders.getRequirement(), gameOrders.getRemark(), userStartAmount, gameOrders.getPayoutAmount(), user.getAccountBalance(), 40, 10, 10);
                        amountRecordList.add(end);
                        this.amountRecordService.insertList(amountRecordList);
                    } else if (GameOrders.GAME_ORDER_TYPE_ADMIN.equals(gameOrders.getType())) {
                        return;
                    }
                    log.info((Object)"===============update game order payout end================");
                }
            } while (flag);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error((Object)"update game order list  fail===");
        }
    }
}

